/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogServer;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class DomainLogServer
extends BaseStatusSO
implements LogServer,
Comparable {
    private EnvDomain _domain = null;
    private String _name = null;
    private static final String GET_LOG_SERVER = "GET_LOG_SERVER";
    private static final Object[][] contents = new Object[][]{{"GET_LOG_SERVER", new Integer(1200), "rmp_logical_servers ''{0}''"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainLogServer(String string, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty logical data server parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._name = string;
        this._domain = envDomain;
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        }
        this.setReportEvent(false);
    }

    public int compareTo(Object object) {
        if (object instanceof DomainLogServer) {
            return this.getName().compareTo(((DomainLogServer)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-DomainLogServer object.");
        return -1;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getStateString() {
        switch (this.getRSState()) {
            case 5: {
                return BundleManager.getString("LogicalConnectionRes", "ACTIVE_STATE");
            }
            case 2: {
                return BundleManager.getString("LogicalConnectionRes", "SUSPENDED_STATE");
            }
            case 3: 
            case 4: {
                return BundleManager.getString("LogicalConnectionRes", "SUSPECT_STATE");
            }
            case 0: {
                return BundleManager.getString("LogicalConnectionRes", "DOWN_STATE");
            }
        }
        Dbg.wassert(false, "Unexpected Log Server State");
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List getLogServers(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        ArrayList<DomainLogServer> arrayList = new ArrayList<DomainLogServer>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            int n = envDomain.getVersionNumber(string);
            String string2 = _cmdBundle.getCommand(GET_LOG_SERVER, n, string);
            Dbg.wassert(string2 != null, "Unable to get query command, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    if (string3 == null || string3.length() <= 0) continue;
                    DomainLogServer domainLogServer = new DomainLogServer(string3, envDomain);
                    arrayList.add(domainLogServer);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List getLogServers(EnvDomain envDomain) throws SQLException {
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        ArrayList<LogServer> arrayList = new ArrayList<LogServer>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(envDomain.getName());
        ListIterator listIterator = semanticFactory.getRepServers().listIterator();
        while (listIterator.hasNext()) {
            RepServer repServer = (RepServer)listIterator.next();
            ListIterator listIterator2 = DomainLogServer.getLogServers(repServer.getName(), envDomain).listIterator();
            while (listIterator2.hasNext()) {
                LogServer logServer = (LogServer)listIterator2.next();
                boolean bl = false;
                ListIterator listIterator3 = arrayList.listIterator();
                while (listIterator3.hasNext() && !bl) {
                    LogServer logServer2 = (LogServer)listIterator3.next();
                    if (!logServer2.getName().equals(logServer.getName())) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(logServer);
            }
        }
        return arrayList;
    }

    public void monitor() {
        this.setState(5);
        this.clearReasons();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        try {
            ListIterator listIterator = semanticFactory.getLogConnectionsforLDS(this.getName()).listIterator();
            while (listIterator.hasNext()) {
                LogConnection logConnection = (LogConnection)listIterator.next();
                if (logConnection.isUp()) continue;
                this.setState(4);
                this.addReason(logConnection.getReasons());
            }
        }
        catch (SQLException sQLException) {
            this.setState(0);
            this.addReason(MessageText.formatExceptionMessage(sQLException));
            PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }
}

