/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.logical.AddActiveConnWizard;
import com.sybase.rsmplugin.components.logical.AddStandbyConnWizard;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogConnectionProp;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.RCLEditor;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public abstract class LogConnectionBase
extends BaseContainer
implements StatusItem {
    private static final int CMD_SWITCH = 3008;
    private static final int CMD_ABORT = 3009;
    private static final int CMD_ADD_ACTIVE = 3010;
    private static final int CMD_ADD_STANDBY = 3011;
    public static ImageIcon _iconUp = null;
    public static ImageIcon _iconDown = null;
    public static ImageIcon _iconSuspect = null;
    private LogConnection _so;

    public LogConnectionBase(LogConnection logConnection, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(logConnection != null, "Null logical connection semantic object parameter.");
        this._so = logConnection;
        StatusManager.addStatusItem(this);
    }

    public LogConnectionBase(LogConnection logConnection) {
        Dbg.wassert(logConnection != null, "Null physical connection semantic object parameter.");
        this._so = logConnection;
        StatusManager.addStatusItem(this);
    }

    public LogConnection getLogConnection() {
        return this._so;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getLogConnUp());
        }
        return _iconUp;
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("DatabaseRes", "COL_HEADER_NAME")};
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getLogConnection().isUp()) {
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getLogConnUp());
            }
            return _iconUp;
        }
        if (this.getLogConnection().isError()) {
            if (_iconDown == null) {
                _iconDown = new ImageIcon(RSMImages.getLogConnDown());
            }
            return _iconDown;
        }
        if (_iconSuspect == null) {
            _iconSuspect = new ImageIcon(RSMImages.getLogConnSuspect());
        }
        return _iconSuspect;
    }

    @Override
    public String getDisplayName(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = this.getName();
                break;
            }
            case 1: {
                string = this.getLogConnection().getActiveConnectionName();
                break;
            }
            case 2: {
                string = this.getLogConnection().getStandbyConnectionName();
                break;
            }
            case 3: {
                string = this.getLogConnection().getStateDescription();
                break;
            }
            case 4: {
                string = this.getLogConnection().getReason();
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu = null;
        defaultSCMenu = new DefaultSCMenu();
        if (!this.getLogConnection().isControlledByRSMS()) {
            String string = BundleManager.getString("LogicalConnectionRes", "MENU_SWITCH");
            String string2 = BundleManager.getString("LogicalConnectionRes", "MENU_HINT_SWITCH");
            char c = BundleManager.getMnemonic("LogicalConnectionRes", "MENU_MNEM_SWITCH");
            MenuItem menuItem = new MenuItem(3008, string, string2, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            string = BundleManager.getString("LogicalConnectionRes", "MENU_ABORT");
            string2 = BundleManager.getString("LogicalConnectionRes", "MENU_HINT_ABORT");
            c = BundleManager.getMnemonic("LogicalConnectionRes", "MENU_MNEM_ABORT");
            menuItem = new MenuItem(3009, string, string2, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            if (!this.getLogConnection().isActiveDefined()) {
                string = BundleManager.getString("LogicalConnectionRes", "MENU_ADD_ACTIVE");
                string2 = BundleManager.getString("LogicalConnectionRes", "MENU_HINT_ADD_ACTIVE");
                c = BundleManager.getMnemonic("LogicalConnectionRes", "MENU_MNEM_ADD_ACTIVE");
                menuItem = new MenuItem(3010, string, string2, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
            } else if (!this.getLogConnection().isStandbyDefined()) {
                string = BundleManager.getString("LogicalConnectionRes", "MENU_ADD_STANDBY");
                string2 = BundleManager.getString("LogicalConnectionRes", "MENU_HINT_ADD_STANDBY");
                c = BundleManager.getMnemonic("LogicalConnectionRes", "MENU_MNEM_ADD_STANDBY");
                menuItem = new MenuItem(3011, string, string2, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
            }
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getRCLGenMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        }
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        if (this.getLogConnection().isControlledByRSMS()) {
            return 0;
        }
        return 96;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                if (this.getLogConnection().isControlledByRSMS()) break;
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof LogConnectionBase)) continue;
                    ((LogConnectionBase)baseItem).drop();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 3008: {
                if (!PluginSupport.askQuestion(BundleManager.getString("LogicalConnectionRes", "MSG_CONFIRM_SWITCH", this.getLogConnection().getName()))) break;
                this.getLogConnection().switchActive();
                break;
            }
            case 3009: {
                if (!PluginSupport.askQuestion(BundleManager.getString("LogicalConnectionRes", "MSG_CONFIRM_ABORT", this.getLogConnection().getName()))) break;
                try {
                    this.getLogConnection().abortSwitch();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                break;
            }
            case 3010: {
                BaseController baseController = PluginSupport.getDialog(AddActiveConnWizard.class);
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                AddActiveConnWizard addActiveConnWizard = new AddActiveConnWizard(this, PluginSupport.getDialogSupport(jFrame), this.getLogConnection().getControllingRS(), this.getLogConnection().getDomainName());
                addActiveConnWizard.showDialog();
                break;
            }
            case 3011: {
                BaseController baseController = PluginSupport.getDialog(AddStandbyConnWizard.class);
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                AddStandbyConnWizard addStandbyConnWizard = new AddStandbyConnWizard(this, PluginSupport.getDialogSupport(jFrame), this.getLogConnection().getControllingRS(), this.getLogConnection().getDomainName());
                addStandbyConnWizard.showDialog();
                break;
            }
            case 3001: {
                RCLEditor.open(this._so.getRCLScript());
                break;
            }
            case 107: {
                BaseController baseController = PluginSupport.getDialog(LogConnectionProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                LogConnectionProp logConnectionProp = new LogConnectionProp(this.getLogConnection(), this, sCDialogSupport2);
                logConnectionProp.showDialog();
                break;
            }
        }
    }

    protected void drop() {
        try {
            this.getLogConnection().drop();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    @Override
    public void setState(int n) {
        this.getLogConnection().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getLogConnection().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getLogConnection().getDomainName();
    }

    @Override
    public String getType() {
        return this.getLogConnection().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getLogConnection().getStateDescription();
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }
}

