/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.ConfigParameter;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class LogConnectionParameter
implements RSMObjectRow,
ConfigParameter {
    public static final int NAME_COLUMN = 0;
    public static final int DATATYPE_COLUMN = 1;
    public static final int LEGAL_VALUE_COLUMN = 2;
    public static final int DEFAULT_COLUMN = 3;
    public static final int RESTART_COLUMN = 4;
    public static final int SERVER_RESTART_YES = 0;
    public static final int SERVER_RESTART_NO = 1;
    public static final int CONN_RESTART_YES = 2;
    public static final int CONN_RESTART_NO = 3;
    public static final String DISTRIBUTION_PARAM = "distribution";
    public static final String MAT_INTERVAL_PARAM = "materialization_save_interval";
    public static final String SAVE_INTERVAL_PARAM = "save_interval";
    public static final Object[][] _details = new Object[][]{{"distribution", new Integer(3), "list: on, off", "on", new Integer(2)}, {"materialization_save_interval", new Integer(2), "number of minutes or 'strict'", "strict", new Integer(2)}, {"replicate_minimal_columns", new Integer(3), "list: on, off", "on", new Integer(2)}, {"save_interval", new Integer(2), "number of minutes or 'strict'", "0", new Integer(2)}, {"send_standby_repdef_cols", new Integer(2), "list: on, off, check_repdef", "check_repdef", new Integer(2)}, {"send_truncate_table", new Integer(3), "list: on, off", "on", new Integer(2)}, {"ws_sqldml_replication", new Integer(3), "list: on, off", "on", new Integer(2)}};
    private String _name;
    private String _currentValue;
    private String _pendingValue;
    private String _originalPendingValue;
    private String _defaultValue;
    private String _legalValues;
    private String _status;
    private int _datatype;
    private static final int COLUMN_COUNT = 3;

    public LogConnectionParameter(String string, String string2, String string3) {
        this._name = string;
        this._currentValue = string2;
        this._pendingValue = string3;
        this._defaultValue = null;
        this._legalValues = null;
        this._status = null;
        this._datatype = -1;
        this.resetOriginalPendingValue();
    }

    public LogConnectionParameter(String string, String string2, String string3, String string4, String string5, String string6, int n) {
        this._name = string;
        this._currentValue = string2;
        this._pendingValue = string3;
        this._defaultValue = string4;
        this._legalValues = string5;
        this._status = string6;
        this._datatype = n;
        this.resetOriginalPendingValue();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract void alter(String var1, String var2, String var3) throws SQLException;

    public abstract String getRCLScript(String var1, String var2, String var3);

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getCurrentValue();
            }
            case 2: {
                if (!this.isModified() && this.getOriginalPendingValue().equals(this.getCurrentValue())) {
                    return "";
                }
                if (this.getDatatype() == 4) {
                    return "********";
                }
                return this.getPendingValue();
            }
        }
        return " ";
    }

    @Override
    public void setValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                this._name = (String)object;
                break;
            }
            case 1: {
                this._currentValue = (String)object;
                break;
            }
            case 2: {
                this._pendingValue = (String)object;
                break;
            }
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public String getPendingValue() {
        return this._pendingValue;
    }

    @Override
    public void setPendingValue(String string) {
        if (string != null && !this._pendingValue.equals(string)) {
            this._pendingValue = string;
        }
    }

    protected String getOriginalPendingValue() {
        return this._originalPendingValue;
    }

    public void resetOriginalPendingValue() {
        this._originalPendingValue = this._pendingValue;
    }

    @Override
    public boolean isModified() {
        return !this.getPendingValue().equals(this.getOriginalPendingValue());
    }

    @Override
    public String getDefaultValue() {
        if (this._defaultValue != null) {
            return this._defaultValue;
        }
        int n = this.getDetails();
        if (n == -1) {
            return " ";
        }
        return _details[n][3].toString();
    }

    @Override
    public String getStatus() {
        if (this._status != null) {
            return this._status;
        }
        int n = this.getDetails();
        if (n == -1) {
            return BundleManager.getString("ComponentRes", "Connection/route restart required");
        }
        int n2 = (Integer)_details[n][4];
        switch (n2) {
            case 0: {
                return BundleManager.getString("ComponentRes", "DISP_RESTART_YES_TEXT");
            }
            case 1: {
                return BundleManager.getString("ComponentRes", "DISP_RESTART_NO_TEXT");
            }
            case 2: {
                return BundleManager.getString("ComponentRes", "Connection/route restart required");
            }
            case 3: {
                return BundleManager.getString("ComponentRes", "Connection/route restart not required");
            }
        }
        return BundleManager.getString("ComponentRes", "Connection/route restart not required");
    }

    @Override
    public boolean isRestartRequired() {
        return false;
    }

    @Override
    public String getLegalValues() {
        if (this._legalValues != null) {
            return this._legalValues;
        }
        int n = this.getDetails();
        if (n == -1) {
            return " ";
        }
        return _details[n][2].toString();
    }

    @Override
    public String getExplanation() {
        String string;
        try {
            String string2 = "com.sybase.rsmplugin.resources.LogConnParamDescRes";
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2);
            string = resourceBundle.getString(this.getName());
        }
        catch (MissingResourceException missingResourceException) {
            string = " ";
        }
        return string;
    }

    @Override
    public int getDatatype() {
        if (this._datatype != -1) {
            return this._datatype;
        }
        int n = this.getDetails();
        if (n == -1) {
            return 2;
        }
        return (Integer)_details[n][1];
    }

    protected int getDetails() {
        int n = 0;
        int n2 = _details.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            String string = (String)_details[n3][0];
            int n4 = this.getName().compareTo(string);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 >= 0) continue;
            n2 = n3 - 1;
        }
        return -1;
    }
}

