/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.ConfigPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.ConnProperties;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.logical.LogConnGeneralPanel;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogConnectionParameter;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;

public class LogConnectionProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected LogConnection _logConn;
    protected BaseItem _item;
    protected List _paramList;

    public LogConnectionProp(LogConnection logConnection, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(logConnection != null, "Null Logical Connection parameter.");
        this._logConn = logConnection;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(logConnection.getDomainName());
        try {
            this._paramList = semanticFactory.getLogConnectionParameters(logConnection.getControllingRS(), logConnection.getLDS(), logConnection.getLDB());
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            this._paramList = new ArrayList();
        }
    }

    public LogConnection getLogConnection() {
        return this._logConn;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("LogicalConnectionRes", "PROPERTIES_TITLE", this.getLogConnection().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new ConfigPage((BaseProperties)this, this._paramList)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            LogConnectionParameter logConnectionParameter = (LogConnectionParameter)listIterator.next();
            if (logConnectionParameter == null) continue;
            try {
                logConnectionParameter.alter(this.getLogConnection().getControllingRS(), this.getLogConnection().getLDS(), this.getLogConnection().getLDB());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            return super.onOk();
        }
        return false;
    }

    @Override
    public void onApply() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            LogConnectionParameter logConnectionParameter = (LogConnectionParameter)listIterator.next();
            if (logConnectionParameter == null) continue;
            try {
                logConnectionParameter.alter(this.getLogConnection().getControllingRS(), this.getLogConnection().getLDS(), this.getLogConnection().getLDB());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            super.onApply();
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private LogConnGeneralPanel _goPage;
        private PhyConnection _activeConn;
        private PhyConnection _standbyConn;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("LogicalConnectionRes", "GENERAL_PAGE_TAG"));
            this._goPage = new LogConnGeneralPanel();
            this._activeConn = null;
            this._standbyConn = null;
            try {
                this._activeConn = LogConnectionProp.this.getLogConnection().getActiveConnection();
                this._standbyConn = LogConnectionProp.this.getLogConnection().getStandbyConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_name.setText(LogConnectionProp.this.getLogConnection().getName());
            this._goPage.fld_active.setText(LogConnectionProp.this.getLogConnection().getActiveConnectionName());
            if (this._activeConn != null) {
                this._goPage.fld_active_state.setText(this._activeConn.getRepAgentStateString());
                this._goPage.btn_active_prop.addActionListener((ActionListener)this);
            } else {
                this._goPage.fld_active_state.setText("");
            }
            this._goPage.fld_standby.setText(LogConnectionProp.this.getLogConnection().getStandbyConnectionName());
            if (this._standbyConn != null) {
                this._goPage.fld_standby_state.setText(this._standbyConn.getDSIStateString());
                this._goPage.btn_standby_prop.addActionListener((ActionListener)this);
            } else {
                this._goPage.fld_standby_state.setText("");
            }
            this._goPage.fld_reason.setText(LogConnectionProp.this.getLogConnection().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(LogConnectionProp.this.getLogConnection().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onOk() {
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), LogConnectionProp.this.getLogConnection().getReasons(), LogConnectionProp.this.getLogConnection().getName());
                reasonListDlg.showDialog();
            } else if (actionEvent.getSource() == this._goPage.btn_active_prop) {
                BaseController baseController = PluginSupport.getDialog(ConnProperties.class, LogConnectionProp.this.getLogConnection().getActiveConnectionName());
                if (baseController != null) {
                    baseController.requestFocus();
                } else {
                    try {
                        SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(PluginSupport.getViewerFrame());
                        PhyConnection phyConnection = LogConnectionProp.this.getLogConnection().getActiveConnection();
                        if (phyConnection != null) {
                            ConnProperties connProperties = new ConnProperties(phyConnection, LogConnectionProp.this.getItem(), sCDialogSupport2);
                            connProperties.showDialog();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    }
                }
            } else if (actionEvent.getSource() == this._goPage.btn_standby_prop) {
                BaseController baseController = PluginSupport.getDialog(ConnProperties.class, LogConnectionProp.this.getLogConnection().getStandbyConnectionName());
                if (baseController != null) {
                    baseController.requestFocus();
                } else {
                    try {
                        SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(PluginSupport.getViewerFrame());
                        PhyConnection phyConnection = LogConnectionProp.this.getLogConnection().getStandbyConnection();
                        if (phyConnection != null) {
                            ConnProperties connProperties = new ConnProperties(phyConnection, LogConnectionProp.this.getItem(), sCDialogSupport2);
                            connProperties.showDialog();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    }
                }
            }
        }
    }
}

