/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.central.SCItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogConnectionContainer;
import com.sybase.rsmplugin.components.logical.LogServer;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LogServerContainer
extends BaseContainer
implements RMContainer,
StatusItem {
    private static final String CLASS_ID = "logical.LogServerContainer";
    private LogServer _so;
    private static ImageIcon _iconUp = null;
    private static ImageIcon _iconDown = null;
    private static ImageIcon _iconSuspect = null;

    public LogServerContainer(LogServer logServer, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(logServer != null, "Null Logical Server Semantic object parameter.");
        this._so = logServer;
        StatusManager.addStatusItem(this);
    }

    public LogServerContainer(LogServer logServer) {
        Dbg.wassert(logServer != null, "Null Logical Server Semantic object parameter.");
        this._so = logServer;
        StatusManager.addStatusItem(this);
    }

    public LogServer getLogServer() {
        return this._so;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getLogServer());
        }
        return _iconUp;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getLogServer().isError()) {
            if (_iconDown == null) {
                _iconDown = new ImageIcon(RSMImages.getLogServerDown());
            }
            return _iconDown;
        }
        if (this.getLogServer().isWarning()) {
            if (_iconSuspect == null) {
                _iconSuspect = new ImageIcon(RSMImages.getLogServerSuspect());
            }
            return _iconSuspect;
        }
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getLogServer());
        }
        return _iconUp;
    }

    @Override
    public int getAttributes() {
        return 3;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName() + " ";
            }
            case 1: {
                return this.getLogServer().getStateString();
            }
            case 2: {
                return this.getLogServer().getReason();
            }
        }
        return "";
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            super.open(n);
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._so.getDomainName());
            try {
                ListIterator listIterator = semanticFactory.getLogConnectionsforLDS(this.getName()).listIterator();
                while (listIterator.hasNext()) {
                    LogConnection logConnection = (LogConnection)listIterator.next();
                    LogConnectionContainer logConnectionContainer = new LogConnectionContainer(logConnection, this);
                    this.addItem((SCItem)logConnectionContainer);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("LogicalConnectionRes", "COL_HEADER_LOG_CONN"), BundleManager.getString("LogicalConnectionRes", "COL_HEADER_ACTIVE"), BundleManager.getString("LogicalConnectionRes", "COL_HEADER_STANDBY"), BundleManager.getString("LogicalConnectionRes", "COL_HEADER_STATE"), BundleManager.getString("LogicalConnectionRes", "COL_HEADER_REASON")};
    }

    @Override
    public void setState(int n) {
        this.getLogServer().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getLogServer().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getLogServer().getDomainName();
    }

    @Override
    public String getType() {
        return this.getLogServer().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getLogServer().getStateString();
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    @Override
    public String getKey() {
        return super.getKey() + "-LDS";
    }
}

