/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseAddItem;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseFolder;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.logical.AddLogConnWizard;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.logical.LogConnectionItem;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class LogicalConnectionFolder
extends BaseFolder
implements RMContainer {
    public static final int CMD_ADD_LOGICAL = 3008;
    private static final String CLASS_ID = "logical.LogicalConnectionFolder";
    private String _name = BundleManager.getString("LogicalConnectionRes", "COL_FOLDER_NAME");
    private String _connName;

    public LogicalConnectionFolder(String string, BaseContainer baseContainer) {
        super(baseContainer);
        this._connName = string;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    public String getRepServerName() {
        return this.getParent().getName();
    }

    @Override
    public SCMenu getCreationMenu() {
        DefaultSCMenu defaultSCMenu = null;
        Domain domain = PluginSupport.getDomain(this._connName);
        if (domain != null && domain.isEnvironment()) {
            defaultSCMenu = new DefaultSCMenu();
            String string = BundleManager.getString("ConnectionRes", "MENU_ADD_CONN");
            String string2 = BundleManager.getString("ConnectionRes", "MENU_HINT_ADD_CONN");
            char c = BundleManager.getMnemonic("ConnectionRes", "MENU_MNEM_ADD_CONN");
            ImageIcon imageIcon = new ImageIcon(RSMImages.getConnectionUp());
            MenuItem menuItem = new MenuItem(3008, string, string2, c, imageIcon);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
        }
        return defaultSCMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3008: {
                BaseController baseController = PluginSupport.getDialog(AddLogConnWizard.class);
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                AddLogConnWizard addLogConnWizard = new AddLogConnWizard(this.getParent(), PluginSupport.getDialogSupport(jFrame), this.getRepServerName(), this._connName);
                addLogConnWizard.showDialog();
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            Domain domain = PluginSupport.getDomain(this._connName);
            if (domain != null && domain.isEnvironment()) {
                this.addItem((SCItem)new AddLogicalConnectionItem(this));
            }
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._connName);
            String string = this.getParent().getName();
            try {
                ListIterator listIterator = semanticFactory.getLogConnections(string).listIterator();
                while (listIterator.hasNext()) {
                    LogConnectionItem logConnectionItem = new LogConnectionItem((LogConnection)listIterator.next(), this);
                    this.addItem((SCItem)logConnectionItem);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("LogicalConnectionRes", "COL_HEADER_LOG_CONN"), BundleManager.getString("LogicalConnectionRes", "COL_HEADER_ACTIVE"), BundleManager.getString("LogicalConnectionRes", "COL_HEADER_STANDBY"), BundleManager.getString("LogicalConnectionRes", "COL_HEADER_STATE"), BundleManager.getString("LogicalConnectionRes", "COL_HEADER_REASON")};
    }

    class AddLogicalConnectionItem
    extends BaseAddItem {
        public AddLogicalConnectionItem(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("LogicalConnectionRes", "ADD_LOG_CONN_ITEM"), RSMImages.getAddLogConn());
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            BaseController baseController = PluginSupport.getDialog(AddLogConnWizard.class);
            if (baseController != null) {
                baseController.requestFocus();
            } else {
                AddLogConnWizard addLogConnWizard = new AddLogConnWizard(this.getParent(), PluginSupport.getDialogSupport(jFrame), LogicalConnectionFolder.this.getRepServerName(), LogicalConnectionFolder.this._connName);
                addLogConnWizard.showDialog();
            }
        }
    }
}

