/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.RMSStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.logical.LogConnection;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RMSLogConnection
extends RMSStatusSO
implements LogConnection {
    private String _LDS = null;
    private String _LDB = null;
    private String _activeDS = null;
    private String _activeDB = null;
    private String _standbyDS = null;
    private String _standbyDB = null;
    private boolean _logConnExists = false;
    private static final int LOGICAL_CONN_NOT_EXIST = 41061;
    private static final String PHY_CONN_NOT_SET = "None";
    private static final String GET_LOG_CONNS = "GET_LOG_CONNS";
    private static final String GET_LOG_CONN = "GET_LOG_CONN";
    private static final Object[][] contents = new Object[][]{{"GET_LOG_CONNS", new Integer(1200), "get logical connections for {0}"}, {"GET_LOG_CONN", new Integer(1200), "get logical connections for {0}, {1}.{2}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSLogConnection(String string, String string2, String string3, RMSDomain rMSDomain) {
        super(string, string2 + "." + string3, rMSDomain);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty DB parameter.");
        this._LDS = string2;
        this._LDB = string3;
        this.setState(3);
        this.clearReasons();
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "Logical Connection";
    }

    @Override
    public String getLDS() {
        Dbg.wassert(this._LDS != null && this._LDB.length() > 0, "Null or empty logical data server name attribute.");
        return this._LDS;
    }

    @Override
    public String getLDB() {
        Dbg.wassert(this._LDB != null && this._LDB.length() > 0, "Null or empty logical database name attribute.");
        return this._LDB;
    }

    @Override
    public String getControllingRS() {
        return this.getControllingServer();
    }

    @Override
    public String getActiveDS() {
        if (this._activeDS == null || this._activeDS.length() == 0) {
            return null;
        }
        return this._activeDS;
    }

    @Override
    public String getActiveDB() {
        if (this._activeDB == null || this._activeDB.length() == 0) {
            return null;
        }
        return this._activeDB;
    }

    @Override
    public String getActiveConnectionName() {
        if (this.getActiveDS() == null || this.getActiveDB() == null) {
            return "";
        }
        return this.getActiveDS() + "." + this.getActiveDB();
    }

    @Override
    public PhyConnection getActiveConnection() throws SQLException {
        SemanticFactory semanticFactory;
        PhyConnection phyConnection = null;
        if (this.isActiveDefined() && (phyConnection = (semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName())).getPhyConnection(this.getControllingRS(), this.getActiveDS(), this.getActiveDB())) != null) {
            phyConnection.load();
        }
        return phyConnection;
    }

    @Override
    public boolean isActiveDefined() {
        return this.getActiveDS() != null && this.getActiveDS().length() > 0;
    }

    @Override
    public String getStandbyDS() {
        if (this._standbyDS == null || this._standbyDS.length() == 0) {
            return "";
        }
        return this._standbyDS;
    }

    @Override
    public String getStandbyDB() {
        if (this._standbyDB == null || this._standbyDB.length() == 0) {
            return null;
        }
        return this._standbyDB;
    }

    @Override
    public String getStandbyConnectionName() {
        if (this.getStandbyDS() == null || this.getStandbyDB() == null) {
            return null;
        }
        return this.getStandbyDS() + "." + this.getStandbyDB();
    }

    @Override
    public PhyConnection getStandbyConnection() throws SQLException {
        SemanticFactory semanticFactory;
        PhyConnection phyConnection = null;
        if (this.isStandbyDefined() && (phyConnection = (semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName())).getPhyConnection(this.getControllingRS(), this.getStandbyDS(), this.getStandbyDB())) != null) {
            phyConnection.load();
        }
        return phyConnection;
    }

    @Override
    public boolean isStandbyDefined() {
        return this.getStandbyDS() != null && this.getStandbyDS().length() > 0;
    }

    public String getOperationInProgress() {
        String string = "";
        return string;
    }

    public String getStateOfOperation() {
        String string = "";
        return string;
    }

    @Override
    public boolean isUp() {
        return this.getRSState() == 5;
    }

    @Override
    public boolean isError() {
        return this.getRSState() == 2;
    }

    @Override
    public boolean isWarning() {
        return this.getRSState() == 3;
    }

    @Override
    public String getStateDescription() {
        String string = "";
        if (this.isUp()) {
            string = BundleManager.getString("LogicalConnectionRes", "ACTIVE_STATE");
        } else if (this.isWarning()) {
            string = BundleManager.getString("LogicalConnectionRes", "UNKNOWN_STATE");
        } else if (this.isError()) {
            string = BundleManager.getString("LogicalConnectionRes", "SUSPENDED_STATE");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getLogConnections(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain connnection parameter.");
        ArrayList<RMSLogConnection> arrayList = new ArrayList<RMSLogConnection>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_LOG_CONNS, n, string);
            Dbg.wassert(string2 != null, "Unable to get logical connection query, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(2);
                    String[] stringArray = MessageText.parseRSComponent(string3);
                    if (stringArray.length != 2) continue;
                    RMSLogConnection rMSLogConnection = new RMSLogConnection(string, stringArray[0], stringArray[1], rMSDomain);
                    rMSLogConnection.loadDetails(rSMResultSet);
                    rMSLogConnection._logConnExists = true;
                    arrayList.add(rMSLogConnection);
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 41061) {
                    throw sQLException;
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getDomain().getRMSVersionNumber();
            Object[] objectArray = new String[]{this.getControllingRS(), this.getLDS(), this.getLDB()};
            String string = _cmdBundle.getCommand(GET_LOG_CONN, n, objectArray);
            Dbg.wassert(string != null, "Unable to get logical connection query, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    this.loadDetails(rSMResultSet);
                    this._logConnExists = true;
                } else {
                    this._logConnExists = false;
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 41061) {
                    throw sQLException;
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
    }

    protected void loadDetails(RSMResultSet rSMResultSet) throws SQLException {
        String string = rSMResultSet.getColumnString(4);
        String[] stringArray = MessageText.parseRSComponent(string);
        if (stringArray.length == 2) {
            this._activeDS = stringArray[0];
            this._activeDB = stringArray[1];
        } else {
            this._activeDS = "";
            this._activeDB = "";
        }
        string = rSMResultSet.getColumnString(5);
        stringArray = MessageText.parseRSComponent(string);
        if (stringArray.length == 2) {
            this._standbyDS = stringArray[0];
            this._standbyDB = stringArray[1];
        } else {
            this._standbyDS = "";
            this._standbyDB = "";
        }
        int n = rSMResultSet.getColumnInt(7);
        this.setState(n);
        String string2 = rSMResultSet.getColumnString(9);
        if (string2 != null && string2.length() > 0) {
            this.addReason(string2);
        }
    }

    public static List getLogConnections(RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(rMSDomain != null, "Null domain connnection parameter.");
        ArrayList arrayList = new ArrayList();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(rMSDomain.getName());
        ListIterator listIterator = semanticFactory.getRepServers().listIterator();
        while (listIterator.hasNext()) {
            RepServer repServer = (RepServer)listIterator.next();
            ListIterator listIterator2 = semanticFactory.getLogConnections(repServer.getName()).listIterator();
            while (listIterator2.hasNext()) {
                arrayList.add(listIterator2.next());
            }
        }
        return arrayList;
    }

    public static List getLogConnectionsforLDS(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty logical data server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain connnection parameter.");
        ArrayList<LogConnection> arrayList = new ArrayList<LogConnection>();
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(rMSDomain.getName());
        ListIterator listIterator = semanticFactory.getRepServers().listIterator();
        while (listIterator.hasNext()) {
            RepServer repServer = (RepServer)listIterator.next();
            ListIterator listIterator2 = semanticFactory.getLogConnections(repServer.getName()).listIterator();
            while (listIterator2.hasNext()) {
                LogConnection logConnection = (LogConnection)listIterator2.next();
                if (!string.equals(logConnection.getLDS())) continue;
                arrayList.add(logConnection);
            }
        }
        return arrayList;
    }

    @Override
    public boolean exists() {
        return this._logConnExists;
    }

    @Override
    public void create() throws SQLException {
    }

    @Override
    public void drop() throws SQLException {
    }

    @Override
    public void switchActive() {
    }

    @Override
    public void abortSwitch() throws SQLException {
    }

    @Override
    public String getRCLScript() {
        String string = "";
        return string;
    }
}

