/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.logical;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.logical.LogConnectionParameter;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RMSLogConnectionParameter
extends LogConnectionParameter {
    private RMSDomain _domain = null;
    private static final String GET_PARAMS = "GET_PARAMS";
    private static final String SET_PARAM = "SET_PARAM";
    private static final Object[][] contents = new Object[][]{{"GET_PARAMS", new Integer(1200), "configure logical connections {0}.{1} for {2}"}, {"SET_PARAM", new Integer(1200), "configure logical connections {0}.{1} for {2} {3}={4}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSLogConnectionParameter(String string, String string2, String string3, RMSDomain rMSDomain) {
        super(string, string2, string3);
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        this._domain = rMSDomain;
    }

    public RMSDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getLogConnectionParameters(String string, String string2, String string3, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Replication Server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty logical server name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty logical database name parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        ArrayList<RMSLogConnectionParameter> arrayList = new ArrayList<RMSLogConnectionParameter>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            Object[] objectArray = new String[]{string2, string3, string};
            String string4 = _cmdBundle.getCommand(GET_PARAMS, n, objectArray);
            Dbg.wassert(string4 != null, "Unable to get connection parameter query command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string4);
                while (rSMResultSet.getNextRow()) {
                    String string5 = rSMResultSet.getColumnString(5);
                    String string6 = rSMResultSet.getColumnString(6);
                    String string7 = rSMResultSet.getColumnString(7);
                    RMSLogConnectionParameter rMSLogConnectionParameter = new RMSLogConnectionParameter(string5, string6, string7, rMSDomain);
                    arrayList.add(rMSLogConnectionParameter);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", string2), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter(String string, String string2, String string3) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty Replication Server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty logical server name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty logical database name parameter.");
        if (this.isModified()) {
            RMSConnection rMSConnection = this.getDomain().getRMSConnection();
            if (rMSConnection != null) {
                int n = rMSConnection.getVersionNumber();
                Object[] objectArray = new String[]{string2, string3, string, this.getName(), this.getPendingValue()};
                String string4 = _cmdBundle.getCommand(SET_PARAM, n, objectArray);
                Dbg.wassert(string4 != null, "Unable to get connection parameter query command, RMS version: " + n);
                RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
                try {
                    rSMResultSet.open(string4);
                    this.resetOriginalPendingValue();
                }
                finally {
                    rSMResultSet.close();
                    rMSConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", string), "_RSM_", 3);
            }
        }
    }

    @Override
    public String getRCLScript(String string, String string2, String string3) {
        String string4 = "";
        return string4;
    }
}

