/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.mirrorrepagent;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndSummaryThread;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.EnvServerStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentParameter;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.MRAConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class DomainMirrorRepAgent
extends EnvServerStatusSO
implements MirrorRepAgent,
Comparable {
    private static final String SHUTDOWN = "SHUTDOWN";
    private static final String RESUME = "RESUME";
    private static final String SUSPEND = "SUSPEND";
    private static final String RA_STATUS = "RA_STATUS";
    private static final String PDB_INIT = "PDB_INIT";
    private static final String PDB_INIT_TRUNC = "PDB_INIT_TRUNC";
    private static final String RA_INIT = "RA_INIT";
    private static final String TEST_CONNECTION = "TEST_CONNECTION";
    private static final Object[][] contents = new Object[][]{{"SHUTDOWN", new Integer(1260), "shutdown"}, {"RESUME", new Integer(1260), "resume"}, {"SUSPEND", new Integer(1260), "suspend"}, {"RA_STATUS", new Integer(1260), "ra_status"}, {"PDB_INIT", new Integer(1200), "pdb_init"}, {"PDB_INIT_TRUNC", new Integer(1200), "pdb_init move_truncpt"}, {"RA_INIT", new Integer(1200), "ra_init"}, {"TEST_CONNECTION", new Integer(1260), "test_connection"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainMirrorRepAgent(String string, EnvDomain envDomain) {
        super(string, envDomain);
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof DomainMirrorRepAgent) {
            return this.getName().compareTo(((DomainMirrorRepAgent)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-DomainMirrorRepAgent object.");
        return -1;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public static MirrorRepAgent getMirrorRepAgent(String string, EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        MirrorRepAgent mirrorRepAgent = null;
        List list = DomainMirrorRepAgent.getMirrorRepAgents(envDomain);
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext() && mirrorRepAgent == null) {
                MirrorRepAgent mirrorRepAgent2 = (MirrorRepAgent)listIterator.next();
                if (!mirrorRepAgent2.getName().equals(string)) continue;
                mirrorRepAgent = mirrorRepAgent2;
            }
        }
        return mirrorRepAgent;
    }

    public static MirrorRepAgent getMirrorRepAgent(String string, String string2, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        DomainMirrorRepAgent domainMirrorRepAgent = null;
        List list = DomainMirrorRepAgent.getMirrorRepAgents(envDomain);
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext() && domainMirrorRepAgent == null) {
                DomainMirrorRepAgent domainMirrorRepAgent2 = (DomainMirrorRepAgent)listIterator.next();
                String string3 = domainMirrorRepAgent2.getConnectionName();
                if (string3 == null || !string3.equals(string + "." + string2)) continue;
                domainMirrorRepAgent = domainMirrorRepAgent2;
            }
        }
        return domainMirrorRepAgent;
    }

    public static List getMirrorRepAgents(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        ArrayList<DomainMirrorRepAgent> arrayList = new ArrayList<DomainMirrorRepAgent>();
        ListIterator listIterator = envDomain.getMirrorRepAgentServerNames().listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            DomainMirrorRepAgent domainMirrorRepAgent = new DomainMirrorRepAgent(string, envDomain);
            arrayList.add(domainMirrorRepAgent);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getMRAState(MRAConnection mRAConnection) throws SQLException {
        String string = new String();
        if (mRAConnection == null) throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = mRAConnection.getVersionNumber();
        String string2 = _cmdBundle.getCommand(RA_STATUS, n);
        Dbg.wassert(string2 != null, "Unable to get ra_status command, Mirror Rep Agent version: " + n);
        try {
            RSMResultSet rSMResultSet = new RSMResultSet(mRAConnection);
            rSMResultSet.open(string2);
            if (!rSMResultSet.getNextRow()) return 3;
            String string3 = rSMResultSet.getColumnString(1);
            string3 = string3.trim();
            string3 = string3.toUpperCase();
            string = rSMResultSet.getColumnString(2);
            this.addReason(string);
            if (string3.startsWith("REPLICATING")) {
                int n2 = 5;
                return n2;
            }
            if (!string3.equalsIgnoreCase("ADMIN")) return 3;
            int n3 = 6;
            return n3;
        }
        finally {
            mRAConnection.unlock();
        }
    }

    @Override
    public void loadStatus() {
        this.monitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor() {
        this.clearReasons();
        MRAConnection mRAConnection = (MRAConnection)this.getDomain().getConnection(this.getName());
        if (mRAConnection != null) {
            int n = 0;
            try {
                mRAConnection.open();
                n = mRAConnection.getState();
            }
            catch (SQLException sQLException) {
                n = mRAConnection.getState();
            }
            finally {
                mRAConnection.unlock();
            }
            switch (n) {
                case 1: {
                    try {
                        int n2 = this.getMRAState(mRAConnection);
                        this.setState(n2);
                    }
                    catch (SQLException sQLException) {}
                    break;
                }
                case 3: {
                    this.setState(1);
                    break;
                }
                default: {
                    this.setState(0);
                }
            }
            String string = mRAConnection.getReason();
            if (string != null && string.length() > 0) {
                this.addReason(string);
            }
        } else {
            this.setState(3);
            return;
        }
    }

    @Override
    public String getVersionString() {
        String string = "";
        MRAConnection mRAConnection = (MRAConnection)this.getDomain().getConnection(this.getName());
        if (mRAConnection != null) {
            string = mRAConnection.getVersionString();
            mRAConnection.unlock();
        }
        return string;
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("MirrorRepAgentRes", "ACTIVE_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("MirrorRepAgentRes", "DOWN_STATE");
                break;
            }
            case 6: {
                string = BundleManager.getString("MirrorRepAgentRes", "ADMIN_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("MirrorRepAgentRes", "TIMED_OUT_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("MirrorRepAgentRes", "UNKNOWN_STATE");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected MirrorRepAgent State");
                string = "";
            }
        }
        return string;
    }

    @Override
    public void alter(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) throws SQLException {
        this.alter(string, string2, string3, string4, string5, string6, "Mirror Replication Agent");
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws SQLException {
        MRAConnection mRAConnection = (MRAConnection)this.getDomain().getConnection(this.getName());
        if (mRAConnection != null) {
            int n = mRAConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(SHUTDOWN, n);
            Dbg.wassert(string != null, "Unable to get shutdown command, Mirror Rep Agent version: " + n);
            try {
                mRAConnection.execute(string);
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState() == null || !sQLException.getSQLState().equals("JZ006")) {
                    throw sQLException;
                }
                mRAConnection.setState(0);
                this.setState(0);
                this.clearReasons();
            }
            finally {
                mRAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void resume(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("MirrorRepAgentRes", "RESUME_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            DomainMirrorRepAgent domainMirrorRepAgent = (DomainMirrorRepAgent)listIterator.next();
                            this.setStatus(BundleManager.getString("MirrorRepAgentRes", "RESUME_DLG_TITLE", domainMirrorRepAgent.getName()));
                            domainMirrorRepAgent.resume();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    DomainMirrorRepAgent.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws SQLException {
        MRAConnection mRAConnection = (MRAConnection)this.getDomain().getConnection(this.getName());
        if (mRAConnection != null) {
            int n = mRAConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(RESUME, n);
            Dbg.wassert(string != null, "Unable to get resume route command, repserver version: " + n);
            try {
                mRAConnection.execute(string);
                mRAConnection.setState(1);
                this.clearReasons();
            }
            finally {
                mRAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void suspend(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("RouteRes", "SUSPEND_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!2.interrupted() && listIterator.hasNext()) {
                            DomainMirrorRepAgent domainMirrorRepAgent = (DomainMirrorRepAgent)listIterator.next();
                            this.setStatus(BundleManager.getString("MirrorRepAgentRes", "SUSPEND_DLG_TITLE", domainMirrorRepAgent.getName()));
                            domainMirrorRepAgent.suspend();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    DomainMirrorRepAgent.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() throws SQLException {
        MRAConnection mRAConnection = (MRAConnection)this.getDomain().getConnection(this.getName());
        if (mRAConnection != null) {
            int n = mRAConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(SUSPEND, n);
            Dbg.wassert(string != null, "Unable to get suspend route command, repserver version: " + n);
            try {
                mRAConnection.execute(string);
                mRAConnection.setState(1);
                this.setState(4);
                this.clearReasons();
            }
            finally {
                mRAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void startPDBInitialize(final List list, final boolean bl) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("MirrorRepAgentRes", "INIT_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!3.interrupted() && listIterator.hasNext()) {
                            DomainMirrorRepAgent domainMirrorRepAgent = (DomainMirrorRepAgent)listIterator.next();
                            this.setStatus(BundleManager.getString("MirrorRepAgentRes", "INIT_STATUS", domainMirrorRepAgent.getName()));
                            domainMirrorRepAgent.pdbInitialize(bl);
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    DomainMirrorRepAgent.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pdbInitialize(boolean bl) throws SQLException {
        MRAConnection mRAConnection = (MRAConnection)this.getDomain().getConnection(this.getName());
        if (mRAConnection != null) {
            int n = mRAConnection.getVersionNumber();
            String string = bl ? _cmdBundle.getCommand(PDB_INIT_TRUNC, n) : _cmdBundle.getCommand(PDB_INIT, n);
            Dbg.wassert(string != null, "Unable to get initialization command, rep agent version: " + n);
            try {
                mRAConnection.execute(string);
            }
            finally {
                mRAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("MirrorRepAgentRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void startRAInitialize(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("MirrorRepAgentRes", "INIT_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!4.interrupted() && listIterator.hasNext()) {
                            DomainMirrorRepAgent domainMirrorRepAgent = (DomainMirrorRepAgent)listIterator.next();
                            this.setStatus(BundleManager.getString("MirrorRepAgentRes", "RA_INIT_STATUS", domainMirrorRepAgent.getName()));
                            domainMirrorRepAgent.raInitialize();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    DomainMirrorRepAgent.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void raInitialize() throws SQLException {
        MRAConnection mRAConnection = (MRAConnection)this.getDomain().getConnection(this.getName());
        if (mRAConnection != null) {
            int n = mRAConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(RA_INIT, n);
            Dbg.wassert(string != null, "Unable to get initialization command, rep agent version: " + n);
            try {
                mRAConnection.execute(string);
            }
            finally {
                mRAConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("MirrorRepAgentRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void testConnection() {
        final String string = this.getName();
        BkgndSummaryThread bkgndSummaryThread = new BkgndSummaryThread(BundleManager.getString("MirrorRepAgentRes", "TEST_CONNECTION_TITLE", string), BundleManager.getString("MirrorRepAgentRes", "TEST_CONNECTION_DESC"), this.getDomainName(), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block7: {
                    try {
                        MRAConnection mRAConnection = (MRAConnection)DomainMirrorRepAgent.this.getDomain().getConnection(string);
                        if (mRAConnection == null) break block7;
                        int n = mRAConnection.getVersionNumber();
                        String string3 = _cmdBundle.getCommand(DomainMirrorRepAgent.TEST_CONNECTION, n);
                        Dbg.wassert(string3 != null, "Unable to get the test connection command, lanrepagent version: " + n);
                        RSMResultSet rSMResultSet = new RSMResultSet(mRAConnection);
                        try {
                            String string2;
                            rSMResultSet.open(string3);
                            while (rSMResultSet.getNextRow()) {
                                string2 = "";
                                for (int i = 1; i <= rSMResultSet.getColumnCount(); ++i) {
                                    string2 = string2 + rSMResultSet.getColumnString(i) + " ";
                                }
                                this.setStatus(string2);
                            }
                            string2 = BundleManager.getString("BkgndThreadRes", "STATE_COMPLETED");
                            this.setStatus(string2);
                        }
                        finally {
                            rSMResultSet.close();
                            mRAConnection.unlock();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(2, MessageText.formatExceptionMessage(sQLException));
                    }
                }
                DomainMirrorRepAgent.this.getDomain().refreshStatus();
                this.close();
            }
        };
        bkgndSummaryThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        ConnAttributes connAttributes = new ConnAttributes();
        connAttributes.setServer(this.getName());
        connAttributes.setType("Replication Agent");
        connAttributes.setUser(string);
        connAttributes.setPassword(string2);
        connAttributes.setCharset(string3);
        connAttributes.setLanguage(string4);
        if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
            connAttributes.setHost(string5);
            connAttributes.setPort(string6);
            connAttributes.setSaveAddress(true);
        } else {
            connAttributes.setHost("");
            connAttributes.setPort("");
            connAttributes.setSaveAddress(false);
        }
        MRAConnection mRAConnection = new MRAConnection(connAttributes);
        try {
            mRAConnection.open();
        }
        finally {
            if (mRAConnection != null) {
                mRAConnection.close();
            }
        }
    }

    @Override
    public String getSourceDS() throws SQLException {
        String string = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        MirrorRepAgentParameter mirrorRepAgentParameter = semanticFactory.getMirrorRepAgentParameter(this.getName(), "rs_source_ds");
        if (mirrorRepAgentParameter != null && (string = mirrorRepAgentParameter.getCurrentValue()) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    @Override
    public String getSourceDB() throws SQLException {
        String string = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        MirrorRepAgentParameter mirrorRepAgentParameter = semanticFactory.getMirrorRepAgentParameter(this.getName(), "rs_source_db");
        if (mirrorRepAgentParameter != null && (string = mirrorRepAgentParameter.getCurrentValue()) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    @Override
    public String getConnectionName() throws SQLException {
        String string = null;
        String string2 = this.getSourceDS();
        String string3 = this.getSourceDB();
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            string = string2 + "." + string3;
        }
        return string;
    }
}

