/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.mirrorrepagent;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCViewerDetailsPanel2;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ServerComponent;
import com.sybase.rsmplugin.components.connection.ConnectionItem;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.events.EventDetailContainer;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentProp;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentStatisticsDlg;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CheckBoxMessage;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class MirrorRepAgentContainer
extends BaseContainer
implements RMContainer,
ServerComponent,
StatusItem {
    private static final String CLASS_ID = "mirrorrepagent.MirrorRepAgentContainer";
    private static final int CMD_TEST_CONNECTION = 3008;
    private static final int CMD_PDB_INITIALIZE = 3009;
    private static final int CMD_RA_INITIALIZE = 3010;
    private static final int CMD_STATISTICS = 3011;
    private MirrorRepAgent _so;
    private static ImageIcon _iconUp = null;
    private static ImageIcon _iconDown = null;
    private static ImageIcon _iconSuspect = null;

    public MirrorRepAgentContainer(MirrorRepAgent mirrorRepAgent, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(mirrorRepAgent != null, "Null MirrorRepAgent Semantic object parameter.");
        this._so = mirrorRepAgent;
        StatusManager.addStatusItem(this);
    }

    public MirrorRepAgentContainer(MirrorRepAgent mirrorRepAgent) {
        Dbg.wassert(mirrorRepAgent != null, "Null MirrorRepAgent Semantic object parameter.");
        this._so = mirrorRepAgent;
        StatusManager.addStatusItem(this);
    }

    public MirrorRepAgent getMirrorRepAgent() {
        return this._so;
    }

    @Override
    public void drop() {
        this.getMirrorRepAgent().drop();
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getMirrorRepAgentUp());
        }
        return _iconUp;
    }

    @Override
    public void setState(int n) {
        this.getMirrorRepAgent().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getMirrorRepAgent().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getMirrorRepAgent().getDomainName();
    }

    @Override
    public String getType() {
        return this.getMirrorRepAgent().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getDisplayName(1);
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getMirrorRepAgent().isUp()) {
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getMirrorRepAgentUp());
            }
            return _iconUp;
        }
        if (this.getMirrorRepAgent().isError()) {
            if (_iconDown == null) {
                _iconDown = new ImageIcon(RSMImages.getMirrorRepAgentDown());
            }
            return _iconDown;
        }
        if (_iconSuspect == null) {
            _iconSuspect = new ImageIcon(RSMImages.getMirrorRepAgentSuspect());
        }
        return _iconSuspect;
    }

    @Override
    public int getAttributes() {
        if (!this.getMirrorRepAgent().isError()) {
            return 1;
        }
        return super.getAttributes();
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getMirrorRepAgent().getName();
            }
            case 1: {
                return this.getMirrorRepAgent().getStateString();
            }
            case 2: {
                return this.getMirrorRepAgent().getReason();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu = new DefaultSCMenu();
        if (this.getMirrorRepAgent().isError()) {
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        } else {
            MenuItem menuItem;
            char c;
            String string;
            String string2;
            if (!this.getMirrorRepAgent().isControlledByRSMS()) {
                string2 = BundleManager.getString("MirrorRepAgentRes", "MENU_TEST_CONNECTION");
                string = BundleManager.getString("MirrorRepAgentRes", "MENU_HINT_TEST_CONNECTION");
                c = BundleManager.getMnemonic("MirrorRepAgentRes", "MENU_MNEM_TEST_CONNECTION");
                menuItem = new MenuItem(3008, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                string2 = BundleManager.getString("MirrorRepAgentRes", "MENU_PDB_INITIALIZE");
                string = BundleManager.getString("MirrorRepAgentRes", "MENU_HINT_PDB_INITIALIZE");
                c = BundleManager.getMnemonic("MirrorRepAgentRes", "MENU_MNEM_PDB_INITIALIZE");
                menuItem = new MenuItem(3009, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                string2 = BundleManager.getString("MirrorRepAgentRes", "MENU_RA_INITIALIZE");
                string = BundleManager.getString("MirrorRepAgentRes", "MENU_HINT_RA_INITIALIZE");
                c = BundleManager.getMnemonic("MirrorRepAgentRes", "MENU_MNEM_RA_INITIALIZE");
                menuItem = new MenuItem(3010, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                string2 = BundleManager.getString("MirrorRepAgentRes", "MENU_STATISTICS");
                string = BundleManager.getString("MirrorRepAgentRes", "MENU_HINT_STATISTICS");
                c = BundleManager.getMnemonic("MirrorRepAgentRes", "MENU_MNEM_STATISTICS");
                menuItem = new MenuItem(3011, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            }
            string2 = BundleManager.getString("MirrorRepAgentRes", "MENU_RESUME");
            string = BundleManager.getString("MirrorRepAgentRes", "MENU_HINT_RESUME");
            c = BundleManager.getMnemonic("MirrorRepAgentRes", "MENU_MNEM_RESUME");
            menuItem = new MenuItem(3006, string2, string, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            string2 = BundleManager.getString("MirrorRepAgentRes", "MENU_SUSPEND");
            string = BundleManager.getString("MirrorRepAgentRes", "MENU_HINT_SUSPEND");
            c = BundleManager.getMnemonic("MirrorRepAgentRes", "MENU_MNEM_SUSPEND");
            menuItem = new MenuItem(3007, string2, string, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            string2 = BundleManager.getString("MirrorRepAgentRes", "MENU_SHUTDOWN");
            string = BundleManager.getString("MirrorRepAgentRes", "MENU_HINT_SHUTDOWN");
            c = BundleManager.getMnemonic("MirrorRepAgentRes", "MENU_MNEM_SHUTDOWN");
            menuItem = new MenuItem(3005, string2, string, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        }
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        if (this.getMirrorRepAgent().isError()) {
            return 32;
        }
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106 || n == 3007 || n == 3006 || n == 3009 || n == 3010;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3008: {
                this.getMirrorRepAgent().testConnection();
                break;
            }
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof ServerComponent)) continue;
                    ((ServerComponent)((Object)baseItem)).drop();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 107: {
                BaseController baseController = PluginSupport.getDialog(MirrorRepAgentProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                MirrorRepAgentProp mirrorRepAgentProp = new MirrorRepAgentProp(this.getMirrorRepAgent(), this, sCDialogSupport2);
                mirrorRepAgentProp.showDialog();
                break;
            }
            case 3011: {
                BaseController baseController = PluginSupport.getDialog(MirrorRepAgentStatisticsDlg.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                MirrorRepAgentStatisticsDlg mirrorRepAgentStatisticsDlg = new MirrorRepAgentStatisticsDlg(sCDialogSupport2, this.getMirrorRepAgent());
                mirrorRepAgentStatisticsDlg.showDialog();
                break;
            }
            case 3005: {
                String string = BundleManager.getString("RepServerRes", "CONFIRM_SHUTDOWN", this.getName());
                if (!PluginSupport.askQuestion(string, false)) break;
                PluginSupport.getViewerSupport().startWait();
                try {
                    this.getMirrorRepAgent().shutdown();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                StatusManager.refresh(this.getDomainName(), this.getType(), this.getName());
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 3007: {
                if (!PluginSupport.askQuestion(BundleManager.getString("MirrorRepAgentRes", "CONFIRM_SUSPEND", this.getName()))) break;
                ArrayList<MirrorRepAgent> arrayList = new ArrayList<MirrorRepAgent>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof MirrorRepAgentContainer)) continue;
                    arrayList.add(((MirrorRepAgentContainer)baseItem).getMirrorRepAgent());
                }
                if (arrayList.size() <= 0) break;
                this.getMirrorRepAgent().suspend(arrayList);
                break;
            }
            case 3006: {
                if (!PluginSupport.askQuestion(BundleManager.getString("MirrorRepAgentRes", "CONFIRM_RESUME", this.getName()))) break;
                ArrayList<MirrorRepAgent> arrayList = new ArrayList<MirrorRepAgent>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof MirrorRepAgentContainer)) continue;
                    arrayList.add(((MirrorRepAgentContainer)baseItem).getMirrorRepAgent());
                }
                if (arrayList.size() <= 0) break;
                this.getMirrorRepAgent().resume(arrayList);
                break;
            }
            case 3009: {
                Boolean bl = CheckBoxMessage.showInputDialog(BundleManager.getString("MirrorRepAgentRes", "CONFIRM_INIT", this.getName()), BundleManager.getString("MirrorRepAgentRes", "MOVE_TRUNC"), false);
                if (bl == null) break;
                ArrayList<MirrorRepAgent> arrayList = new ArrayList<MirrorRepAgent>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof MirrorRepAgentContainer)) continue;
                    arrayList.add(((MirrorRepAgentContainer)baseItem).getMirrorRepAgent());
                }
                if (arrayList.size() <= 0) break;
                this.getMirrorRepAgent().startPDBInitialize(arrayList, bl);
                break;
            }
            case 3010: {
                if (!PluginSupport.askQuestion(BundleManager.getString("MirrorRepAgentRes", "CONFIRM_RA_INIT", this.getName()))) break;
                ArrayList<MirrorRepAgent> arrayList = new ArrayList<MirrorRepAgent>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof MirrorRepAgentContainer)) continue;
                    arrayList.add(((MirrorRepAgentContainer)baseItem).getMirrorRepAgent());
                }
                if (arrayList.size() <= 0) break;
                this.getMirrorRepAgent().startRAInitialize(arrayList);
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getMirrorRepAgent().getDomainName());
            try {
                ListIterator listIterator = semanticFactory.getPhyConnectionsForMirrorRepAgent(this.getName()).listIterator();
                while (listIterator.hasNext()) {
                    PhyConnection phyConnection = (PhyConnection)listIterator.next();
                    ConnectionItem connectionItem = new ConnectionItem(phyConnection, this);
                    this.addItem((SCItem)connectionItem);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    @Override
    public Object[] getDetailsPanels(JFrame jFrame) {
        String string = this.getParent().getName();
        if (this.getMirrorRepAgent().isControlledByRSMS()) {
            SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
            SCViewerDetailsPanel2 sCViewerDetailsPanel22 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", (SCDetailsContainer)new EventDetailContainer(BundleManager.getString("EventsRes", "EVENT_TAB"), string, this.getName(), this));
            sCViewerDetailsPanel22.setPanelName(sCViewerDetailsPanel22.getSCDetailsContainer().getDisplayName());
            Object[] objectArray = new Object[]{sCViewerDetailsPanel2, sCViewerDetailsPanel22};
            return objectArray;
        }
        SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
        Object[] objectArray = new Object[]{sCViewerDetailsPanel2};
        return objectArray;
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("ConnectionRes", "COL_HEADER_CONN"), BundleManager.getString("ConnectionRes", "COL_HEADER_RA_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_DSI_STATUS"), BundleManager.getString("ConnectionRes", "COL_HEADER_REASON")};
    }
}

