/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.mirrorrepagent;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.RMSServerStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentParameter;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class RMSMirrorRepAgent
extends RMSServerStatusSO
implements MirrorRepAgent,
Comparable {
    String _lastMonitored = null;
    String _monitoredBy = null;
    String _versionString = null;
    private static final String GET_MIRROR_REP_AGENTS = "GET_MIRROR_REP_AGENTS";
    private static final String GET_REP_AGENT = "GET_REP_AGENT";
    private static final String SUSPEND = "SUSPEND";
    private static final String RESUME = "RESUME";
    private static final Object[][] contents = new Object[][]{{"GET_MIRROR_REP_AGENTS", new Integer(1260), "get servers MRA"}, {"GET_REP_AGENT", new Integer(1260), "get servers {0}"}, {"SUSPEND", new Integer(1260), "suspend {0}"}, {"RESUME", new Integer(1260), "resume {0}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSMirrorRepAgent(String string, RMSDomain rMSDomain) {
        super(string, rMSDomain);
        this.setState(3);
        this.clearReasons();
    }

    public int compareTo(Object object) {
        if (object instanceof RMSMirrorRepAgent) {
            return this.getName().compareTo(((RMSMirrorRepAgent)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-RMSMirrorRepAgent object.");
        return -1;
    }

    @Override
    public String getServerType() {
        return "Mirror Replication Agent";
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "Mirror Replication Agent";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MirrorRepAgent getMirrorRepAgent(String string, RMSDomain rMSDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty agent name parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        RMSMirrorRepAgent rMSMirrorRepAgent = null;
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_REP_AGENT, n, string);
            Dbg.wassert(string2 != null, "Unable to get server command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                if (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    if (string3 != null && string3.equals(string) && string4 != null && string4.equalsIgnoreCase("Mirror Replication Agent")) {
                        rMSMirrorRepAgent = new RMSMirrorRepAgent(string, rMSDomain);
                        rMSMirrorRepAgent._lastMonitored = rSMResultSet.getColumnString(3);
                        rMSMirrorRepAgent._versionString = rSMResultSet.getColumnString(4);
                        rMSMirrorRepAgent.setState(rSMResultSet.getColumnInt(5));
                        String string5 = rSMResultSet.getColumnString(7);
                        if (string5 != null && string5.length() > 0) {
                            rMSMirrorRepAgent.addReason(string5);
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return rMSMirrorRepAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getMirrorRepAgents(RMSDomain rMSDomain) {
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        ArrayList<RMSMirrorRepAgent> arrayList = new ArrayList<RMSMirrorRepAgent>(1);
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_MIRROR_REP_AGENTS, n);
            Dbg.wassert(string != null, "Unable to get mirror rep agent command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    RMSMirrorRepAgent rMSMirrorRepAgent = new RMSMirrorRepAgent(string2, rMSDomain);
                    String string3 = rSMResultSet.getColumnString(2);
                    if (!string3.equalsIgnoreCase(rMSMirrorRepAgent.getRMSType())) continue;
                    rMSMirrorRepAgent._lastMonitored = rSMResultSet.getColumnString(3);
                    rMSMirrorRepAgent._versionString = rSMResultSet.getColumnString(4);
                    rMSMirrorRepAgent.setState(rSMResultSet.getColumnInt(5));
                    String string4 = rSMResultSet.getColumnString(7);
                    if (string4 != null && string4.length() > 0) {
                        rMSMirrorRepAgent.addReason(string4);
                    }
                    arrayList.add(rMSMirrorRepAgent);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadStatus() {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getDomain().getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_REP_AGENT, n, this.getName());
            Dbg.wassert(string != null, "Unable to get rep agent command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    this._lastMonitored = rSMResultSet.getColumnString(3);
                    this._versionString = rSMResultSet.getColumnString(4);
                    this.setState(rSMResultSet.getColumnInt(5));
                    String string2 = rSMResultSet.getColumnString(7);
                    if (string2 == null || string2.length() <= 0) continue;
                    this.addReason(string2);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
    }

    @Override
    public String getVersionString() {
        return this._versionString != null ? this._versionString : "";
    }

    @Override
    public String getLastMonitoredDate() {
        return this._lastMonitored != null ? this._lastMonitored : "";
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("MirrorRepAgentRes", "ACTIVE_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("MirrorRepAgentRes", "DOWN_STATE");
                break;
            }
            case 6: {
                string = BundleManager.getString("MirrorRepAgentRes", "ADMIN_STATE");
                break;
            }
            case 4: {
                string = BundleManager.getString("MirrorRepAgentRes", "SUSPECT_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("MirrorRepAgentRes", "TIMED_OUT_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("MirrorRepAgentRes", "UNKNOWN_STATE");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }

    @Override
    public void resume(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("MirrorRepAgentRes", "RESUME_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            RMSMirrorRepAgent rMSMirrorRepAgent = (RMSMirrorRepAgent)listIterator.next();
                            this.setStatus(BundleManager.getString("MirrorRepAgentRes", "RESUME_DLG_TITLE", rMSMirrorRepAgent.getName()));
                            rMSMirrorRepAgent.resume();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    RMSMirrorRepAgent.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resume() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = this.getDomain().getRMSVersionNumber();
        String string = _cmdBundle.getCommand(RESUME, n, this.getName());
        Dbg.wassert(string != null, "Unable to get resume rep agent command, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    @Override
    public void suspend(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("MirrorRepAgentRes", "SUSPEND_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!2.interrupted() && listIterator.hasNext()) {
                            RMSMirrorRepAgent rMSMirrorRepAgent = (RMSMirrorRepAgent)listIterator.next();
                            this.setStatus(BundleManager.getString("MirrorRepAgentRes", "SUSPEND_DLG_TITLE", rMSMirrorRepAgent.getName()));
                            rMSMirrorRepAgent.suspend();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    RMSMirrorRepAgent.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void suspend() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = this.getDomain().getRMSVersionNumber();
        String string = _cmdBundle.getCommand(SUSPEND, n, this.getName());
        Dbg.wassert(string != null, "Unable to get suspend rep agent command, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    @Override
    public void startPDBInitialize(List list, boolean bl) {
    }

    @Override
    public void pdbInitialize(boolean bl) throws SQLException {
    }

    @Override
    public void startRAInitialize(List list) {
    }

    @Override
    public void raInitialize() throws SQLException {
    }

    @Override
    public void testConnection() {
    }

    @Override
    public String getSourceDS() throws SQLException {
        String string = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        MirrorRepAgentParameter mirrorRepAgentParameter = semanticFactory.getMirrorRepAgentParameter(this.getName(), "rs_source_ds");
        if (mirrorRepAgentParameter != null && (string = mirrorRepAgentParameter.getCurrentValue()) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    @Override
    public String getSourceDB() throws SQLException {
        String string = null;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        MirrorRepAgentParameter mirrorRepAgentParameter = semanticFactory.getMirrorRepAgentParameter(this.getName(), "rs_source_db");
        if (mirrorRepAgentParameter != null && (string = mirrorRepAgentParameter.getCurrentValue()) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    @Override
    public String getConnectionName() throws SQLException {
        String string = null;
        String string2 = this.getSourceDS();
        String string3 = this.getSourceDB();
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
            string = string2 + "." + string3;
        }
        return string;
    }
}

