/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.queue;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class QueueData
implements RSMObjectRow {
    private static final String GET_DATA = "GET_DATA";
    private static final String GET_ORIGINS = "GET_ORIGINS";
    private static final String DELETE_MSG = "DELETE_MSG";
    private static final String UNDELETE_MSG = "UNDELETE_MSG";
    private static final Object[][] contents = new Object[][]{{"GET_DATA", new Integer(1200), "sysadmin dump_queue, {0}, {1}, {2}, {3}, {4}, client"}, {"GET_ORIGINS", new Integer(1200), "select dbid, dsname, dbname from rs_databases order by dbid asc"}, {"DELETE_MSG", new Integer(1200), "sysadmin sqm_zap_command, {0}, {1}, {2}, {3}, {4}"}, {"UNDELETE_MSG", new Integer(1200), "sysadmin sqm_unzap_command, {0}, {1}, {2}, {3}, {4}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);
    private static final int SQM_STATUS_ZAPPED_MSG = 32768;
    protected int _segment;
    protected int _block;
    protected int _row;
    protected String _origSiteID;
    protected String _cmd;
    protected int _status;
    protected Date _origTime;
    protected String _origUser;
    protected String _tranName;
    protected String _tranID;
    protected String _qid;
    protected int _seqNr;
    protected EnvDomain _domain = null;
    private static final int COLUMN_COUNT = 8;

    public QueueData(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._domain = envDomain;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getQueueData(String string, int n, int n2, int n3, int n4, int n5, int n6, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        List list = QueueData.getOrigins(string, envDomain);
        Object[] objectArray = new String[]{String.valueOf(n), String.valueOf(n2), String.valueOf(n3), String.valueOf(n4), String.valueOf(n5)};
        int n7 = envDomain.getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(GET_DATA, n7, objectArray);
        Dbg.wassert(string2 != null, "Unable to get exceptions log query command, repserver version: " + n7);
        ArrayList<QueueData> arrayList = new ArrayList<QueueData>(500);
        RSMConnection rSMConnection = envDomain.getConnection(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                for (int i = 1; rSMResultSet.getNextRow() && i <= n6; ++i) {
                    QueueData queueData = new QueueData(envDomain);
                    queueData._segment = rSMResultSet.getColumnInt(3);
                    queueData._block = rSMResultSet.getColumnInt(4);
                    queueData._row = rSMResultSet.getColumnInt(5);
                    queueData._origSiteID = QueueData.getOrigin(list, rSMResultSet.getColumnInt(7));
                    queueData._origTime = rSMResultSet.getColumnDate(8);
                    queueData._qid = rSMResultSet.getColumnString(9);
                    queueData._origUser = rSMResultSet.getColumnString(10);
                    queueData._tranName = rSMResultSet.getColumnString(11);
                    queueData._status = rSMResultSet.getColumnInt(13);
                    queueData._tranID = rSMResultSet.getColumnString(14);
                    queueData._seqNr = rSMResultSet.getColumnInt(18);
                    queueData._cmd = rSMResultSet.getColumnString(19);
                    arrayList.add(queueData);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
                if (list != null) {
                    list.clear();
                }
            }
        } else {
            throw new SQLException(BundleManager.getString("QueueRes", "NULL_SERVER", string), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getOrigins(String string, EnvDomain envDomain) throws SQLException {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(5);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        int n = envDomain.getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(GET_ORIGINS, n);
        Dbg.wassert(string2 != null, "Unable to get exceptions log query command, repserver version:" + n);
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    int n2 = rSMResultSet.getColumnInt(1);
                    String string3 = rSMResultSet.getColumnString(2);
                    String string4 = rSMResultSet.getColumnString(3);
                    Object[] objectArray = new Object[]{new Integer(n2), string3 + "." + string4};
                    arrayList.add(objectArray);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    public static String getOrigin(List list, int n) {
        Object[] objectArray;
        int n2 = -1;
        if (list != null) {
            objectArray = new Integer(n);
            Comparator comparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    Object[] objectArray = (Object[])object;
                    Integer n = (Integer)objectArray[0];
                    Integer n2 = (Integer)object2;
                    return n.compareTo(n2);
                }
            };
            n2 = Collections.binarySearch(list, objectArray, comparator);
        }
        if (n2 < 0) {
            return String.valueOf(n);
        }
        objectArray = (Object[])list.get(n2);
        return (String)objectArray[1];
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return String.valueOf(this._segment) + "." + String.valueOf(this._block) + "." + String.valueOf(this._row);
            }
            case 1: {
                return this.getTransactionName();
            }
            case 2: {
                if ((this.getStatus() & 0x8000) == 32768) {
                    return BundleManager.getString("QueueRes", "Q_DATA_ZAP_STATUS") + this.getCommand();
                }
                return this.getCommand();
            }
            case 3: {
                return this.getOriginSite();
            }
            case 4: {
                return this.getOriginTime();
            }
            case 5: {
                return this.getOriginUser();
            }
            case 6: {
                return this.getTranID();
            }
            case 7: {
                return this.getQID();
            }
        }
        return " ";
    }

    @Override
    public void setValueAt(Object object, int n) {
    }

    public int getSegment() {
        return this._segment;
    }

    public int getBlock() {
        return this._block;
    }

    public int getRow() {
        return this._row;
    }

    public String getOriginSite() {
        return this._origSiteID;
    }

    public String getCommand() {
        return this._cmd;
    }

    public int getStatus() {
        return this._status;
    }

    public Date getOriginTime() {
        return this._origTime;
    }

    public String getOriginUser() {
        return this._origUser;
    }

    public String getTransactionName() {
        return this._tranName;
    }

    public String getTranID() {
        return this._tranID;
    }

    public String getQID() {
        return this._qid;
    }

    public int getSequenceNr() {
        return this._seqNr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessage(String string, int n, int n2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Object[] objectArray = new String[]{String.valueOf(n), String.valueOf(n2), String.valueOf(this.getSegment()), String.valueOf(this.getBlock()), String.valueOf(this.getRow())};
        int n3 = this.getDomain().getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(DELETE_MSG, n3, objectArray);
        Dbg.wassert(string2 != null, "Unable to get delete command, repserver version: " + n3);
        RSMConnection rSMConnection = this.getDomain().getConnection(string);
        if (rSMConnection != null) {
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("QueueRes", "NULL_SERVER", string), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeleteMessage(String string, int n, int n2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Object[] objectArray = new String[]{String.valueOf(n), String.valueOf(n2), String.valueOf(this.getSegment()), String.valueOf(this.getBlock()), String.valueOf(this.getRow())};
        int n3 = this.getDomain().getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(UNDELETE_MSG, n3, objectArray);
        Dbg.wassert(string2 != null, "Unable to get undelete command, repserver version: " + n3);
        RSMConnection rSMConnection = this.getDomain().getConnection(string);
        if (rSMConnection != null) {
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("QueueRes", "NULL_SERVER", string), "_RSM_", 3);
        }
    }
}

