/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.queue;

import com.sybase.central.SCDialogController;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseDialog;
import com.sybase.rsmplugin.components.BasePage;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.queue.QueueData;
import com.sybase.rsmplugin.components.queue.QueueDataPanel;
import com.sybase.rsmplugin.components.queue.RSQueue;
import com.sybase.rsmplugin.util.DateCellRenderer;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.RSMColumnSort;
import com.sybase.rsmplugin.util.RSMObjectRow;
import com.sybase.rsmplugin.util.SQLEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QueueDataDlg
extends BaseDialog {
    protected SCPageController[] _page = null;
    protected RSQueue _queue;

    public QueueDataDlg(SCDialogSupport2 sCDialogSupport2, RSQueue rSQueue) {
        super(sCDialogSupport2);
        Dbg.wassert(rSQueue != null, "Null queue parameter.");
        this._queue = rSQueue;
    }

    public RSQueue getQueue() {
        return this._queue;
    }

    @Override
    public void showDialog() {
        this.getDialogSupport().setDialogController((SCDialogController)this);
        this.getDialogSupport().setTitle(this.getTitle());
        this.getDialogSupport().setResizable(true);
        this.getDialogSupport().setStandardButtons(false);
        this.getDialogSupport().setModal(false);
        this.getDialogSupport().setHelpButton(false);
        PluginSupport.registerDialog(this);
        this.getDialogSupport().render();
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("QueueRes", "Q_DATA_DLG_TITLE", this.getQueue().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._page == null) {
            this._page = new SCPageController[]{new QueueDataPage()};
        }
        return this._page;
    }

    class QueueDataPage
    extends BasePage
    implements ActionListener,
    ListSelectionListener {
        private QueueDataPanel _goPage = new QueueDataPanel();
        private CustomSort _comparator = new CustomSort();

        public QueueDataPage() {
            this._goPage.tbl_queue_data.setSortComparator(this._comparator);
        }

        @Override
        public void onInitDialog() {
            this._goPage.chk_first_segment.setSelected(true);
            this._goPage.spn_segment.setEnabled(false);
            this._goPage.chk_show_deleted.setSelected(false);
            this._goPage.chk_end_of_segment.setSelected(true);
            this._goPage.spn_blk_count.setEnabled(false);
            this._goPage.chk_all_rows.setSelected(true);
            this._goPage.spn_row.setEnabled(false);
            this._goPage.tbl_queue_data.getColumnModel().getColumn(4).setCellRenderer(new DateCellRenderer());
            this.setButtons();
            this._goPage.chk_first_segment.addActionListener((ActionListener)this);
            this._goPage.chk_show_deleted.addActionListener((ActionListener)this);
            this._goPage.chk_end_of_segment.addActionListener((ActionListener)this);
            this._goPage.chk_end_of_queue.addActionListener((ActionListener)this);
            this._goPage.chk_all_rows.addActionListener((ActionListener)this);
            this._goPage.btn_show.addActionListener((ActionListener)this);
            this._goPage.btn_close.addActionListener((ActionListener)this);
            this._goPage.btn_purge_first.addActionListener((ActionListener)this);
            this._goPage.btn_edit.addActionListener((ActionListener)this);
            this._goPage.btn_group_trans.addActionListener((ActionListener)this);
            this._goPage.btn_delete.addActionListener((ActionListener)this);
            this._goPage.btn_undelete.addActionListener((ActionListener)this);
            this._goPage.tbl_queue_data.addListSelectionListener(this);
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setButtons();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.chk_first_segment) {
                if (this._goPage.chk_first_segment.isSelected()) {
                    this._goPage.chk_show_deleted.setSelected(false);
                    this._goPage.spn_segment.setEnabled(false);
                } else {
                    this._goPage.spn_segment.setEnabled(!this._goPage.chk_show_deleted.isSelected());
                }
            } else if (actionEvent.getSource() == this._goPage.chk_show_deleted) {
                if (this._goPage.chk_show_deleted.isSelected()) {
                    this._goPage.chk_first_segment.setSelected(false);
                    this._goPage.spn_segment.setEnabled(false);
                } else {
                    this._goPage.spn_segment.setEnabled(!this._goPage.chk_first_segment.isSelected());
                }
            } else if (actionEvent.getSource() == this._goPage.chk_end_of_segment) {
                if (this._goPage.chk_end_of_segment.isSelected()) {
                    this._goPage.chk_end_of_queue.setSelected(false);
                    this._goPage.spn_blk_count.setEnabled(false);
                } else {
                    this._goPage.spn_blk_count.setEnabled(!this._goPage.chk_end_of_queue.isSelected());
                }
            } else if (actionEvent.getSource() == this._goPage.chk_end_of_queue) {
                if (this._goPage.chk_end_of_queue.isSelected()) {
                    this._goPage.chk_end_of_segment.setSelected(false);
                    this._goPage.spn_blk_count.setEnabled(false);
                } else {
                    this._goPage.spn_blk_count.setEnabled(!this._goPage.chk_end_of_segment.isSelected());
                }
            } else if (actionEvent.getSource() == this._goPage.chk_all_rows) {
                this._goPage.spn_row.setEnabled(!this._goPage.chk_all_rows.isSelected());
            } else if (actionEvent.getSource() == this._goPage.btn_show) {
                this.displayData();
            } else if (actionEvent.getSource() == this._goPage.btn_close) {
                QueueDataDlg.this.closeDialog();
            } else if (actionEvent.getSource() == this._goPage.btn_purge_first) {
                this.purgeFirstTransaction();
            } else if (actionEvent.getSource() == this._goPage.btn_edit) {
                this.editTransaction();
            } else if (actionEvent.getSource() == this._goPage.btn_delete) {
                this.deleteRow();
            } else if (actionEvent.getSource() == this._goPage.btn_undelete) {
                this.undeleteRow();
            } else if (actionEvent.getSource() == this._goPage.btn_group_trans) {
                this._comparator.sortByTransaction(true);
                this._goPage.tbl_queue_data.sort();
                this._comparator.sortByTransaction(false);
                this._goPage.tbl_queue_data.setSortedColumnNumber(-1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void displayData() {
            this._goPage.tbl_queue_data.clear();
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(QueueDataDlg.this.getQueue().getDomainName());
            Dbg.wassert(semanticFactory != null, "Unable to get semantic factory for '" + QueueDataDlg.this.getQueue().getDomainName() + "'.");
            try {
                QueueDataDlg.this.getDialogSupport().startWait();
                int n = this._goPage.spn_segment.getValue();
                int n2 = this._goPage.spn_block.getValue();
                int n3 = this._goPage.spn_blk_count.getValue();
                int n4 = this._goPage.spn_row.getValue();
                if (this._goPage.chk_first_segment.isSelected()) {
                    n = -1;
                    n2 = -2;
                } else if (this._goPage.chk_show_deleted.isSelected()) {
                    n = -2;
                }
                if (this._goPage.chk_end_of_segment.isSelected()) {
                    n3 = -1;
                } else if (this._goPage.chk_end_of_queue.isSelected()) {
                    n3 = -2;
                }
                if (this._goPage.chk_all_rows.isSelected()) {
                    n4 = Integer.MAX_VALUE;
                }
                List list = semanticFactory.getQueueData(QueueDataDlg.this.getQueue().getControllingRS(), QueueDataDlg.this.getQueue().getQNumber(), QueueDataDlg.this.getQueue().getQType(), n, n2, n3, n4);
                this.filterKeyValues(list);
                if (list.size() > 0) {
                    this._goPage.tbl_queue_data.addRows(list);
                }
                this._comparator.sortByTransaction(true);
                this._goPage.tbl_queue_data.sort();
                this._comparator.sortByTransaction(false);
                this._goPage.tbl_queue_data.setSortedColumnNumber(-1);
                if (this._goPage.tbl_queue_data.getRowCount() > 0) {
                    this._goPage.tbl_queue_data.requestFocus();
                }
                this._goPage.tbl_queue_data.refresh();
                this.setButtons();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                QueueDataDlg.this.getDialogSupport().endWait();
            }
        }

        protected void filterKeyValues(List list) {
            int n;
            boolean bl = false;
            String string = this._goPage.fld_value.getText();
            int n2 = string.indexOf(42);
            if (n2 >= 0) {
                bl = true;
                string = string.substring(0, n2);
            }
            if ((n = this._goPage.cbx_key.getSelectedIndex()) > 0 && string != null && string.length() > 0) {
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    QueueData queueData = (QueueData)listIterator.next();
                    String string2 = (String)queueData.getValueAt(n - 1);
                    if (string2 == null) {
                        listIterator.remove();
                        continue;
                    }
                    if (bl) {
                        if (string2.startsWith(string)) continue;
                        listIterator.remove();
                        continue;
                    }
                    if (string2.equals(string)) continue;
                    listIterator.remove();
                }
            }
        }

        protected void setButtons() {
            boolean bl = this._goPage.tbl_queue_data.getRowCount() > 0;
            this._goPage.btn_purge_first.setEnabled(bl && QueueDataDlg.this.getQueue().isInbound());
            boolean bl2 = this._goPage.tbl_queue_data.getSelectedRowCount() > 0;
            this._goPage.btn_edit.setEnabled(bl2);
            this._goPage.btn_delete.setEnabled(bl2);
            this._goPage.btn_undelete.setEnabled(bl2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void purgeFirstTransaction() {
            if (PluginSupport.askQuestion(BundleManager.getString("QueueRes", "QUEUE_CONFIRM_PURGE_FIRST", QueueDataDlg.this.getQueue().getName()), QueueDataDlg.this.getDialogSupport().getJDialog(), false)) {
                try {
                    QueueDataDlg.this.getDialogSupport().startWait();
                    QueueDataDlg.this.getQueue().purgeFirstTransaction();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                finally {
                    QueueDataDlg.this.getDialogSupport().endWait();
                }
            }
        }

        protected void editTransaction() {
            int n = this._goPage.tbl_queue_data.getSelectedRow();
            if (n >= 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                QueueData queueData = (QueueData)this._goPage.tbl_queue_data.getRSMObjectRow(n);
                if (queueData != null) {
                    Object object;
                    ListIterator listIterator = this._goPage.tbl_queue_data.getTableModel().getRows().listIterator();
                    while (listIterator.hasNext()) {
                        object = (QueueData)listIterator.next();
                        if (!((QueueData)object).getTranID().equals(queueData.getTranID())) continue;
                        arrayList.add(object);
                    }
                    object = new Comparator(){

                        public int compare(Object object, Object object2) {
                            QueueData queueData = (QueueData)object;
                            QueueData queueData2 = (QueueData)object2;
                            return queueData.getQID().compareTo(queueData2.getQID());
                        }
                    };
                    Collections.sort(arrayList, object);
                    String string = "";
                    ListIterator listIterator2 = arrayList.listIterator();
                    while (listIterator2.hasNext()) {
                        QueueData queueData2 = (QueueData)listIterator2.next();
                        if (string.length() > 0 && queueData2.getSequenceNr() == 0) {
                            string = string + "\n";
                        }
                        string = string + queueData2.getCommand();
                    }
                    arrayList.clear();
                    if (string.length() > 0) {
                        SQLEditor.open(string);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deleteRow() {
            QueueData queueData;
            int n = this._goPage.tbl_queue_data.getSelectedRow();
            if (n >= 0 && (queueData = (QueueData)this._goPage.tbl_queue_data.getRSMObjectRow(n)) != null && PluginSupport.askQuestion(BundleManager.getString("QueueRes", "QUEUE_CONFIRM_DELETE", (String)queueData.getValueAt(0)), QueueDataDlg.this.getDialogSupport().getJDialog(), false)) {
                try {
                    QueueDataDlg.this.getDialogSupport().startWait();
                    queueData.deleteMessage(QueueDataDlg.this.getQueue().getControllingRS(), QueueDataDlg.this.getQueue().getQNumber(), QueueDataDlg.this.getQueue().getQType());
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                finally {
                    QueueDataDlg.this.getDialogSupport().endWait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void undeleteRow() {
            QueueData queueData;
            int n = this._goPage.tbl_queue_data.getSelectedRow();
            if (n >= 0 && (queueData = (QueueData)this._goPage.tbl_queue_data.getRSMObjectRow(n)) != null && PluginSupport.askQuestion(BundleManager.getString("QueueRes", "QUEUE_CONFIRM_UNDELETE", (String)queueData.getValueAt(0)), QueueDataDlg.this.getDialogSupport().getJDialog(), false)) {
                try {
                    QueueDataDlg.this.getDialogSupport().startWait();
                    queueData.undeleteMessage(QueueDataDlg.this.getQueue().getControllingRS(), QueueDataDlg.this.getQueue().getQNumber(), QueueDataDlg.this.getQueue().getQType());
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                finally {
                    QueueDataDlg.this.getDialogSupport().endWait();
                }
            }
        }

        class CustomSort
        extends RSMColumnSort {
            private boolean _transactionSort = true;

            CustomSort() {
            }

            public boolean isTransactionSort() {
                return this._transactionSort;
            }

            public void sortByTransaction(boolean bl) {
                this._transactionSort = bl;
            }

            @Override
            public int compare(Object object, Object object2) {
                int n;
                Dbg.wassert(object != null && object instanceof RSMObjectRow, "Null or invalid object1 parameter.");
                Dbg.wassert(object2 != null && object2 instanceof RSMObjectRow, "Null or invalid object2 parameter.");
                QueueData queueData = (QueueData)object;
                QueueData queueData2 = (QueueData)object2;
                if (this.isTransactionSort()) {
                    n = queueData._tranID.compareTo(queueData2._tranID);
                    if (n == 0) {
                        n = queueData._qid.compareTo(queueData2._qid);
                    }
                } else if (this.getColumn() == 0) {
                    n = queueData.getSegment() - queueData2.getSegment();
                    if (n == 0 && (n = queueData.getBlock() - queueData2.getBlock()) == 0) {
                        n = queueData.getRow() - queueData2.getRow();
                    }
                    if (n != 0) {
                        n = this.isAscending() ? n : -n;
                    }
                } else {
                    n = super.compare(object, object2);
                }
                return n;
            }
        }
    }
}

