/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.queue;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMItem;
import com.sybase.rsmplugin.components.queue.QueueDataDlg;
import com.sybase.rsmplugin.components.queue.QueueProperties;
import com.sybase.rsmplugin.components.queue.RSQueue;
import com.sybase.rsmplugin.components.queue.ResumeDlg;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class QueueItem
extends BaseItem
implements RMItem,
StatusItem {
    private static final String CLASS_ID = "queue.QueueItem";
    private static final int CMD_VIEW_DATA = 3008;
    public static ImageIcon _iconUp = null;
    public static ImageIcon _iconDown = null;
    public static ImageIcon _iconSuspect = null;
    private RSQueue _so;

    public QueueItem(RSQueue rSQueue, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(rSQueue != null, "Null queue semantic object parameter.");
        this._so = rSQueue;
        StatusManager.addStatusItem(this);
    }

    public QueueItem(RSQueue rSQueue) {
        Dbg.wassert(rSQueue != null, "Null queue semantic object parameter.");
        this._so = rSQueue;
        StatusManager.addStatusItem(this);
    }

    public RSQueue getQueue() {
        return this._so;
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getQueueUp());
        }
        return _iconUp;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getQueue().isUp()) {
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getQueueUp());
            }
            return _iconUp;
        }
        if (this.getQueue().isWarning()) {
            if (_iconSuspect == null) {
                _iconSuspect = new ImageIcon(RSMImages.getQueueSuspect());
            }
            return _iconSuspect;
        }
        if (_iconDown == null) {
            _iconDown = new ImageIcon(RSMImages.getQueueDown());
        }
        return _iconDown;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getQueue().getOwningObject();
            }
            case 1: {
                return this.getQueue().getTypeString();
            }
            case 2: {
                return String.valueOf(this.getQueue().getSize());
            }
            case 3: {
                return this.getQueue().getStateString();
            }
            case 4: {
                return this.getQueue().getReason();
            }
        }
        return "";
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 3006;
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu = null;
        defaultSCMenu = new DefaultSCMenu(BundleManager.getString("QueueRes", "MENU_ADD_QUEUE"));
        defaultSCMenu.setMnemonic((int)BundleManager.getMnemonic("QueueRes", "MENU_MNEM_ADD_QUEUE"));
        String string = BundleManager.getString("QueueRes", "MENU_RESUME");
        String string2 = BundleManager.getString("QueueRes", "MENU_HINT_RESUME");
        char c = BundleManager.getMnemonic("QueueRes", "MENU_MNEM_RESUME");
        MenuItem menuItem = new MenuItem(3006, string, string2, c);
        defaultSCMenu.addItem((SCMenuItem)menuItem);
        if (!this.getQueue().isControlledByRSMS()) {
            string = BundleManager.getString("QueueRes", "MENU_VIEW_DATA");
            string2 = BundleManager.getString("QueueRes", "MENU_HINT_VIEW_DATA");
            c = BundleManager.getMnemonic("QueueRes", "MENU_MNEM_VIEW_DATA");
            menuItem = new MenuItem(3008, string, string2, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
        }
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 64;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 100: 
            case 107: {
                BaseController baseController = PluginSupport.getDialog(QueueProperties.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                try {
                    SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                    QueueProperties queueProperties = new QueueProperties(this.getQueue(), this, sCDialogSupport2);
                    queueProperties.showDialog();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                break;
            }
            case 3006: {
                ResumeDlg resumeDlg = new ResumeDlg(PluginSupport.getDialogSupport(jFrame));
                if (!resumeDlg.showDialog()) break;
                ArrayList<RSQueue> arrayList = new ArrayList<RSQueue>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof QueueItem)) continue;
                    arrayList.add(((QueueItem)baseItem).getQueue());
                }
                if (arrayList.size() <= 0) break;
                this.getQueue().resume(arrayList, resumeDlg.getSkipFlag());
                break;
            }
            case 3008: {
                BaseController baseController = PluginSupport.getDialog(QueueDataDlg.class, this.getQueue().getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                QueueDataDlg queueDataDlg = new QueueDataDlg(sCDialogSupport2, this.getQueue());
                queueDataDlg.showDialog();
                break;
            }
        }
    }

    @Override
    public void setState(int n) {
        this.getQueue().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getQueue().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getQueue().getDomainName();
    }

    @Override
    public String getType() {
        return this.getQueue().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getQueue().getStateString();
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }
}

