/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.queue;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.queue.QPropGeneralPanel;
import com.sybase.rsmplugin.components.queue.QPropSQTPanel;
import com.sybase.rsmplugin.components.queue.QPropStatPanel;
import com.sybase.rsmplugin.components.queue.RSQueue;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.NumberFormat;
import javax.swing.JPanel;

public class QueueProperties
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected RSQueue _so;
    protected BaseItem _item;
    boolean _skip_wide_msg;

    public QueueProperties(RSQueue rSQueue, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) throws SQLException {
        super(sCDialogSupport2);
        Dbg.wassert(rSQueue != null, "Null semantic Queue parameter.");
        this._so = rSQueue;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        this._so.loadStatus();
    }

    public RSQueue getQueue() {
        return this._so;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("QueueRes", "PROPERTIES_TITLE", this.getQueue().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            if (this.getQueue().isRoute()) {
                this._pages = new SCPageController[]{new GeneralPage(this), new StatPage(this)};
            } else {
                String[] stringArray = null;
                String[] stringArray2 = null;
                try {
                    stringArray = this.getQueue().getDistSQTData();
                    stringArray2 = this.getQueue().getDSISQTData();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this._pages = stringArray != null && stringArray2 != null ? new SCPageController[]{new GeneralPage(this), new StatPage(this), new DistributorPage(this), new DSIPage(this)} : (stringArray != null ? new SCPageController[]{new GeneralPage(this), new StatPage(this), new DistributorPage(this)} : (stringArray2 != null ? new SCPageController[]{new GeneralPage(this), new StatPage(this), new DSIPage(this)} : new SCPageController[]{new GeneralPage(this), new StatPage(this)}));
            }
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        if (this._skip_wide_msg != this.getQueue().getLargeMsg()) {
            try {
                this.getQueue().alter(this._skip_wide_msg);
                this.getItem().getParent().refresh();
                return super.onOk();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
        return false;
    }

    @Override
    public void onApply() {
        if (this._skip_wide_msg != this.getQueue().getLargeMsg()) {
            try {
                this.getQueue().alter(this._skip_wide_msg);
                super.onApply();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    protected String format(String string) {
        String string2;
        NumberFormat numberFormat = NumberFormat.getInstance();
        try {
            string2 = numberFormat.format(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            string2 = string;
        }
        return string2;
    }

    protected void setFirstTranFields(String string, QPropSQTPanel qPropSQTPanel) {
        qPropSQTPanel.fld_status.setText("");
        qPropSQTPanel.fld_num_cmds.setText("");
        qPropSQTPanel.fld_address.setText("");
        if (string != null && string.length() > 0) {
            int n;
            String[] stringArray = string.split(",");
            if (stringArray.length > 0 && stringArray[0] != null && (n = stringArray[0].indexOf(58)) >= 0 && n < stringArray[0].length() - 1) {
                String string2 = stringArray[0].substring(n + 1);
                if (string2.equalsIgnoreCase("O")) {
                    qPropSQTPanel.fld_status.setText(BundleManager.getString("QueueRes", "Q_PROP_1ST_TRAN_OPEN"));
                } else if (string2.equalsIgnoreCase("C")) {
                    qPropSQTPanel.fld_status.setText(BundleManager.getString("QueueRes", "Q_PROP_1ST_TRAN_CLOSED"));
                } else if (string2.equalsIgnoreCase("R")) {
                    qPropSQTPanel.fld_status.setText(BundleManager.getString("QueueRes", "Q_PROP_1ST_TRAN_READ"));
                } else if (string2.equalsIgnoreCase("D")) {
                    qPropSQTPanel.fld_status.setText(BundleManager.getString("QueueRes", "Q_PROP_1ST_TRAN_DELETED"));
                } else {
                    qPropSQTPanel.fld_status.setText(string2);
                }
            }
            if (stringArray.length > 1 && stringArray[1] != null && (n = stringArray[1].indexOf(58)) >= 0 && n < stringArray[1].length() - 1) {
                qPropSQTPanel.fld_num_cmds.setText(stringArray[1].substring(n + 1));
            }
            if (stringArray.length > 2 && stringArray[2] != null && (n = stringArray[2].indexOf(58)) >= 0 && n < stringArray[2].length() - 1) {
                qPropSQTPanel.fld_address.setText(stringArray[2].substring(n + 1));
            }
        }
    }

    class DSIPage
    extends BasePropertyPage
    implements ActionListener {
        private QPropSQTPanel _goPage;

        public DSIPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("QueueRes", "Q_PROP_DSI_PAGE_TAG"));
            this._goPage = new QPropSQTPanel();
        }

        @Override
        public void onInitDialog() {
            this.load();
            this._goPage.btn_refresh.addActionListener((ActionListener)this);
        }

        protected void load() {
            try {
                String[] stringArray = QueueProperties.this.getQueue().getDSISQTData();
                if (stringArray != null && stringArray.length > 14) {
                    this._goPage.fld_state.setText(stringArray[1]);
                    this._goPage.fld_closed_trans.setText(QueueProperties.this.format(stringArray[3]));
                    this._goPage.fld_read_trans.setText(QueueProperties.this.format(stringArray[4]));
                    this._goPage.fld_open_trans.setText(QueueProperties.this.format(stringArray[5]));
                    this._goPage.fld_total_trans.setText(QueueProperties.this.format(stringArray[6]));
                    this._goPage.fld_removed_trans.setText(QueueProperties.this.format(stringArray[7]));
                    this._goPage.fld_parsed_trans.setText(QueueProperties.this.format(stringArray[11]));
                    QueueProperties.this.setFirstTranFields(stringArray[10], this._goPage);
                } else {
                    this._goPage.fld_state.setText(BundleManager.getString("QueueRes", "Q_PROP_MISSING_THREAD_STATE"));
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_refresh) {
                this.load();
            }
        }
    }

    class DistributorPage
    extends BasePropertyPage
    implements ActionListener {
        private QPropSQTPanel _goPage;

        public DistributorPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("QueueRes", "Q_PROP_DIST_PAGE_TAG"));
            this._goPage = new QPropSQTPanel();
        }

        @Override
        public void onInitDialog() {
            this.load();
            this._goPage.btn_refresh.addActionListener((ActionListener)this);
        }

        protected void load() {
            try {
                String[] stringArray = QueueProperties.this.getQueue().getDistSQTData();
                if (stringArray != null && stringArray.length > 14) {
                    this._goPage.fld_state.setText(stringArray[1]);
                    this._goPage.fld_closed_trans.setText(QueueProperties.this.format(stringArray[3]));
                    this._goPage.fld_read_trans.setText(QueueProperties.this.format(stringArray[4]));
                    this._goPage.fld_open_trans.setText(QueueProperties.this.format(stringArray[5]));
                    this._goPage.fld_total_trans.setText(QueueProperties.this.format(stringArray[6]));
                    this._goPage.fld_removed_trans.setText(QueueProperties.this.format(stringArray[7]));
                    this._goPage.fld_parsed_trans.setText(QueueProperties.this.format(stringArray[11]));
                    QueueProperties.this.setFirstTranFields(stringArray[10], this._goPage);
                } else {
                    this._goPage.fld_state.setText(BundleManager.getString("QueueRes", "Q_PROP_MISSING_THREAD_STATE"));
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_refresh) {
                this.load();
            }
        }
    }

    class StatPage
    extends BasePropertyPage
    implements ActionListener {
        private QPropStatPanel _goPage;

        public StatPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("QueueRes", "Q_PROP_STAT_PAGE_TAG"));
            this._goPage = new QPropStatPanel();
        }

        @Override
        public void onInitDialog() {
            this.load();
            this._goPage.btn_refresh.addActionListener((ActionListener)this);
        }

        protected void load() {
            try {
                String[] stringArray = QueueProperties.this.getQueue().getSQMData();
                if (stringArray != null && stringArray.length > 16) {
                    this._goPage.fld_duplicates.setText(QueueProperties.this.format(stringArray[3]));
                    this._goPage.fld_msg_written.setText(QueueProperties.this.format(stringArray[4]));
                    this._goPage.fld_msg_read.setText(QueueProperties.this.format(stringArray[5]));
                    this._goPage.fld_bytes_written.setText(QueueProperties.this.format(stringArray[6]));
                    this._goPage.fld_blocks_written.setText(QueueProperties.this.format(stringArray[7]));
                    this._goPage.fld_blocks_filled.setText(QueueProperties.this.format(stringArray[8]));
                    this._goPage.fld_blocks_read.setText(QueueProperties.this.format(stringArray[9]));
                    this._goPage.fld_cache_hits.setText(QueueProperties.this.format(stringArray[10]));
                    this._goPage.fld_first_block.setText(stringArray[12]);
                    this._goPage.fld_last_block.setText(stringArray[13]);
                    this._goPage.fld_next_block.setText(stringArray[14]);
                    this._goPage.fld_readers.setText(QueueProperties.this.format(stringArray[15]));
                    this._goPage.fld_truncations.setText(QueueProperties.this.format(stringArray[16]));
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_refresh) {
                this.load();
            }
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private QPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("QueueRes", "GENERAL_PAGE_TAG"));
            this._goPage = new QPropGeneralPanel();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_name.setText(QueueProperties.this.getQueue().getName());
            this._goPage.fld_object.setText(QueueProperties.this.getQueue().getOwningObject());
            this._goPage.fld_id.setText(QueueProperties.this.getQueue().getQueueID());
            this._goPage.fld_state.setText(QueueProperties.this.getQueue().getStateString());
            this._goPage.fld_reason.setText(QueueProperties.this.getQueue().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(QueueProperties.this.getQueue().getReasons().size() > 1);
            if (QueueProperties.this.getQueue().isRoute()) {
                this._goPage.lbl_object.setText(BundleManager.getString("QueueRes", "Q_PROP_ROUTE"));
            }
            QueueProperties.this._skip_wide_msg = QueueProperties.this.getQueue().getLargeMsg();
            this._goPage.chk_skip.setSelected(QueueProperties.this._skip_wide_msg);
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(QueueProperties.this.getQueue().getDomainName());
            RepServer repServer = semanticFactory.getRepServer(QueueProperties.this.getQueue().getControllingRS());
            try {
                repServer.loadProperties();
                this._goPage.chk_skip.setEnabled(repServer.getVersionNumber() >= 1250 && repServer.getSiteVersion() <= 1210);
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                this._goPage.chk_skip.setEnabled(false);
            }
            this._goPage.btn_more.addActionListener((ActionListener)this);
            this.loadRecoveryData();
        }

        protected void loadRecoveryData() {
            try {
                String string;
                int n;
                String[] stringArray = QueueProperties.this.getQueue().getSQMData();
                if (stringArray != null && stringArray.length > 11 && (n = (string = stringArray[11]).indexOf(58)) >= 0) {
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    this._goPage.fld_interval.setText(string2);
                    this._goPage.fld_oldest_segment.setText(string3);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }

        @Override
        public boolean onOk() {
            QueueProperties.this._skip_wide_msg = this._goPage.chk_skip.isSelected();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), QueueProperties.this.getQueue().getReasons(), QueueProperties.this.getQueue().getName());
                reasonListDlg.showDialog();
            }
        }
    }
}

