/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.queue;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.RMSStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.queue.DomainQueue;
import com.sybase.rsmplugin.components.queue.RSQueue;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RMSQueue
extends RMSStatusSO
implements RSQueue {
    private String _owningObject = null;
    private String _typeString = null;
    private int _q_number;
    private int _q_type;
    private int _size;
    private int _saved;
    private int _detect_loss;
    private int _ignore_loss;
    private int _first_segment;
    private boolean _xnl_large_msg = false;
    private static final String GET_QUEUES = "GET_QUEUES";
    private static final String GET_QUEUE = "GET_QUEUE";
    private static final String RESUME_QUEUE = "RESUME_QUEUE";
    private static final Object[][] contents = new Object[][]{{"GET_QUEUES", new Integer(1500), "get queues for {0}"}, {"GET_QUEUE", new Integer(1500), "get queues for {0}, {1}"}, {"RESUME_QUEUE", new Integer(1500), "resume queue, {0}, {1} {2}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSQueue(String string, String string2, RMSDomain rMSDomain) {
        super(string2, string, rMSDomain);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty queue name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty controlling rep server parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        this.parseName(string);
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
            this.addReason(BundleManager.getString("QueueRes", "QUEUE_STATE_UNKNOWN", this.getName()));
        }
    }

    public RMSQueue(String string, int n, int n2, String string2, RMSDomain rMSDomain) {
        super(string2, string, rMSDomain);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty queue name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty controlling rep server parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        this._owningObject = string;
        this._q_number = n;
        this._q_type = n2;
        this._typeString = this._owningObject.indexOf(".") == -1 ? "RSI" : (this._q_type == 1 ? "Inbound" : "Outbound");
        this.setName(this._owningObject + "(" + this._typeString + ")");
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
            this.addReason(BundleManager.getString("QueueRes", "QUEUE_STATE_UNKNOWN", this.getName()));
        }
    }

    protected void parseName(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty queue name parameter.");
        this.setName(string);
        String[] stringArray = string.split("[()]");
        if (stringArray.length < 2) {
            Dbg.wassert(false, "Unexpected queue name format.");
            this._owningObject = stringArray[0];
            this._typeString = "";
        } else {
            this._owningObject = stringArray[0];
            this._typeString = stringArray[1];
            if (this._owningObject.indexOf(".") == -1) {
                this._typeString = "RSI";
                this.setName(this._owningObject + "(" + this._typeString + ")");
            }
        }
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "Queue";
    }

    @Override
    public String getControllingRS() {
        return this.getControllingServer();
    }

    @Override
    public String getOwningObject() {
        return this._owningObject;
    }

    @Override
    public String getTypeString() {
        return this._typeString;
    }

    @Override
    public boolean isRoute() {
        return this._typeString.equals("RSI");
    }

    @Override
    public int getQNumber() {
        return this._q_number;
    }

    @Override
    public int getQType() {
        return this._q_type;
    }

    @Override
    public String getQueueID() {
        return String.valueOf(this.getQNumber()) + ":" + String.valueOf(this.getQType());
    }

    @Override
    public boolean isInbound() {
        return this._q_type == 1;
    }

    @Override
    public boolean isOutbound() {
        return this._q_type == 0;
    }

    @Override
    public boolean isSubscriptionMaterialization() {
        return this._q_type < 0;
    }

    @Override
    public int getSize() {
        return this._size;
    }

    @Override
    public int getSaved() {
        return this._saved;
    }

    @Override
    public int getDetectLoss() {
        return this._detect_loss;
    }

    @Override
    public int getIgnoreLoss() {
        return this._ignore_loss;
    }

    @Override
    public boolean getLargeMsg() {
        return this._xnl_large_msg;
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("QueueRes", "ACTIVE_STATE");
                break;
            }
            case 2: {
                string = BundleManager.getString("QueueRes", "SUSPENDED_STATE");
                break;
            }
            case 6: {
                string = BundleManager.getString("QueueRes", "STATE_LOSS_DETECTED");
                break;
            }
            case 3: {
                string = BundleManager.getString("QueueRes", "UNKNOWN_STATE");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public boolean isError() {
        return this.getRSState() == 2;
    }

    @Override
    public boolean isWarning() {
        return this.getRSState() == 3 || this.getRSState() == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getQueues(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        ArrayList<RMSQueue> arrayList = new ArrayList<RMSQueue>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_QUEUES, n, string);
            Dbg.wassert(string2 != null, "Unable to get queue query, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(2);
                    if (string3 == null || string3.length() <= 0) continue;
                    RMSQueue rMSQueue = new RMSQueue(string3, string, rMSDomain);
                    rMSQueue._q_number = rSMResultSet.getColumnInt(4);
                    rMSQueue._q_type = rSMResultSet.getColumnInt(5);
                    rMSQueue._size = rSMResultSet.getColumnInt(6);
                    int n2 = rSMResultSet.getColumnInt(8);
                    rMSQueue.setState(n2);
                    rMSQueue.clearReasons();
                    arrayList.add(rMSQueue);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("QueueRes", "NULL_SERVER", string), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadStatus() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("QueueRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        String string = this.isRoute() ? this.getOwningObject() + "(" + "Outbound" + ")" : this.getName();
        int n = this.getDomain().getRMSVersionNumber();
        Object[] objectArray = new String[]{this.getControllingRS(), string};
        String string2 = _cmdBundle.getCommand(GET_QUEUE, n, objectArray);
        Dbg.wassert(string2 != null, "Unable to get queue query, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string2);
            if (!rSMResultSet.getNextRow()) return;
            int n2 = rSMResultSet.getColumnInt(8);
            this.setState(n2);
            this.clearReasons();
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    @Override
    public void resume(final List list, final boolean bl) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("QueueRes", "RESUME_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            DomainQueue domainQueue = (DomainQueue)listIterator.next();
                            this.setStatus(BundleManager.getString("RouteRes", "RESUME_DLG_TITLE", domainQueue.getName()));
                            domainQueue.resume(bl);
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    RMSQueue.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    public void resume(boolean bl) throws SQLException {
    }

    @Override
    public void purgeFirstTransaction() throws SQLException {
    }

    @Override
    public void alter(boolean bl) throws SQLException {
    }

    @Override
    public String[] getSQMData() throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        String[] stringArray = null;
        List list = semanticFactory.getSQMThreads(this.getControllingRS());
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext() && stringArray == null) {
                String[] stringArray2 = (String[])listIterator.next();
                String[] stringArray3 = stringArray2[2].split("\\s+");
                if (stringArray3.length != 2 || !stringArray3[0].equalsIgnoreCase(this.getQueueID()) || !stringArray3[1].equalsIgnoreCase(this.getOwningObject())) continue;
                stringArray = stringArray2;
            }
        }
        return stringArray;
    }

    @Override
    public String[] getDistSQTData() throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        String[] stringArray = null;
        List list = semanticFactory.getSQTThreads(this.getControllingRS());
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext() && stringArray == null) {
                String[] stringArray2 = (String[])listIterator.next();
                String[] stringArray3 = stringArray2[2].split("\\s+");
                if (stringArray3.length != 3 || !stringArray3[0].equalsIgnoreCase(this.getQueueID()) || !stringArray3[1].equalsIgnoreCase("DIST") || !stringArray3[2].equalsIgnoreCase(this.getOwningObject())) continue;
                stringArray = stringArray2;
            }
        }
        return stringArray;
    }

    @Override
    public String[] getDSISQTData() throws SQLException {
        String[] stringArray;
        Object object;
        Object object2;
        int n;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        String string = this.getOwningObject();
        String string2 = String.valueOf(this.getQNumber());
        boolean bl = false;
        if (this.isInbound() && (n = string.indexOf(46)) > 0) {
            object2 = string.substring(0, n);
            object = string.substring(n + 1);
            stringArray = semanticFactory.getLogConnection(this.getControllingRS(), (String)object2, (String)object);
            if (stringArray != null) {
                try {
                    stringArray.load();
                    if (stringArray.exists()) {
                        bl = true;
                        string = stringArray.getStandbyConnectionName();
                        string2 = "*";
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        String[] stringArray2 = null;
        if ((this.isOutbound() || this.isInbound() && bl) && (object2 = semanticFactory.getSQTThreads(this.getControllingRS())) != null) {
            object = object2.listIterator();
            while (object.hasNext() && stringArray2 == null) {
                stringArray = (String[])object.next();
                String[] stringArray3 = stringArray[2].split("\\s+");
                if (stringArray3.length != 2 || !stringArray3[0].equalsIgnoreCase(string2) && !string2.equals("*") || !stringArray3[1].equalsIgnoreCase(string)) continue;
                stringArray2 = stringArray;
            }
        }
        return stringArray2;
    }
}

