/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.remoterms;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.RMSServerStatusSO;
import com.sybase.rsmplugin.components.remoterms.RemoteRMS;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RMSRemoteRMS
extends RMSServerStatusSO
implements RemoteRMS,
Comparable {
    String _lastMonitored = null;
    String _monitoredBy = null;
    String _versionString = null;
    private static final String GET_REMOTERMS = "GET_REMOTERMS";
    private static final Object[][] contents = new Object[][]{{"GET_REMOTERMS", new Integer(15000), "get servers RMS"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSRemoteRMS(String string, RMSDomain rMSDomain) {
        super(string, rMSDomain);
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof RMSRemoteRMS) {
            return this.getName().compareTo(((RMSRemoteRMS)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-RMSRemoteRMS object.");
        return -1;
    }

    @Override
    public String getServerType() {
        return "Replication Monitoring Services";
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "RMS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRemoteRMSs(RMSDomain rMSDomain) {
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        ArrayList<RMSRemoteRMS> arrayList = new ArrayList<RMSRemoteRMS>(1);
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_REMOTERMS, n);
            Dbg.wassert(string != null, "Unable to get mirror rep agent command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    String string3 = rSMResultSet.getColumnString(2);
                    if (!string3.equalsIgnoreCase("RMS")) continue;
                    RMSRemoteRMS rMSRemoteRMS = new RMSRemoteRMS(string2, rMSDomain);
                    rMSRemoteRMS._lastMonitored = rSMResultSet.getColumnString(3);
                    rMSRemoteRMS._versionString = rSMResultSet.getColumnString(4);
                    int n2 = rSMResultSet.getColumnInt(5);
                    rMSRemoteRMS.setState(n2);
                    String string4 = rSMResultSet.getColumnString(6);
                    String string5 = rSMResultSet.getColumnString(7);
                    boolean bl = rSMResultSet.getColumnBool(8);
                    arrayList.add(rMSRemoteRMS);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void monitor() {
    }

    @Override
    public String getVersionString() {
        return this._versionString != null ? this._versionString : "";
    }

    @Override
    public String getLastMonitoredDate() {
        return this._lastMonitored != null ? this._lastMonitored : "";
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("RemoteRMSRes", "ACTIVE_STATE");
                break;
            }
            case 4: {
                string = BundleManager.getString("RemoteRMSRes", "SUSPECT_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("RemoteRMSRes", "TIMED_OUT_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("RemoteRMSRes", "UNKNOWN_STATE");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }
}

