/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.remoterms;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.CommPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.remoterms.RemoteRMS;
import com.sybase.rsmplugin.components.remoterms.RemoteRMSPropGeneralPanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JPanel;

public class RemoteRMSProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected RemoteRMS _remoteRMS;
    protected BaseItem _item;

    RemoteRMSProp(RemoteRMS remoteRMS, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(remoteRMS != null, "Null RemoteRMS parameter.");
        this._remoteRMS = remoteRMS;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(remoteRMS.getDomainName());
        try {
            this._remoteRMS.loadProperties();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    RemoteRMS getRemoteRMS() {
        return this._remoteRMS;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("RemoteRMSRes", "PROPERTIES_TITLE", this.getRemoteRMS().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new CommPage((BaseProperties)this, this.getRemoteRMS())};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        return super.onOk();
    }

    @Override
    public void onApply() {
        super.onApply();
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private RemoteRMSPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("RemoteRMSRes", "GENERAL_PAGE_TAG"));
            this._goPage = new RemoteRMSPropGeneralPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_name.setText(RemoteRMSProp.this.getRemoteRMS().getName());
            this._goPage.fld_version.setText(RemoteRMSProp.this.getRemoteRMS().getVersionString());
            this._goPage.fld_version.setCaretPosition(0);
            this._goPage.fld_state.setText(RemoteRMSProp.this.getRemoteRMS().getStateString());
            this._goPage.fld_reason.setText(RemoteRMSProp.this.getRemoteRMS().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(RemoteRMSProp.this.getRemoteRMS().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onOk() {
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), RemoteRMSProp.this.getRemoteRMS().getReasons(), RemoteRMSProp.this.getRemoteRMS().getName());
                reasonListDlg.showDialog();
            } else {
                this.setModified(true);
            }
        }
    }
}

