/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repagent;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;

public class DomainRepAgent
implements RepAgent {
    private static final int REP_AGENT_NOT_ENABLED_CODE = 18374;
    private EnvDomain _domain = null;
    private String _repServer = null;
    private String _ds = null;
    private String _db = null;
    private String _username = null;
    private String _password = null;
    private int _state;
    private String _reason = null;
    private static final String ENABLE = "ENABLE";
    private static final String DISABLE = "DISABLE";
    private static final String IS_ENABLED = "IS_ENABLED";
    private static final String START = "START";
    private static final String STOP = "STOP";
    private static final String SP_REPTOSTANDBY = "SP_REPTOSTANDBY";
    private static final String SP_CONFIGREPAGENT = "SP_CONFIGREPAGENT";
    private static final Object[][] contents = new Object[][]{{"ENABLE", new Integer(1200), "sp_config_rep_agent ''{0}'', enable, ''{1}'', ''{2}'', ''{3}''"}, {"DISABLE", new Integer(1200), "sp_config_rep_agent ''{0}'', disable, ''preserve secondary truncpt''"}, {"IS_ENABLED", new Integer(1200), "sp_help_rep_agent ''{0}'', process"}, {"START", new Integer(1200), "sp_start_rep_agent ''{0}''"}, {"STOP", new Integer(1200), "sp_stop_rep_agent ''{0}'' {1}"}, {"SP_REPTOSTANDBY", new Integer(120000), "sp_reptostandby {0}, \"all\""}, {"SP_CONFIGREPAGENT", new Integer(120000), "sp_config_rep_agent {0}, \"send_warm_standby_xact\", \"true\""}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainRepAgent(String string, String string2, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty DB parameter.");
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        this._ds = string;
        this._db = string2;
        this._domain = envDomain;
        this._state = 3;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        Dbg.wassert(this._db != null && this._db.length() > 0, "Null or empty database name attribute.");
        return this._db;
    }

    @Override
    public String getDS() {
        Dbg.wassert(this._ds != null && this._ds.length() > 0, "Null or empty data server name attribute.");
        return this._ds;
    }

    @Override
    public String getControllingRS() {
        Dbg.wassert(this._repServer != null && this._repServer.length() > 0, "Null or empty controlling rep server name attribute.");
        return this._repServer;
    }

    @Override
    public void setControllingRS(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        this._repServer = string;
    }

    @Override
    public String getUsername() {
        Dbg.wassert(this._username != null && this._username.length() > 0, "Null or empty username attribute.");
        return this._username;
    }

    @Override
    public void setUsername(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        this._username = string;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String string) {
        this._password = string;
    }

    @Override
    public boolean isEnabled() {
        this.loadStatus();
        return this.getState() == 5 || this.getState() == 2;
    }

    @Override
    public boolean isStarted() {
        this.loadStatus();
        return this.getState() == 5;
    }

    @Override
    public boolean isStopped() {
        this.loadStatus();
        return this.getState() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enable() throws SQLException {
        if (!this.isEnabled()) {
            ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
            if (aSEConnection != null && aSEConnection.getType().equals("ASE")) {
                int n = aSEConnection.getVersionNumber();
                Object[] objectArray = new String[]{this.getName(), this.getControllingRS(), this.getUsername(), this.getPassword()};
                String string = _cmdBundle.getCommand(ENABLE, n, objectArray);
                Dbg.wassert(string != null, "Unable to get enable command, ASE server version: " + n);
                try {
                    aSEConnection.use(this.getName());
                    aSEConnection.execute(string);
                }
                finally {
                    aSEConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable() throws SQLException {
        if (this.isEnabled()) {
            ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
            if (aSEConnection != null && aSEConnection.getType().equals("ASE")) {
                int n = aSEConnection.getVersionNumber();
                String string = _cmdBundle.getCommand(DISABLE, n, this.getName());
                Dbg.wassert(string != null, "Unable to get disable command, ASE server version: " + n);
                try {
                    aSEConnection.use(this.getName());
                    aSEConnection.execute(string);
                }
                finally {
                    aSEConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void loadStatus() {
        var1_1 = 3;
        var2_2 = (ASEConnection)this.getDomain().getConnection(this.getDS());
        if (var2_2 != null && var2_2.getType().equals("ASE")) {
            var3_3 = var2_2.getVersionNumber();
            var4_4 = DomainRepAgent._cmdBundle.getCommand("IS_ENABLED", var3_3, this.getName());
            Dbg.wassert(var4_4 != null, "Unable to get State command, ASE server version: " + var3_3);
            var5_5 = new RSMResultSet(var2_2);
            try {
                var5_5.open(var4_4);
                if (!var5_5.getNextRow()) ** GOTO lbl34
                var6_6 = var5_5.getColumnString(2);
                if (var6_6 != null && var6_6.length() > 0 && !var6_6.equalsIgnoreCase("n/a")) {
                    var7_8 = var5_5.getColumnString(3);
                    Dbg.trace(256, "Replication agent thread is enabled and started. sleep status = " + var7_8);
                    var1_1 = 5;
                    this.setReason(BundleManager.getString("RepAgentRes", "RA_STARTED_MSG", this.getName()));
                }
                Dbg.trace(256, "Replication agent thread is stopped.");
                var1_1 = 2;
                this.setReason(BundleManager.getString("RepAgentRes", "RA_STOPPED_MSG", this.getName()));
            }
            catch (SQLException var6_7) {
                var1_1 = 6;
                if (var6_7.getErrorCode() == 18374) {
                    this.setReason(BundleManager.getString("RepAgentRes", "RA_DISABLED_MSG", this.getName()));
                }
                this.setReason(MessageText.formatSQLExceptionDetails(var6_7));
            }
            finally {
                var5_5.close();
                var2_2.unlock();
            }
        } else {
            this.setReason(BundleManager.getString("RepAgentRes", "RA_UNKNOWN_MSG", this.getName()));
        }
lbl34:
        // 6 sources

        this._state = var1_1;
    }

    @Override
    public int getState() {
        return this._state;
    }

    @Override
    public String getReason() {
        return this._reason == null || this._reason.length() == 0 ? "" : this._reason;
    }

    protected void setReason(String string) {
        this._reason = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws SQLException {
        if (this.isStopped()) {
            ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
            if (aSEConnection != null && aSEConnection.getType().equals("ASE")) {
                int n = aSEConnection.getVersionNumber();
                String string = _cmdBundle.getCommand(START, n, this.getName());
                Dbg.wassert(string != null, "Unable to get start command, ASE server version: " + n);
                try {
                    aSEConnection.execute(string);
                }
                finally {
                    aSEConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean bl) throws SQLException {
        if (this.isStarted()) {
            ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
            if (aSEConnection != null && aSEConnection.getType().equals("ASE")) {
                int n = aSEConnection.getVersionNumber();
                Object[] objectArray = new String[]{this.getName(), bl ? ", nowait" : ""};
                String string = _cmdBundle.getCommand(STOP, n, objectArray);
                Dbg.wassert(string != null, "Unable to get stop command, ASE server version: " + n);
                try {
                    aSEConnection.execute(string);
                }
                finally {
                    aSEConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRepToStandby() throws SQLException {
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
        if (aSEConnection != null) {
            int n = aSEConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(SP_REPTOSTANDBY, n, this.getName());
            Dbg.wassert(string != null, "Unable to get SP_REPTOSTANDBY command, ASE version: " + n);
            try {
                aSEConnection.use(this.getName());
                aSEConnection.execute(string);
            }
            finally {
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSendWarmStandbyXact() throws SQLException {
        ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(this.getDS());
        if (aSEConnection != null) {
            int n = aSEConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(SP_CONFIGREPAGENT, n, this.getName());
            Dbg.wassert(string != null, "Unable to get SP_CONFIGREPAGENT command, ASE version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(aSEConnection);
            try {
                aSEConnection.use(this.getName());
                rSMResultSet.open(string);
            }
            finally {
                rSMResultSet.close();
                aSEConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
        }
    }

    @Override
    public void cycle() throws SQLException {
        this.stop(false);
        this.waitForState(2, 60);
        this.start();
    }

    @Override
    public void configure() throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
        ASE aSE = semanticFactory.getASE(this.getDS());
        Dbg.wassert(aSE != null, "Cannot retrieve ASE server '" + this.getDS() + "' from semantic factory.");
        if (!aSE.areRAThreadsEnabled()) {
            aSE.enableReplication();
        }
        this.enable();
    }

    @Override
    public boolean waitForState(int n, int n2) throws SQLException {
        switch (n) {
            case 6: {
                Dbg.trace(1, "Begin waiting for the Rep Agent to be enabled.");
                break;
            }
            case 5: {
                Dbg.trace(1, "Begin waiting for the Rep Agent to start.");
                break;
            }
            case 2: {
                Dbg.trace(1, "Begin waiting for the Rep Agent to stop.");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected state parameter.");
            }
        }
        long l = System.currentTimeMillis() + (long)(n2 * 1000);
        while (l > System.currentTimeMillis()) {
            this.loadStatus();
            if (this.getState() == n) {
                Dbg.trace(1, "The Rep Agent has changed state.");
                return true;
            }
            try {
                Dbg.trace(1, "Waiting for Rep Agent...");
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Dbg.trace(1, "The Rep Agent did not change states, time limit reached.");
        return false;
    }
}

