/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repagent;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.repagent.RepAgentParameter;
import com.sybase.rsmplugin.sql.ASEConnection;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DomainRepAgentParameter
extends RepAgentParameter {
    private EnvDomain _domain = null;
    private static final String GET_PARAMS = "GET_PARAMS";
    private static final String SET_PARAM = "SET_PARAM";
    private static final Object[][] contents = new Object[][]{{"GET_PARAMS", new Integer(120000), "sp_config_rep_agent ''{0}''"}, {"SET_PARAM", new Integer(120000), "sp_config_rep_agent ''{0}'', ''{1}'', ''{2}''"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainRepAgentParameter(String string, String string2, String string3, String string4, EnvDomain envDomain) {
        super(string, string2, string3, string4);
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._domain = envDomain;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRepAgentParameters(String string, String string2, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty ASE server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        ArrayList<DomainRepAgentParameter> arrayList = new ArrayList<DomainRepAgentParameter>();
        RSMConnection rSMConnection = envDomain.getConnection(string);
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string3 = _cmdBundle.getCommand(GET_PARAMS, n, string2);
            Dbg.wassert(string3 != null, "Unable to get parameter query command, ASE version: " + n);
            Dbg.wassert(rSMConnection.getType().equals("ASE"), "Wrong connection type, expected ASE connection.");
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string3);
                while (rSMResultSet.getNextRow()) {
                    String string4 = rSMResultSet.getColumnString(1);
                    String string5 = rSMResultSet.getColumnString(2);
                    String string6 = rSMResultSet.getColumnString(3);
                    String string7 = rSMResultSet.getColumnString(4);
                    DomainRepAgentParameter domainRepAgentParameter = new DomainRepAgentParameter(string4, string5, string7, string6, envDomain);
                    arrayList.add(domainRepAgentParameter);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty ASE server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty database name parameter.");
        if (this.isModified()) {
            ASEConnection aSEConnection = (ASEConnection)this.getDomain().getConnection(string);
            if (aSEConnection != null) {
                int n = aSEConnection.getVersionNumber();
                Object[] objectArray = new String[]{string2, this.getName(), this.getPendingValue()};
                String string3 = _cmdBundle.getCommand(SET_PARAM, n, objectArray);
                Dbg.wassert(string3 != null, "Unable to get set parameter command, repserver version: " + n);
                Dbg.wassert(aSEConnection.getType().equals("ASE"), "Wrong connection type, expected ASE connection.");
                RSMResultSet rSMResultSet = new RSMResultSet(aSEConnection);
                try {
                    aSEConnection.use(string2);
                    rSMResultSet.open(string3);
                    this.resetOriginalPendingValue();
                }
                finally {
                    rSMResultSet.close();
                    aSEConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", string), "_RSM_", 3);
            }
        }
    }
}

