/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repagent;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RMSRepAgent
implements RepAgent {
    private static final int REP_AGENT_NOT_ENABLED_CODE = 18374;
    private RMSDomain _domain = null;
    private String _repServer = null;
    private String _ds = null;
    private String _db = null;
    private String _username = null;
    private String _password = null;
    private int _state;
    private String _reason = null;
    private static final String GET_REP_AGENTS = "GET_REP_AGENTS";
    private static final String GET_STATUS = "GET_STATUS";
    private static final String START = "START";
    private static final String STOP = "STOP";
    private static final Object[][] contents = new Object[][]{{"GET_REP_AGENTS", new Integer(15000), "get repagents for {0}"}, {"GET_STATUS", new Integer(15000), "get repagents for {0}, {1}"}, {"START", new Integer(15000), "resume rep agent {0} for {1}"}, {"STOP", new Integer(15000), "suspend rep agent {0} for {1} {2}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSRepAgent(String string, String string2, RMSDomain rMSDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty DS parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty DB parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        this._ds = string;
        this._db = string2;
        this._domain = rMSDomain;
        this._state = 3;
    }

    public RMSDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return true;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        Dbg.wassert(this._db != null && this._db.length() > 0, "Null or empty database name attribute.");
        return this._db;
    }

    @Override
    public String getDS() {
        Dbg.wassert(this._ds != null && this._ds.length() > 0, "Null or empty data server name attribute.");
        return this._ds;
    }

    @Override
    public String getControllingRS() {
        Dbg.wassert(this._repServer != null && this._repServer.length() > 0, "Null or empty controlling rep server name attribute.");
        return this._repServer;
    }

    @Override
    public void setControllingRS(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        this._repServer = string;
    }

    @Override
    public String getUsername() {
        Dbg.wassert(this._username != null && this._username.length() > 0, "Null or empty username attribute.");
        return this._username;
    }

    @Override
    public void setUsername(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        this._username = string;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String string) {
        this._password = string;
    }

    @Override
    public boolean isEnabled() {
        return this.getState() == 5 || this.getState() == 2;
    }

    @Override
    public boolean isStarted() {
        return this.getState() == 5;
    }

    @Override
    public boolean isStopped() {
        return this.getState() == 2;
    }

    @Override
    public void enable() throws SQLException {
    }

    @Override
    public void disable() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRepAgents(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty ASE name parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        ArrayList<RMSRepAgent> arrayList = new ArrayList<RMSRepAgent>();
        int n = 3;
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n2 = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_REP_AGENTS, n2, string);
            Dbg.wassert(string2 != null, "Unable to get Rep Agent status command, RMS version: " + n2);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    RMSRepAgent rMSRepAgent = new RMSRepAgent(string3, string4, rMSDomain);
                    rMSRepAgent._state = rSMResultSet.getColumnInt(5);
                    String string5 = rSMResultSet.getColumnString(7);
                    if (string5 != null && string5.length() > 0) {
                        rMSRepAgent.setReason(string5);
                    }
                    arrayList.add(rMSRepAgent);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadStatus() {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getDomain().getRMSVersionNumber();
            Object[] objectArray = new String[]{this.getDS(), this.getName()};
            String string = _cmdBundle.getCommand(GET_STATUS, n, objectArray);
            Dbg.wassert(string != null, "Unable to get Rep Agent status command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                if (!rSMResultSet.getNextRow()) return;
                String string2 = rSMResultSet.getColumnString(1);
                String string3 = rSMResultSet.getColumnString(2);
                Dbg.wassert(this.getDS().equals(string2) && this.getName().equals(string3), "RMS returned the wrong rep agent thread.");
                this._state = rSMResultSet.getColumnInt(5);
                String string4 = rSMResultSet.getColumnString(7);
                if (string4 == null || string4.length() <= 0) return;
                this.setReason(string4);
                return;
            }
            catch (SQLException sQLException) {
                this._state = 6;
                this.setReason(MessageText.formatSQLExceptionDetails(sQLException));
                return;
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        } else {
            this.setReason(BundleManager.getString("RepAgentRes", "RA_UNKNOWN_MSG", this.getName()));
        }
    }

    @Override
    public int getState() {
        return this._state;
    }

    @Override
    public String getReason() {
        return this._reason == null || this._reason.length() == 0 ? "" : this._reason;
    }

    protected void setReason(String string) {
        this._reason = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
        int n = this.getDomain().getRMSVersionNumber();
        Object[] objectArray = new String[]{this.getName(), this.getDS()};
        String string = _cmdBundle.getCommand(START, n, objectArray);
        Dbg.wassert(string != null, "Unable to get start command, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stop(boolean bl) throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getDS()), "_RSM_", 3);
        int n = this.getDomain().getRMSVersionNumber();
        Object[] objectArray = new String[]{this.getName(), this.getDS(), bl ? "with nowait" : ""};
        String string = _cmdBundle.getCommand(STOP, n, objectArray);
        Dbg.wassert(string != null, "Unable to get stop command, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    @Override
    public void setRepToStandby() throws SQLException {
    }

    @Override
    public void setSendWarmStandbyXact() throws SQLException {
    }

    @Override
    public void cycle() throws SQLException {
    }

    @Override
    public void configure() throws SQLException {
    }

    @Override
    public boolean waitForState(int n, int n2) throws SQLException {
        switch (n) {
            case 6: {
                Dbg.trace(1, "Begin waiting for the Rep Agent to be enabled.");
                break;
            }
            case 5: {
                Dbg.trace(1, "Begin waiting for the Rep Agent to start.");
                break;
            }
            case 2: {
                Dbg.trace(1, "Begin waiting for the Rep Agent to stop.");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected state parameter.");
            }
        }
        long l = System.currentTimeMillis() + (long)(n2 * 1000);
        while (l > System.currentTimeMillis()) {
            this.loadStatus();
            if (this.getState() == n) {
                Dbg.trace(1, "The Rep Agent has changed state.");
                return true;
            }
            try {
                Dbg.trace(1, "Waiting for Rep Agent...");
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Dbg.trace(1, "The Rep Agent did not change states, time limit reached.");
        return false;
    }
}

