/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repagent;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.ConfigParameter;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class RepAgentParameter
implements RSMObjectRow,
ConfigParameter {
    public static final int NAME_COLUMN = 0;
    public static final int DATATYPE_COLUMN = 1;
    public static final int LEGAL_VALUE_COLUMN = 2;
    public static final Object[][] _details = new Object[][]{{"batch ltl", new Integer(3), "list: false, true"}, {"connect database", new Integer(2), " "}, {"connect dataserver", new Integer(2), " "}, {"data limits filter mode", new Integer(2), "list: off, stop, skip, truncate"}, {"fade timeout", new Integer(0), " "}, {"msg confidentiality", new Integer(3), "list: false, true"}, {"msg integrity", new Integer(3), "list: false, true"}, {"msg origin check", new Integer(3), "list: false, true"}, {"msg out-of-sequence check", new Integer(3), "list: false, true"}, {"msg replay detection", new Integer(3), "list: false, true"}, {"mutual authentication", new Integer(3), "list: false, true"}, {"priority", new Integer(0), "range: 4,6"}, {"retry timeout", new Integer(0), " "}, {"rs servername", new Integer(2), " "}, {"rs username", new Integer(2), " "}, {"scan batch size", new Integer(0), " "}, {"scan timeout", new Integer(0), " "}, {"schema cache growth factor", new Integer(0), "range: 1, 10"}, {"security mechanism", new Integer(2), " "}, {"send buffer size", new Integer(2), "list: 2K, 4K, 8K, 16K"}, {"send maint xacts to replicate", new Integer(3), "list: false, true"}, {"send structured oqids", new Integer(3), "list: false, true"}, {"send warm standby xacts", new Integer(3), "list: false, true"}, {"short ltl keywords", new Integer(3), "list: false, true"}, {"skip ltl errors", new Integer(3), "list: false, true"}, {"skip unsupported features", new Integer(3), "list: false, true"}, {"trace flags", new Integer(2), " "}, {"trace log file", new Integer(2), " "}, {"unified login", new Integer(3), "list: false, true"}};
    private String _name;
    private String _defaultValue;
    private String _currentValue;
    private String _pendingValue;
    private String _originalPendingValue;
    private static final int COLUMN_COUNT = 3;

    public RepAgentParameter(String string, String string2, String string3, String string4) {
        this._name = string;
        this._defaultValue = string2;
        this._currentValue = string3;
        this._pendingValue = string4;
        this.resetOriginalPendingValue();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract void alter(String var1, String var2) throws SQLException;

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getCurrentValue();
            }
            case 2: {
                if (!this.isModified() && this.getOriginalPendingValue().equals(this.getCurrentValue())) {
                    return "";
                }
                if (this.getDatatype() == 4) {
                    return "********";
                }
                return this.getPendingValue();
            }
        }
        return " ";
    }

    @Override
    public void setValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                this._name = (String)object;
                break;
            }
            case 1: {
                this._currentValue = (String)object;
                break;
            }
            case 2: {
                this._pendingValue = (String)object;
                break;
            }
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public String getPendingValue() {
        return this._pendingValue;
    }

    @Override
    public void setPendingValue(String string) {
        if (string != null && !this._pendingValue.equals(string)) {
            this._pendingValue = string;
        }
    }

    protected String getOriginalPendingValue() {
        return this._originalPendingValue;
    }

    public void resetOriginalPendingValue() {
        this._originalPendingValue = this._pendingValue;
    }

    @Override
    public boolean isModified() {
        return !this.getPendingValue().equals(this.getOriginalPendingValue());
    }

    @Override
    public String getDefaultValue() {
        return this._defaultValue;
    }

    @Override
    public String getStatus() {
        return BundleManager.getString("ComponentRes", "DISP_RESTART_YES_TEXT");
    }

    @Override
    public boolean isRestartRequired() {
        return true;
    }

    @Override
    public String getLegalValues() {
        int n = this.getDetails();
        if (n == -1) {
            return " ";
        }
        return _details[n][2].toString();
    }

    @Override
    public String getExplanation() {
        String string;
        try {
            String string2 = "com.sybase.rsmplugin.resources.RAParamDescRes";
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string2);
            string = resourceBundle.getString(this.getName());
        }
        catch (MissingResourceException missingResourceException) {
            string = " ";
        }
        return string;
    }

    @Override
    public int getDatatype() {
        int n = this.getDetails();
        if (n == -1) {
            return 2;
        }
        return (Integer)_details[n][1];
    }

    protected int getDetails() {
        int n = 0;
        int n2 = _details.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            String string = (String)_details[n3][0];
            int n4 = this.getName().compareTo(string);
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 >= 0) continue;
            n2 = n3 - 1;
        }
        return -1;
    }
}

