/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repagent;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.ConfigPage;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.repagent.RepAgent;
import com.sybase.rsmplugin.components.repagent.RepAgentParameter;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RepAgentProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected RepAgent _repagent;
    protected BaseItem _item;
    protected List _paramList;

    public RepAgentProp(RepAgent repAgent, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(repAgent != null, "Null Rep Agent parameter.");
        this._repagent = repAgent;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(repAgent.getDomainName());
        try {
            this._paramList = semanticFactory.getRepAgentParameters(repAgent.getDS(), repAgent.getName());
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            this._paramList = new ArrayList();
        }
    }

    public RepAgent getRepAgent() {
        return this._repagent;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("RepAgentRes", "PROPERTIES_TITLE", this.getRepAgent().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new ConfigPage((BaseProperties)this, this._paramList)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            RepAgentParameter repAgentParameter = (RepAgentParameter)listIterator.next();
            if (repAgentParameter == null) continue;
            try {
                repAgentParameter.alter(this.getRepAgent().getDS(), this.getRepAgent().getName());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            return super.onOk();
        }
        return false;
    }

    @Override
    public void onApply() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            RepAgentParameter repAgentParameter = (RepAgentParameter)listIterator.next();
            if (repAgentParameter == null) continue;
            try {
                repAgentParameter.alter(this.getRepAgent().getDS(), this.getRepAgent().getName());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            super.onApply();
        }
    }
}

