/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repserver;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.EnvServerStatusSO;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSConnAttributes;
import com.sybase.rsmplugin.sql.RSConnection;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class DomainRepServer
extends EnvServerStatusSO
implements RepServer,
Comparable {
    private String _logName = null;
    private int _siteVersion;
    private int _systemVersion;
    private String _idServer = "";
    private int _siteID;
    private boolean _quiesced;
    private static final String HEALTH_NORMAL = "NORMAL";
    private static final String HEALTH_HIBERNATING = "HIBERNATING";
    private static final String HEALTH_REBUILDING = "REBUILDING";
    private static final String HEALTH_RECOVERY = "RECOVERY";
    private static final String HEALTH_STANDALONE = "STANDALONE";
    private static final String GET_LOG_FILE = "GET_LOG_FILE";
    private static final String GET_SITE_DATA = "GET_SITE_DATA";
    private static final String SET_SITE_VERSION = "SET_SITE_VERSION";
    private static final String SET_SYS_VERSION = "SET_SYS_VERSION";
    private static final String GET_HEALTH = "GET_HEALTH";
    private static final String SHUTDOWN = "SHUTDOWN";
    private static final String SUSPEND_ALL = "SUSPEND_ALL";
    private static final String RESUME_ALL = "RESUME_ALL";
    private static final String QUIESCE = "QUIESCE";
    private static final String CHECK_QUIESCE = "CHECK_QUIESCE";
    private static final String BACKUP_ERSSD = "BACKUP_ERSSD";
    private static final String HIBERNATE_ON = "HIBERNATE_ON";
    private static final String HIBERNATE_OFF = "HIBERNATE_OFF";
    private static final Object[][] contents = new Object[][]{{"GET_LOG_FILE", new Integer(1200), "admin log_name"}, {"GET_SITE_DATA", new Integer(1200), "rmp_site_data {0}"}, {"SET_SITE_VERSION", new Integer(1200), "sysadmin site_version, {0}"}, {"SET_SYS_VERSION", new Integer(1200), "sysadmin system_version, {0}"}, {"GET_HEALTH", new Integer(1200), "admin health"}, {"SHUTDOWN", new Integer(1200), "shutdown"}, {"SUSPEND_ALL", new Integer(1200), "suspend log transfer from all"}, {"RESUME_ALL", new Integer(1200), "resume log transfer from all"}, {"QUIESCE", new Integer(1200), "admin quiesce_force_rsi"}, {"CHECK_QUIESCE", new Integer(1200), "admin quiesce_check"}, {"BACKUP_ERSSD", new Integer(1260), "sysadmin erssd, backup"}, {"HIBERNATE_ON", new Integer(1260), "sysadmin hibernate_on"}, {"HIBERNATE_OFF", new Integer(1260), "sysadmin hibernate_off"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainRepServer(String string, EnvDomain envDomain) {
        super(string, envDomain);
        this.clearReasons();
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
        }
    }

    public int compareTo(Object object) {
        if (object instanceof DomainRepServer) {
            return this.getName().compareTo(((DomainRepServer)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-DomainRepServer object.");
        return -1;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    public static RepServer getRepServer(String string, EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        RepServer repServer = null;
        List list = DomainRepServer.getRepServers(envDomain);
        if (list != null) {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext() && repServer == null) {
                RepServer repServer2 = (RepServer)listIterator.next();
                if (!repServer2.getName().equals(string)) continue;
                repServer = repServer2;
            }
        }
        return repServer;
    }

    public static List getRepServers(EnvDomain envDomain) {
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        ArrayList<DomainRepServer> arrayList = new ArrayList<DomainRepServer>(1);
        ListIterator listIterator = envDomain.getRepServerNames().listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            DomainRepServer domainRepServer = new DomainRepServer(string, envDomain);
            arrayList.add(domainRepServer);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean monitor() {
        this.clearReasons();
        var1_1 = (RSConnection)this.getDomain().getConnection(this.getName());
        if (var1_1 != null) {
            try {
                var1_1.open();
            }
            catch (SQLException var2_2) {
                // empty catch block
            }
            switch (var1_1.getState()) {
                case 1: {
                    this.setState(5);
                    break;
                }
                case 3: {
                    this.setState(1);
                    break;
                }
                default: {
                    this.setState(0);
                }
            }
            var2_3 = var1_1.getReason();
            if (var2_3 != null && var2_3.length() > 0) {
                this.addReason((String)var2_3);
            }
            var1_1.unlock();
        } else {
            this.setState(3);
            this.addReason(BundleManager.getString("ProviderRes", "SRV_UNKNOWN"));
        }
        if (this.isUp()) {
            var2_3 = this.getDomain().getRSSD(this.getName());
            if (var2_3 != null) {
                try {
                    var2_3.open();
                    switch (var2_3.getState()) {
                        case 1: {
                            this.setState(5);
                            ** break;
lbl34:
                            // 1 sources

                        }
                        case 2: {
                            this.setState(0);
                            this.addReason(BundleManager.getString("ProviderRes", "SRV_RSSD_LOGIN_FAILED", this.getName()));
                            ** break;
lbl39:
                            // 1 sources

                        }
                        case 3: {
                            this.setState(1);
                            this.addReason(BundleManager.getString("ProviderRes", "SRV_RSSD_TIMEOUT", this.getName()));
                            ** break;
lbl44:
                            // 1 sources

                        }
                        default: {
                            this.setState(0);
                            this.addReason(BundleManager.getString("ProviderRes", "SRV_RSSD_CONN_FAILED", this.getName()));
                        }
                    }
                }
                catch (SQLException var3_5) {
                    PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(var3_5), MessageText.formatSQLExceptionDetails(var3_5));
                    this.setState(0);
                    this.addReason(var3_5.getLocalizedMessage());
                }
                finally {
                    var2_3.unlock();
                }
            } else {
                this.setState(3);
                this.addReason(BundleManager.getString("ProviderRes", "SRV_RSSD_UNKNOWN"));
            }
        }
        if (this.isUp() && (var2_3 = this.getDomain().getRSSD(this.getName())) != null) {
            try {
                if (!this.getDomain().isRSSDScriptInstalled((RSMConnection)var2_3)) {
                    this.setState(0);
                    this.addReason(BundleManager.getString("ProviderRes", "SRV_RSSD_SCRIPT_NOT_INSTALLED", this.getName()));
                }
            }
            catch (SQLException var3_6) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(var3_6), MessageText.formatSQLExceptionDetails(var3_6));
                this.setState(0);
                this.addReason(var3_6.getLocalizedMessage());
            }
            finally {
                var2_3.unlock();
            }
        }
        if (this.isUp()) {
            try {
                this.getRSHealth();
            }
            catch (SQLException var2_4) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(var2_4), MessageText.formatSQLExceptionDetails(var2_4));
                this.setState(0);
                this.addReason(var2_4.getLocalizedMessage());
            }
        }
        return this.isUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadProperties() throws SQLException {
        this.checkQuiesce();
        RSMConnection rSMConnection = this.getDomain().getRSSD(this.getName());
        if (rSMConnection != null) {
            int n = this.getDomain().getVersionNumber(this.getName());
            String string = _cmdBundle.getCommand(GET_SITE_DATA, n, this.getName());
            Dbg.wassert(string != null, "Unable to get load command, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    this._siteID = rSMResultSet.getColumnInt(1);
                    this._siteVersion = rSMResultSet.getColumnInt(2);
                    this._systemVersion = rSMResultSet.getColumnInt(3);
                    this._idServer = rSMResultSet.getColumnString(4);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
        super.loadProperties();
    }

    @Override
    public void alter(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, int n) throws SQLException {
        this.alter(string, string2, string3, string4, string5, string6, "Replication Server");
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (!(string == null || string.length() <= 0 || this.getUsername().equals(string) && this.getPassword().equals(string2) && this.getCharset().equals(string3) && this.getLanguage().equals(string4))) {
            RSConnAttributes rSConnAttributes = new RSConnAttributes();
            rSConnAttributes.setServer(this.getName());
            rSConnAttributes.setType("Replication Server");
            rSConnAttributes.setUser(string);
            rSConnAttributes.setPassword(string2);
            rSConnAttributes.setCharset(string3);
            rSConnAttributes.setLanguage(string4);
            if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
                rSConnAttributes.setHost(string5);
                rSConnAttributes.setPort(string6);
                rSConnAttributes.setSaveAddress(true);
            } else {
                rSConnAttributes.setHost("");
                rSConnAttributes.setPort("");
                rSConnAttributes.setSaveAddress(false);
            }
            RSConnection rSConnection = new RSConnection(rSConnAttributes);
            try {
                rSConnection.open();
            }
            finally {
                if (rSConnection != null) {
                    rSConnection.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateRSSDConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        if (!(string == null || string.length() <= 0 || this.getRSSDUsername().equals(string) && this.getRSSDPassword().equals(string2) && this.getRSSDCharset().equals(string3) && this.getRSSDLanguage().equals(string4))) {
            ConnAttributes connAttributes = new ConnAttributes();
            connAttributes.setServer(this.getRSSDServer());
            connAttributes.setType(this.isEmbeddedRSSD() ? "ASA" : "ASE");
            connAttributes.setUser(string);
            connAttributes.setPassword(string2);
            connAttributes.setCharset(string3);
            connAttributes.setLanguage(string4);
            if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
                connAttributes.setHost(string5);
                connAttributes.setPort(string6);
                connAttributes.setSaveAddress(true);
            } else {
                connAttributes.setHost("");
                connAttributes.setPort("");
                connAttributes.setSaveAddress(false);
            }
            RSMConnection rSMConnection = new RSMConnection(connAttributes);
            try {
                rSMConnection.open();
            }
            finally {
                if (rSMConnection != null) {
                    rSMConnection.close();
                }
            }
        }
    }

    @Override
    public void alter(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl, int n) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        RSConnAttributes rSConnAttributes = new RSConnAttributes();
        rSConnAttributes.setServer(this.getName());
        rSConnAttributes.setType("Replication Server");
        rSConnAttributes.setUser(string);
        rSConnAttributes.setPassword(string2);
        rSConnAttributes.setCharset(string3);
        rSConnAttributes.setLanguage(string4);
        if (string5 != null && string5.length() > 0 && string6 != null && string6.length() > 0) {
            rSConnAttributes.setHost(string5);
            rSConnAttributes.setPort(string6);
            rSConnAttributes.setSaveAddress(true);
        } else {
            rSConnAttributes.setHost("");
            rSConnAttributes.setPort("");
            rSConnAttributes.setSaveAddress(false);
        }
        ConnAttributes connAttributes = new ConnAttributes();
        connAttributes.setServer(this.getRSSDServer());
        connAttributes.setType(this.isEmbeddedRSSD() ? "ASA" : "ASE");
        connAttributes.setUser(string7);
        connAttributes.setPassword(string8);
        connAttributes.setCharset(string9);
        connAttributes.setLanguage(string10);
        if (string11 != null && string11.length() > 0 && string12 != null && string12.length() > 0) {
            connAttributes.setHost(string11);
            connAttributes.setPort(string12);
            connAttributes.setSaveAddress(true);
        } else {
            connAttributes.setHost("");
            connAttributes.setPort("");
            connAttributes.setSaveAddress(false);
        }
        rSConnAttributes.setRSSD(connAttributes);
        this.getDomain().alterServer(rSConnAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSiteVersion(String string) throws SQLException {
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            int n = rSConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(SET_SITE_VERSION, n, string);
            Dbg.wassert(string2 != null, "Unable to get update site version command, repserver version: " + n);
            try {
                rSConnection.execute(string2);
            }
            finally {
                rSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSystemVersion(String string) throws SQLException {
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            int n = rSConnection.getVersionNumber();
            String string2 = _cmdBundle.getCommand(SET_SYS_VERSION, n, string);
            Dbg.wassert(string2 != null, "Unable to get update system version command, repserver version: " + n);
            try {
                rSConnection.execute(string2);
            }
            finally {
                rSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws SQLException {
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            int n = rSConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(SHUTDOWN, n);
            Dbg.wassert(string != null, "Unable to get shutdown command, repserver version: " + n);
            try {
                rSConnection.execute(string);
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState() == null || !sQLException.getSQLState().equals("JZ006")) {
                    throw sQLException;
                }
                rSConnection.setState(0);
                this.setState(0);
                this.clearReasons();
            }
            finally {
                rSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public void quiesce(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getType();
            String string2 = this.getName();
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("RepServerRes", "QUIESCE_BKGND_TITLE"), this.getDomainName()){

                @Override
                public void run() {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    try {
                        this.setStatus(BundleManager.getString("RepServerRes", "QUIESCE_SUSPEND_ALL"));
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            DomainRepServer domainRepServer = (DomainRepServer)listIterator.next();
                            domainRepServer.suspendAll();
                            arrayList.add(domainRepServer.getName());
                        }
                        boolean bl = false;
                        boolean bl2 = false;
                        while (!1.interrupted() && !bl2) {
                            DomainRepServer domainRepServer;
                            Thread.sleep(2000L);
                            this.setStatus(BundleManager.getString("RepServerRes", "QUIESCE_SERVER_CMD"));
                            listIterator = list.listIterator();
                            while (!1.interrupted() && listIterator.hasNext()) {
                                domainRepServer = (DomainRepServer)listIterator.next();
                                domainRepServer.quiesce();
                            }
                            this.setStatus(BundleManager.getString("RepServerRes", "QUIESCE_CHECK_SERVER"));
                            bl2 = true;
                            listIterator = list.listIterator();
                            while (!1.interrupted() && listIterator.hasNext()) {
                                domainRepServer = (DomainRepServer)listIterator.next();
                                if (domainRepServer.checkQuiesce()) continue;
                                bl2 = false;
                            }
                            if (!bl2) {
                                bl = false;
                            }
                            if (!bl2 || bl) continue;
                            bl2 = false;
                            bl = true;
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!this.errorOccurred()) {
                        this.setStatus(BundleManager.getString("RepServerRes", "QUIESCE_LOG_MSG", CollectionUtility.toString(arrayList, ", ")));
                    }
                    DomainRepServer.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    @Override
    public void resumeAll(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getType();
            String string2 = this.getName();
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("RepServerRes", "RESUME_BKGND_TITLE"), this.getDomainName()){

                @Override
                public void run() {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    try {
                        this.setStatus(BundleManager.getString("RepServerRes", DomainRepServer.RESUME_ALL));
                        ListIterator listIterator = list.listIterator();
                        while (!2.interrupted() && listIterator.hasNext()) {
                            DomainRepServer domainRepServer = (DomainRepServer)listIterator.next();
                            domainRepServer.resumeAll();
                            arrayList.add(domainRepServer.getName());
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    if (!this.errorOccurred()) {
                        this.setStatus(BundleManager.getString("RepServerRes", "RESUME_ALL_LOG_MSG", CollectionUtility.toString(arrayList, ", ")));
                    }
                    DomainRepServer.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspendAll() throws SQLException {
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            int n = rSConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(SUSPEND_ALL, n);
            Dbg.wassert(string != null, "Unable to get suspend log transfer command, repserver version: " + n);
            try {
                rSConnection.execute(string);
            }
            finally {
                rSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumeAll() throws SQLException {
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            int n = rSConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(RESUME_ALL, n);
            Dbg.wassert(string != null, "Unable to get resume log transfer command, repserver version: " + n);
            try {
                rSConnection.execute(string);
            }
            finally {
                rSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quiesce() throws SQLException {
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            int n = rSConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(QUIESCE, n);
            Dbg.wassert(string != null, "Unable to get quiesce command, repserver version: " + n);
            try {
                rSConnection.execute(string);
            }
            finally {
                rSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHibernation(boolean bl) throws SQLException {
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            int n = rSConnection.getVersionNumber();
            String string = null;
            string = bl ? _cmdBundle.getCommand(HIBERNATE_ON, n) : _cmdBundle.getCommand(HIBERNATE_OFF, n);
            Dbg.wassert(string != null, "Unable to get hibernate command, repserver version: " + n);
            try {
                rSConnection.execute(string);
            }
            finally {
                rSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean checkQuiesce() throws SQLException {
        var1_1 = false;
        var2_2 = (RSConnection)this.getDomain().getConnection(this.getName());
        if (var2_2 != null) {
            if (var2_2.isConnectionOpen()) {
                var3_3 = var2_2.getVersionNumber();
                var4_4 = DomainRepServer._cmdBundle.getCommand("GET_HEALTH", var3_3);
                Dbg.wassert(var4_4 != null, "Unable to get admin health command, repserver version: " + var3_3);
                try {
                    var5_5 = new RSMResultSet(var2_2);
                    var5_5.open(var4_4);
                    if (!var5_5.getNextRow() || (var6_6 = var5_5.getColumnString(2)) == null || !(var6_6 = var6_6.trim()).equalsIgnoreCase("TRUE")) ** GOTO lbl20
                    var1_1 = true;
                }
                finally {
                    var2_2.unlock();
                }
            } else {
                var2_2.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
lbl20:
        // 3 sources

        this.setQuiesce(var1_1);
        return var1_1;
    }

    @Override
    public void upgradeRSSD(boolean bl) throws SQLException {
        this.getDomain().installRSSDScripts(this.getName(), bl);
    }

    @Override
    public void backupERSSD() {
        if (this.isEmbeddedRSSD()) {
            final String string = BundleManager.getString("RepServerRes", BACKUP_ERSSD, this.getName());
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("RepServerRes", "BACKUP_ERSSD_TITLE"), this.getDomainName()){

                @Override
                public void run() {
                    try {
                        this.setStatus(string);
                        DomainRepServer.this.backup();
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backup() throws SQLException {
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            int n = rSConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(BACKUP_ERSSD, n);
            Dbg.wassert(string != null, "Unable to get backup command, repserver version: " + n);
            try {
                rSConnection.execute(string);
            }
            finally {
                rSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        }
    }

    @Override
    public String getVersionString() {
        String string = "";
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getName());
        if (rSMConnection != null) {
            string = rSMConnection.getVersionString();
            rSMConnection.unlock();
        }
        return string;
    }

    @Override
    public int getVersionNumber() {
        return this.getDomain().getVersionNumber(this.getName());
    }

    @Override
    public String getRSSDServer() {
        String string = "";
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            string = rSConnection.getRSSDServer();
            rSConnection.unlock();
        }
        return string;
    }

    @Override
    public String getRSSDDatabase() {
        String string = "";
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            string = rSConnection.getRSSD();
            rSConnection.unlock();
        }
        return string;
    }

    @Override
    public boolean isEmbeddedRSSD() {
        boolean bl = false;
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection != null) {
            bl = rSConnection.isEmbeddedRSSD();
            rSConnection.unlock();
        }
        return bl;
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("RepServerRes", "ACTIVE_STATE");
                break;
            }
            case 10: {
                string = BundleManager.getString("RepServerRes", "QUIESCE_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("RepServerRes", "UNKNOWN_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("RepServerRes", "DOWN_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("RepServerRes", "TIMED_OUT_STATE");
                break;
            }
            case 4: {
                string = BundleManager.getString("RepServerRes", "SUSPECT_STATE");
                break;
            }
            case 6: {
                string = BundleManager.getString("RepServerRes", "HIBERNATE_STATE");
                break;
            }
            case 7: {
                string = BundleManager.getString("RepServerRes", "REBUILDING_STATE");
                break;
            }
            case 8: {
                string = BundleManager.getString("RepServerRes", "RECOVERY_STATE");
                break;
            }
            case 9: {
                string = BundleManager.getString("RepServerRes", "STANDALONE_STATE");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected Rep Server State");
                string = "";
            }
        }
        return string;
    }

    @Override
    public boolean isHibernating() {
        return this.getRSState() == 6;
    }

    @Override
    public boolean isQuiesce() {
        return this._quiesced;
    }

    public void setQuiesce(boolean bl) {
        this._quiesced = bl;
    }

    @Override
    public int getSiteID() {
        return this._siteID;
    }

    @Override
    public int getSiteVersion() {
        return this._siteVersion;
    }

    @Override
    public int getSystemVersion() {
        return this._systemVersion;
    }

    @Override
    public String getIDServer() {
        return this._idServer;
    }

    @Override
    public boolean isIDServer() {
        return this.getIDServer().equals(this.getName());
    }

    @Override
    public String getRSSDUsername() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRSSDServer(this.getName());
        if (connAttributes != null) {
            string = connAttributes.getUser();
        }
        return string;
    }

    @Override
    public String getRSSDPassword() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRSSDServer(this.getName());
        if (connAttributes != null) {
            string = connAttributes.getPassword();
        }
        return string;
    }

    @Override
    public String getRSSDCharset() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRSSDServer(this.getName());
        if (connAttributes != null) {
            string = connAttributes.getCharset();
        }
        return string;
    }

    @Override
    public String getRSSDLanguage() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRSSDServer(this.getName());
        if (connAttributes != null) {
            string = connAttributes.getLanguage();
        }
        return string;
    }

    public String getRSSDHost() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRSSDServer(this.getName());
        if (connAttributes != null && (string = connAttributes.getHost()) == null) {
            string = "";
        }
        return string;
    }

    public String getRSSDPort() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRSSDServer(this.getName());
        if (connAttributes != null && (string = connAttributes.getPort()) == null) {
            string = "";
        }
        return string;
    }

    public boolean isRSSDAddressSavedLocally() {
        boolean bl = false;
        ConnAttributes connAttributes = this.getDomain().getRSSDServer(this.getName());
        if (connAttributes != null) {
            bl = connAttributes.isAddressSavedLocally();
        }
        return bl;
    }

    @Override
    public boolean isUp() {
        return this.getRSState() == 5 || this.getRSState() == 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getRSHealth() throws SQLException {
        RSConnection rSConnection = (RSConnection)this.getDomain().getConnection(this.getName());
        if (rSConnection == null) throw new SQLException(BundleManager.getString("RepServerRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
        int n = rSConnection.getVersionNumber();
        String string = _cmdBundle.getCommand(GET_HEALTH, n);
        Dbg.wassert(string != null, "Unable to get rs health command, repserver version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rSConnection);
        try {
            String string2;
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow()) return;
            String string3 = rSMResultSet.getColumnString(1);
            if (string3 != null) {
                if ((string3 = string3.trim()).equalsIgnoreCase(HEALTH_NORMAL)) {
                    this.setState(5);
                } else if (string3.equalsIgnoreCase(HEALTH_HIBERNATING)) {
                    this.setState(6);
                    this.addReason(BundleManager.getString("RepServerRes", "SRV_HIBERNATE_DESC"));
                } else if (string3.equalsIgnoreCase(HEALTH_REBUILDING)) {
                    this.setState(7);
                    this.addReason(BundleManager.getString("RepServerRes", "SRV_REBUILDING_DESC"));
                } else if (string3.equalsIgnoreCase(HEALTH_RECOVERY)) {
                    this.setState(8);
                    this.addReason(BundleManager.getString("RepServerRes", "SRV_RECOVERY_DESC"));
                } else if (string3.equalsIgnoreCase(HEALTH_STANDALONE)) {
                    this.setState(9);
                    this.addReason(BundleManager.getString("RepServerRes", "SRV_STANDALONE_DESC"));
                }
            }
            if ((string2 = rSMResultSet.getColumnString(2)) == null || !(string2 = string2.trim()).equalsIgnoreCase("TRUE") || this.getRSState() != 5) return;
            this.setState(10);
            return;
        }
        finally {
            rSMResultSet.close();
            rSConnection.unlock();
        }
    }
}

