/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repserver;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.RMSServerStatusSO;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class RMSRepServer
extends RMSServerStatusSO
implements RepServer,
Comparable {
    String _lastMonitored = null;
    String _monitoredBy = null;
    String _versionString = null;
    protected static final String RSSD_USERNAME_PARAM = "rssd_username";
    protected static final String RSSD_CHARSET_PARAM = "rssd_charset";
    protected static final String RSSD_LANGUAGE_PARAM = "rssd_language";
    protected static final String RSSD_PASSWORD_PARAM = "rssd_password";
    protected String _rssdUsername = null;
    protected String _rssdCharset = null;
    protected String _rssdLanguage = null;
    private static final String GET_REP_SERVER = "GET_REP_SERVER";
    private static final String GET_REP_SERVERS = "GET_REP_SERVERS";
    private static final Object[][] contents = new Object[][]{{"GET_REP_SERVER", new Integer(1500), "get servers {0}"}, {"GET_REP_SERVERS", new Integer(1500), "get servers Replication Server"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSRepServer(String string, RMSDomain rMSDomain) {
        super(string, rMSDomain);
        this.setState(3);
        this.clearReasons();
    }

    public int compareTo(Object object) {
        if (object instanceof RMSRepServer) {
            return this.getName().compareTo(((RMSRepServer)object).getName());
        }
        Dbg.wassert(false, "CompareTo is comparing a non-RMSRepServer object.");
        return -1;
    }

    @Override
    public String getServerType() {
        return "Replication Server";
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "Replication Server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepServer getRepServer(String string, RMSDomain rMSDomain) {
        Dbg.wassert(rMSDomain != null, "Null domain connection parameter.");
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        RMSRepServer rMSRepServer = null;
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_REP_SERVER, n, string);
            Dbg.wassert(string2 != null, "Unable to get server command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                if (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    if (string3 != null && string3.equals(string) && string4 != null && string4.equalsIgnoreCase("Replication Server")) {
                        rMSRepServer = new RMSRepServer(string, rMSDomain);
                        rMSRepServer._lastMonitored = rSMResultSet.getColumnString(3);
                        rMSRepServer._versionString = rSMResultSet.getColumnString(4);
                        rMSRepServer.setState(rSMResultSet.getColumnInt(5));
                        String string5 = rSMResultSet.getColumnString(7);
                        if (string5 != null && string5.length() > 0) {
                            rMSRepServer.addReason(string5);
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return rMSRepServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRepServers(RMSDomain rMSDomain) {
        Dbg.wassert(rMSDomain != null, "Null domain connection parameter.");
        ArrayList<RMSRepServer> arrayList = new ArrayList<RMSRepServer>(1);
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_REP_SERVERS, n);
            Dbg.wassert(string != null, "Unable to get rep server command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    RMSRepServer rMSRepServer = new RMSRepServer(string2, rMSDomain);
                    String string3 = rSMResultSet.getColumnString(2);
                    if (!string3.equalsIgnoreCase(rMSRepServer.getRMSType())) continue;
                    rMSRepServer._lastMonitored = rSMResultSet.getColumnString(3);
                    rMSRepServer._versionString = rSMResultSet.getColumnString(4);
                    rMSRepServer.setState(rSMResultSet.getColumnInt(5));
                    String string4 = rSMResultSet.getColumnString(7);
                    if (string4 != null && string4.length() > 0) {
                        rMSRepServer.addReason(string4);
                    }
                    arrayList.add(rMSRepServer);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public void drop() {
        this.getDomain().deleteServer(this.getName());
    }

    public void validateRSConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
    }

    @Override
    public void validateRSSDConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
    }

    @Override
    public void alter(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl, int n) throws SQLException {
        String string13;
        this.alter(string, string2, string3, string4, string5, string6, bl, n);
        if (!this.getRSSDUsername().equals(string7)) {
            this.setRMSConfigParameter(RSSD_USERNAME_PARAM, string7);
        }
        if (!this.getRSSDPassword().equals(string8)) {
            this.setRMSConfigParameter(RSSD_PASSWORD_PARAM, string8);
        }
        if (!this.getRSSDCharset().equals(string9)) {
            string13 = string9.trim().length() == 0 ? "default" : string9;
            this.setRMSConfigParameter(RSSD_CHARSET_PARAM, string13);
        }
        if (!this.getRSSDLanguage().equals(string10)) {
            string13 = string10.trim().length() == 0 ? "default" : string10;
            this.setRMSConfigParameter(RSSD_LANGUAGE_PARAM, string13);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadProperties() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getDomain().getRMSVersionNumber();
            String string = RMSServerStatusSO._cmdBundle.getCommand("GET_RMS_CONFIG_PARAMS", n, this.getName());
            Dbg.wassert(string != null, "Unable to get RMS parameter command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    if (string2.equalsIgnoreCase("username")) {
                        this._username = rSMResultSet.getColumnString(3);
                    } else if (string2.equalsIgnoreCase("charset")) {
                        this._charset = rSMResultSet.getColumnString(3);
                    } else if (string2.equalsIgnoreCase("language")) {
                        this._language = rSMResultSet.getColumnString(3);
                    }
                    if (string2.equalsIgnoreCase(RSSD_USERNAME_PARAM)) {
                        this._rssdUsername = rSMResultSet.getColumnString(3);
                        continue;
                    }
                    if (string2.equalsIgnoreCase(RSSD_CHARSET_PARAM)) {
                        this._rssdCharset = rSMResultSet.getColumnString(3);
                        this._rssdCharset = this._rssdCharset.equalsIgnoreCase("default") ? "" : this._rssdCharset;
                        continue;
                    }
                    if (string2.equalsIgnoreCase(RSSD_LANGUAGE_PARAM)) {
                        this._rssdLanguage = rSMResultSet.getColumnString(3);
                        this._rssdLanguage = this._rssdLanguage.equalsIgnoreCase("default") ? "" : this._rssdLanguage;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("monitoring")) {
                        this._monitoring = rSMResultSet.getColumnBool(3);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("interval")) continue;
                    this._interval = rSMResultSet.getColumnInt(3);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        super.loadProperties();
    }

    @Override
    public void updateSiteVersion(String string) throws SQLException {
    }

    @Override
    public void updateSystemVersion(String string) throws SQLException {
    }

    @Override
    public void quiesce(List list) {
    }

    @Override
    public void setHibernation(boolean bl) throws SQLException {
    }

    @Override
    public void resumeAll(List list) {
    }

    @Override
    public void upgradeRSSD(boolean bl) throws SQLException {
    }

    @Override
    public void backupERSSD() {
    }

    protected void backup() throws SQLException {
    }

    @Override
    public String getVersionString() {
        return this._versionString != null ? this._versionString : "";
    }

    @Override
    public int getVersionNumber() {
        StringTokenizer stringTokenizer;
        if (this._versionString != null && this._versionString.length() > 0 && (stringTokenizer = new StringTokenizer(this._versionString, "/")).countTokens() >= 2) {
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            return MessageText.toVersionNr(string2, 4);
        }
        return 0;
    }

    @Override
    public String getLastMonitoredDate() {
        return this._lastMonitored != null ? this._lastMonitored : "";
    }

    @Override
    public String getRSSDServer() {
        return "";
    }

    @Override
    public String getRSSDDatabase() {
        return "";
    }

    @Override
    public boolean isEmbeddedRSSD() {
        boolean bl = false;
        return bl;
    }

    @Override
    public String getStateString() {
        String string;
        switch (this.getRSState()) {
            case 5: {
                string = BundleManager.getString("RepServerRes", "ACTIVE_STATE");
                break;
            }
            case 10: {
                string = BundleManager.getString("RepServerRes", "QUIESCE_STATE");
                break;
            }
            case 3: {
                string = BundleManager.getString("RepServerRes", "UNKNOWN_STATE");
                break;
            }
            case 0: {
                string = BundleManager.getString("RepServerRes", "DOWN_STATE");
                break;
            }
            case 1: {
                string = BundleManager.getString("RepServerRes", "TIMED_OUT_STATE");
                break;
            }
            case 4: {
                string = BundleManager.getString("RepServerRes", "SUSPECT_STATE");
                break;
            }
            case 6: {
                string = BundleManager.getString("RepServerRes", "HIBERNATE_STATE");
                break;
            }
            case 7: {
                string = BundleManager.getString("RepServerRes", "REBUILDING_STATE");
                break;
            }
            case 8: {
                string = BundleManager.getString("RepServerRes", "RECOVERY_STATE");
                break;
            }
            case 9: {
                string = BundleManager.getString("RepServerRes", "STANDALONE_STATE");
                break;
            }
            default: {
                Dbg.wassert(false, "Unexpected Rep Server State");
                string = "";
            }
        }
        return string;
    }

    @Override
    public boolean isQuiesce() {
        return this.getRSState() == 10;
    }

    @Override
    public boolean isHibernating() {
        return this.getRSState() == 6;
    }

    @Override
    public int getSiteID() {
        return 0;
    }

    @Override
    public int getSiteVersion() {
        return 0;
    }

    @Override
    public int getSystemVersion() {
        return 0;
    }

    @Override
    public String getIDServer() {
        return "";
    }

    @Override
    public boolean isIDServer() {
        return false;
    }

    @Override
    public String getRSSDUsername() {
        return this._rssdUsername == null ? "" : this._rssdUsername;
    }

    @Override
    public String getRSSDPassword() {
        return "        ";
    }

    @Override
    public String getRSSDCharset() {
        return this._rssdCharset == null ? "" : this._rssdCharset;
    }

    @Override
    public String getRSSDLanguage() {
        return this._rssdLanguage == null ? "" : this._rssdLanguage;
    }

    @Override
    public boolean isUp() {
        return this.getRSState() == 5 || this.getRSState() == 10;
    }
}

