/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repserver;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.repserver.RepServerParameter;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RMSRepServerParameter
extends RepServerParameter {
    private RMSDomain _domain = null;
    private static final String GET_PARAMS = "GET_PARAMS";
    private static final String SET_PARAM = "SET_PARAM";
    private static final Object[][] contents = new Object[][]{{"GET_PARAMS", new Integer(1500), "configure server {0}"}, {"SET_PARAM", new Integer(1500), "configure server {0} {1}={2}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSRepServerParameter(String string, String string2, String string3, RMSDomain rMSDomain) {
        super(string, string2, string3);
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        this._domain = rMSDomain;
    }

    public RMSDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRepServerParameters(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        int n = rMSDomain.getRMSVersionNumber();
        String string2 = _cmdBundle.getCommand(GET_PARAMS, n, string);
        Dbg.wassert(string2 != null, "Unable to get parameter query command, RMS version: " + n);
        ArrayList<RMSRepServerParameter> arrayList = new ArrayList<RMSRepServerParameter>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(3);
                    String string5 = rSMResultSet.getColumnString(4);
                    RMSRepServerParameter rMSRepServerParameter = new RMSRepServerParameter(string3, string4, string5, rMSDomain);
                    arrayList.add(rMSRepServerParameter);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(this._domain != null, "Null domain connnection parameter.");
        if (this.isModified()) {
            int n = this.getDomain().getRMSVersionNumber();
            Object[] objectArray = new String[]{string, this.getName(), this.getPendingValue()};
            String string2 = _cmdBundle.getCommand(SET_PARAM, n, objectArray);
            Dbg.wassert(string2 != null, "Unable to get set parameter command, RMS version: " + n);
            RMSConnection rMSConnection = this.getDomain().getRMSConnection();
            if (rMSConnection != null) {
                RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
                try {
                    rSMResultSet.open(string2);
                    this.resetOriginalPendingValue();
                }
                finally {
                    rSMResultSet.close();
                    rMSConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
            }
        }
    }
}

