/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repserver;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCViewerDetailsPanel2;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.ServerComponent;
import com.sybase.rsmplugin.components.connection.PhyConnectionFolder;
import com.sybase.rsmplugin.components.events.EventDetailContainer;
import com.sybase.rsmplugin.components.logical.LogicalConnectionFolder;
import com.sybase.rsmplugin.components.queue.QueueFolder;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.repserver.RepServerProp;
import com.sybase.rsmplugin.components.route.RouteFolder;
import com.sybase.rsmplugin.components.rsthread.RSThreadFolder;
import com.sybase.rsmplugin.components.rsuser.RSUserFolder;
import com.sybase.rsmplugin.routeupgrade.RouteUpgradeDlg;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CheckBoxMessage;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import com.sybase.rsmplugin.util.RCLEditor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class RepServerContainer
extends BaseContainer
implements RMContainer,
ServerComponent,
StatusItem {
    private static final String CLASS_ID = "repserver.RepServerContainer";
    private static final int CMD_RCL_EDITOR = 3008;
    public static final int CMD_QUIESCE = 3009;
    public static final int CMD_RESUME_ALL = 3010;
    public static final int CMD_UPGRADE_ROUTES = 3011;
    public static final int CMD_UPGRADE_RM = 3012;
    public static final int CMD_BACKUP_RSSD = 3013;
    private RepServer _so;
    private static ImageIcon _iconUp = null;
    private static ImageIcon _iconDown = null;
    private static ImageIcon _iconSuspect = null;

    public RepServerContainer(RepServer repServer, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(repServer != null, "Null Rep Server Semantic object parameter.");
        this._so = repServer;
        StatusManager.addStatusItem(this);
    }

    public RepServerContainer(RepServer repServer) {
        Dbg.wassert(repServer != null, "Null Rep Server Semantic object parameter.");
        this._so = repServer;
        StatusManager.addStatusItem(this);
    }

    public RepServer getRepServer() {
        return this._so;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getRepServerUp());
        }
        return _iconUp;
    }

    @Override
    public void drop() {
        this.getRepServer().drop();
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getRepServer().isUp()) {
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getRepServerUp());
            }
            return _iconUp;
        }
        if (this.getRepServer().isError()) {
            if (_iconDown == null) {
                _iconDown = new ImageIcon(RSMImages.getRepServerDown());
            }
            return _iconDown;
        }
        if (_iconSuspect == null) {
            _iconSuspect = new ImageIcon(RSMImages.getRepServerSuspect());
        }
        return _iconSuspect;
    }

    @Override
    public int getAttributes() {
        if (!this.getRepServer().isError()) {
            return 1;
        }
        return super.getAttributes();
    }

    @Override
    public String getDisplayName(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = this.getName();
                break;
            }
            case 1: {
                string = this.getRepServer().getStateString();
                break;
            }
            case 2: {
                string = this._so.getReason();
                break;
            }
        }
        return string;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        if (this.getRepServer().isError()) {
            return 32;
        }
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106 || n == 3009 || n == 3010;
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu = new DefaultSCMenu();
        if (this.getRepServer().isError()) {
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        } else {
            MenuItem menuItem;
            char c;
            String string;
            String string2;
            if (!this.getRepServer().isControlledByRSMS()) {
                string2 = BundleManager.getString("RepServerRes", "MENU_RCL_EDITOR");
                string = BundleManager.getString("RepServerRes", "MENU_HINT_RCL_EDITOR");
                c = BundleManager.getMnemonic("RepServerRes", "MENU_MNEM_RCL_EDITOR");
                menuItem = new MenuItem(3008, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
                string2 = BundleManager.getString("RepServerRes", "MENU_QUIESCE");
                string = BundleManager.getString("RepServerRes", "MENU_HINT_QUIESCE");
                c = BundleManager.getMnemonic("RepServerRes", "MENU_MNEM_QUIESCE");
                menuItem = new MenuItem(3009, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                string2 = BundleManager.getString("RepServerRes", "MENU_RESUME_ALL");
                string = BundleManager.getString("RepServerRes", "MENU_HINT_RESUME_ALL");
                c = BundleManager.getMnemonic("RepServerRes", "MENU_MNEM_RESUME_ALL");
                menuItem = new MenuItem(3010, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                string2 = BundleManager.getString("RepServerRes", "MENU_UPGRADE_ROUTES");
                string = BundleManager.getString("RepServerRes", "MENU_HINT_UPGRADE_ROUTES");
                c = BundleManager.getMnemonic("RepServerRes", "MENU_MNEM_UPGRADE_ROUTES");
                menuItem = new MenuItem(3011, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                string2 = BundleManager.getString("RepServerRes", "MENU_UPGRADE_RM");
                string = BundleManager.getString("RepServerRes", "MENU_HINT_UPGRADE_RM");
                c = BundleManager.getMnemonic("RepServerRes", "MENU_MNEM_UPGRADE_RM");
                menuItem = new MenuItem(3012, string2, string, c);
                defaultSCMenu.addItem((SCMenuItem)menuItem);
                string2 = BundleManager.getString("RepServerRes", "MENU_BACKUP_RSSD");
                string = BundleManager.getString("RepServerRes", "MENU_HINT_BACKUP_RSSD");
                c = BundleManager.getMnemonic("RepServerRes", "MENU_MNEM_BACKUP_RSSD");
                menuItem = new MenuItem(3013, string2, string, c);
                menuItem.setEnabled(this.getRepServer().isEmbeddedRSSD());
                defaultSCMenu.addItem((SCMenuItem)menuItem);
            }
            string2 = BundleManager.getString("RepServerRes", "MENU_SHUTDOWN");
            string = BundleManager.getString("RepServerRes", "MENU_HINT_SHUTDOWN");
            c = BundleManager.getMnemonic("RepServerRes", "MENU_MNEM_SHUTDOWN");
            menuItem = new MenuItem(3005, string2, string, c);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        }
        return defaultSCMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof ServerComponent)) continue;
                    ((ServerComponent)((Object)baseItem)).drop();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 3008: {
                RCLEditor.open("");
                break;
            }
            case 3009: {
                if (!PluginSupport.askQuestion(BundleManager.getString("RepServerRes", "MSG_QUIESCE"), false)) break;
                ArrayList<RepServer> arrayList = new ArrayList<RepServer>();
                while (enumeration.hasMoreElements()) {
                    RepServer repServer;
                    Object e = enumeration.nextElement();
                    if (e == null || !(e instanceof RepServerContainer) || (repServer = ((RepServerContainer)e).getRepServer()) == null) continue;
                    arrayList.add(repServer);
                }
                this.getRepServer().quiesce(arrayList);
                break;
            }
            case 3010: {
                if (!PluginSupport.askQuestion(BundleManager.getString("RepServerRes", "MSG_RESUME_ALL"), false)) break;
                ArrayList<RepServer> arrayList = new ArrayList<RepServer>();
                while (enumeration.hasMoreElements()) {
                    RepServer repServer;
                    Object e = enumeration.nextElement();
                    if (e == null || !(e instanceof RepServerContainer) || (repServer = ((RepServerContainer)e).getRepServer()) == null) continue;
                    arrayList.add(repServer);
                }
                this.getRepServer().resumeAll(arrayList);
                break;
            }
            case 3011: {
                BaseController baseController = PluginSupport.getDialog(RouteUpgradeDlg.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                RouteUpgradeDlg routeUpgradeDlg = new RouteUpgradeDlg(sCDialogSupport2, this.getRepServer());
                routeUpgradeDlg.showDialog();
                break;
            }
            case 3012: {
                Boolean bl = CheckBoxMessage.showInputDialog(BundleManager.getString("RepServerRes", "UPDATE_PROCEDURE_DESC"), BundleManager.getString("RepServerRes", "FORCE_UPDATE_PROCEDURE"), false);
                if (bl == null) break;
                PluginSupport.getViewerSupport().startWait();
                try {
                    this.getRepServer().upgradeRSSD(bl);
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 3013: {
                Dbg.wassert(this.getRepServer().isEmbeddedRSSD(), "Attempting backup on non-embedded RSSD");
                if (!PluginSupport.askQuestion(BundleManager.getString("RepServerRes", "MSG_BACKUP_ERSSD", this.getRepServer().getName()), false)) break;
                this.getRepServer().backupERSSD();
                break;
            }
            case 3005: {
                String string = BundleManager.getString("RepServerRes", "CONFIRM_SHUTDOWN", this.getName());
                if (!PluginSupport.askQuestion(string, false)) break;
                PluginSupport.getViewerSupport().startWait();
                try {
                    this.getRepServer().shutdown();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                StatusManager.refresh(this.getDomainName(), this.getType(), this.getName());
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 107: {
                BaseController baseController = PluginSupport.getDialog(RepServerProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                RepServerProp repServerProp = new RepServerProp(this.getRepServer(), this, sCDialogSupport2);
                repServerProp.showDialog();
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            if (!this.getRepServer().isError()) {
                this.addItem((SCItem)new PhyConnectionFolder(this.getRepServer().getDomainName(), this));
                this.addItem((SCItem)new LogicalConnectionFolder(this.getRepServer().getDomainName(), this));
                this.addItem((SCItem)new RouteFolder(this.getRepServer().getDomainName(), this));
                this.addItem((SCItem)new QueueFolder(this.getRepServer().getDomainName(), this));
                this.addItem((SCItem)new RSThreadFolder(this.getRepServer().getDomainName(), this));
                if (!this.getRepServer().isControlledByRSMS()) {
                    this.addItem((SCItem)new RSUserFolder(this.getRepServer().getDomainName(), this));
                }
            }
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("DomainRes", "COL_HEADER_FOLDERS")};
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    @Override
    public void setState(int n) {
        this.getRepServer().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getRepServer().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getRepServer().getDomainName();
    }

    @Override
    public String getType() {
        return this.getRepServer().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getDisplayName(1);
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public Object[] getDetailsPanels(JFrame jFrame) {
        String string = this.getParent().getName();
        if (this.getRepServer().isControlledByRSMS()) {
            SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
            SCViewerDetailsPanel2 sCViewerDetailsPanel22 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", (SCDetailsContainer)new EventDetailContainer(BundleManager.getString("EventsRes", "EVENT_TAB"), string, this.getName(), this));
            sCViewerDetailsPanel22.setPanelName(sCViewerDetailsPanel22.getSCDetailsContainer().getDisplayName());
            Object[] objectArray = new Object[]{sCViewerDetailsPanel2, sCViewerDetailsPanel22};
            return objectArray;
        }
        SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
        Object[] objectArray = new Object[]{sCViewerDetailsPanel2};
        return objectArray;
    }
}

