/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.repserver;

import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.ConfigPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.repserver.DomainRepServer;
import com.sybase.rsmplugin.components.repserver.RMSRepServer;
import com.sybase.rsmplugin.components.repserver.RSPropGeneralPanel;
import com.sybase.rsmplugin.components.repserver.RSPropUserPanel;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.repserver.RepServerParameter;
import com.sybase.rsmplugin.sql.RSConnection;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RepServerProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected RepServer _repserver;
    protected BaseItem _item;
    protected List _paramList;
    protected String _user = null;
    protected String _pwd;
    protected String _charset;
    protected String _lang;
    protected String _host;
    protected String _port;
    protected String _rssdUser;
    protected String _rssdPwd;
    protected String _rssdCharset;
    protected String _rssdLang;
    protected String _rssdHost;
    protected String _rssdPort;
    protected boolean _monitor;
    protected int _interval;

    RepServerProp(RepServer repServer, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(repServer != null, "Null RepServer parameter.");
        this._repserver = repServer;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(repServer.getDomainName());
        try {
            this._repserver.loadProperties();
            this._paramList = semanticFactory.getRepServerParameters(repServer.getName());
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            this._paramList = new ArrayList();
        }
    }

    RepServer getRepServer() {
        return this._repserver;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("RepServerRes", "PROPERTIES_TITLE", this.getRepServer().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new CommPage(this), new ConfigPage((BaseProperties)this, this._paramList)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            RepServerParameter repServerParameter = (RepServerParameter)listIterator.next();
            if (repServerParameter == null) continue;
            try {
                repServerParameter.alter(this.getRepServer().getName());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (this._user != null) {
            try {
                this.getRepServer().alter(this._user, this._pwd, this._charset, this._lang, this._host, this._port, this._rssdUser, this._rssdPwd, this._rssdCharset, this._rssdLang, this._rssdHost, this._rssdPort, this._monitor, this._interval);
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            return super.onOk();
        }
        return false;
    }

    @Override
    public void onApply() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            RepServerParameter repServerParameter = (RepServerParameter)listIterator.next();
            if (repServerParameter == null) continue;
            try {
                repServerParameter.alter(this.getRepServer().getName());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (this._user != null) {
            try {
                this.getRepServer().alter(this._user, this._pwd, this._charset, this._lang, this._host, this._port, this._rssdUser, this._rssdPwd, this._rssdCharset, this._rssdLang, this._rssdHost, this._rssdPort, this._monitor, this._interval);
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            super.onApply();
        }
    }

    class CommPage
    extends BasePropertyPage
    implements ActionListener,
    DocumentListener,
    ASASpinBoxChangeListener {
        private RSPropUserPanel _goPage;

        public CommPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("ConnectionRes", "COMM_PAGE_TAG"));
            this._goPage = new RSPropUserPanel();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_username.setText(RepServerProp.this.getRepServer().getUsername());
            this._goPage.fld_password.setText("        ");
            this._goPage.cbx_charset.setSelection(RepServerProp.this.getRepServer().getCharset());
            this._goPage.cbx_language.setSelection(RepServerProp.this.getRepServer().getLanguage());
            this._goPage.fld_rssdUsername.setText(RepServerProp.this.getRepServer().getRSSDUsername());
            this._goPage.fld_rssdPassword.setText("        ");
            this._goPage.cbx_rssdCharset.setSelection(RepServerProp.this.getRepServer().getRSSDCharset());
            this._goPage.cbx_rssdLanguage.setSelection(RepServerProp.this.getRepServer().getRSSDLanguage());
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_rssdUsername.getDocument().addDocumentListener(this);
            this._goPage.fld_rssdPassword.getDocument().addDocumentListener(this);
            this._goPage.cbx_charset.addActionListener(this);
            this._goPage.cbx_language.addActionListener(this);
            this._goPage.cbx_rssdCharset.addActionListener(this);
            this._goPage.cbx_rssdLanguage.addActionListener(this);
            if (RepServerProp.this.getRepServer().isControlledByRSMS()) {
                this._goPage.lbl_host.setVisible(false);
                this._goPage.fld_host.setVisible(false);
                this._goPage.lbl_port.setVisible(false);
                this._goPage.fld_port.setVisible(false);
                this._goPage.lbl_rssdhost.setVisible(false);
                this._goPage.fld_rssdhost.setVisible(false);
                this._goPage.lbl_rssdport.setVisible(false);
                this._goPage.fld_rssdport.setVisible(false);
                this._goPage.chk_monitor.setSelected(((RMSRepServer)RepServerProp.this.getRepServer()).isMonitoringEnabled());
                this._goPage.spn_interval.setValue(((RMSRepServer)RepServerProp.this.getRepServer()).getMonitoringInterval());
                this._goPage.lbl_date.setText(BundleManager.getString("RepServerRes", "LAST_MONITOR_DATE", ((RMSRepServer)RepServerProp.this.getRepServer()).getLastMonitoredDate()));
                this._goPage.chk_monitor.addActionListener((ActionListener)this);
                this._goPage.spn_interval.addSpinBoxChangeListener((ASASpinBoxChangeListener)this);
            } else {
                this._goPage.chk_monitor.setVisible(false);
                this._goPage.lbl_interval.setVisible(false);
                this._goPage.spn_interval.setVisible(false);
                this._goPage.lbl_units.setVisible(false);
                this._goPage.lbl_date.setVisible(false);
                if (((DomainRepServer)RepServerProp.this.getRepServer()).isAddressSavedLocally()) {
                    this._goPage.fld_host.setText(((DomainRepServer)RepServerProp.this.getRepServer()).getHost());
                    this._goPage.fld_port.setText(((DomainRepServer)RepServerProp.this.getRepServer()).getPort());
                }
                if (((DomainRepServer)RepServerProp.this.getRepServer()).isRSSDAddressSavedLocally()) {
                    this._goPage.fld_rssdhost.setText(((DomainRepServer)RepServerProp.this.getRepServer()).getRSSDHost());
                    this._goPage.fld_rssdport.setText(((DomainRepServer)RepServerProp.this.getRepServer()).getRSSDPort());
                }
                this._goPage.fld_host.getDocument().addDocumentListener(this);
                this._goPage.fld_port.getDocument().addDocumentListener(this);
                this._goPage.fld_rssdhost.getDocument().addDocumentListener(this);
                this._goPage.fld_rssdport.getDocument().addDocumentListener(this);
            }
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                RepServerProp.this._user = this._goPage.fld_username.getText();
                RepServerProp.this._user = RepServerProp.this._user.trim();
                RepServerProp.this._pwd = this._goPage.fld_password.getPasswordString();
                if (RepServerProp.this._pwd.equals("        ")) {
                    RepServerProp.this._pwd = RepServerProp.this.getRepServer().getPassword();
                }
                RepServerProp.this._charset = this._goPage.cbx_charset.getSelection();
                RepServerProp.this._charset = RepServerProp.this._charset.trim();
                if (RepServerProp.this._charset.equals("default")) {
                    RepServerProp.this._charset = "";
                }
                RepServerProp.this._lang = this._goPage.cbx_language.getSelection();
                RepServerProp.this._lang = RepServerProp.this._lang.trim();
                if (RepServerProp.this._lang.equals("default")) {
                    RepServerProp.this._lang = "";
                }
                RepServerProp.this._host = this._goPage.fld_host.getText();
                RepServerProp.this._host = RepServerProp.this._host.trim();
                RepServerProp.this._port = this._goPage.fld_port.getText();
                RepServerProp.this._port = RepServerProp.this._port.trim();
                try {
                    RepServerProp.this.getRepServer().validateConnection(RepServerProp.this._user, RepServerProp.this._pwd, RepServerProp.this._charset, RepServerProp.this._lang, RepServerProp.this._host, RepServerProp.this._port);
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    return false;
                }
                RepServerProp.this._rssdUser = this._goPage.fld_rssdUsername.getText();
                RepServerProp.this._rssdPwd = this._goPage.fld_rssdPassword.getPasswordString();
                if (RepServerProp.this._rssdPwd.equals("        ")) {
                    RepServerProp.this._rssdPwd = RepServerProp.this.getRepServer().getRSSDPassword();
                }
                RepServerProp.this._rssdCharset = this._goPage.cbx_rssdCharset.getSelection();
                RepServerProp.this._rssdCharset = RepServerProp.this._rssdCharset.trim();
                if (RepServerProp.this._rssdCharset.equals("default")) {
                    RepServerProp.this._rssdCharset = "";
                }
                RepServerProp.this._rssdLang = this._goPage.cbx_rssdLanguage.getSelection();
                RepServerProp.this._rssdLang = RepServerProp.this._rssdLang.trim();
                if (RepServerProp.this._rssdLang.equals("default")) {
                    RepServerProp.this._rssdLang = "";
                }
                RepServerProp.this._rssdHost = this._goPage.fld_rssdhost.getText();
                RepServerProp.this._rssdHost = RepServerProp.this._rssdHost.trim();
                RepServerProp.this._rssdPort = this._goPage.fld_rssdport.getText();
                RepServerProp.this._rssdPort = RepServerProp.this._rssdPort.trim();
                try {
                    RepServerProp.this.getRepServer().validateRSSDConnection(RepServerProp.this._rssdUser, RepServerProp.this._rssdPwd, RepServerProp.this._rssdCharset, RepServerProp.this._rssdLang, RepServerProp.this._rssdHost, RepServerProp.this._rssdPort);
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    return false;
                }
                RepServerProp.this._monitor = this._goPage.chk_monitor.isSelected();
                RepServerProp.this._interval = this._goPage.spn_interval.getValue();
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
        }

        public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
            this.setModified(true);
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private RSPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("RepServerRes", "GENERAL_PAGE_TAG"));
            this._goPage = new RSPropGeneralPanel();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_rsName.setText(RepServerProp.this.getRepServer().getName());
            this._goPage.fld_version.setText(RepServerProp.this.getRepServer().getVersionString());
            this._goPage.fld_version.setCaretPosition(0);
            this._goPage.fld_state.setText(RepServerProp.this.getRepServer().getStateString());
            this._goPage.fld_reason.setText(RepServerProp.this.getRepServer().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(RepServerProp.this.getRepServer().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
            if (RepServerProp.this.getRepServer().isControlledByRSMS()) {
                this._goPage.lbl_quiesce.setVisible(false);
                this._goPage.fld_quiesce.setVisible(false);
                this._goPage.sep2.setVisible(false);
                this._goPage.lbl_idServer.setVisible(false);
                this._goPage.fld_idServer.setVisible(false);
                this._goPage.lbl_rssd.setVisible(false);
                this._goPage.fld_rssd.setVisible(false);
                this._goPage.sep3.setVisible(false);
                this._goPage.lbl_siteVersion.setVisible(false);
                this._goPage.cbx_siteVersion.setVisible(false);
                this._goPage.lbl_systemVersion.setVisible(false);
                this._goPage.cbx_systemVersion.setVisible(false);
            } else {
                this._goPage.fld_quiesce.setText(RepServerProp.this.getRepServer().isQuiesce() ? BundleManager.getString("RepServerRes", "DISP_YES_TEXT") : BundleManager.getString("RepServerRes", "DISP_NO_TEXT"));
                if (RepServerProp.this.getRepServer().getIDServer() != null && RepServerProp.this.getRepServer().getIDServer().length() > 0) {
                    this._goPage.fld_idServer.setText(RepServerProp.this.getRepServer().getIDServer());
                }
                this._goPage.fld_rssd.setText(RepServerProp.this.getRepServer().getRSSDServer() + "." + RepServerProp.this.getRepServer().getRSSDDatabase());
                this.loadVersionList(this._goPage.cbx_siteVersion, RSConnection.SITE_VERSION_LIST, RepServerProp.this.getRepServer().getSiteVersion());
                this._goPage.lbl_systemVersion.setEnabled(RepServerProp.this.getRepServer().isIDServer());
                this._goPage.cbx_systemVersion.setEnabled(RepServerProp.this.getRepServer().isIDServer());
                if (RepServerProp.this.getRepServer().isIDServer()) {
                    this.loadVersionList(this._goPage.cbx_systemVersion, RSConnection.SYSTEM_VERSION_LIST, RepServerProp.this.getRepServer().getSystemVersion());
                } else {
                    this._goPage.cbx_systemVersion.addItem((Object)String.valueOf(RepServerProp.this.getRepServer().getSystemVersion()));
                }
                this._goPage.cbx_siteVersion.addActionListener((ActionListener)this);
                this._goPage.cbx_systemVersion.addActionListener((ActionListener)this);
            }
        }

        @Override
        public boolean onOk() {
            boolean bl = true;
            if (RepServerProp.this.getRepServer().isControlledByRSMS() && this.isModified()) {
                String string = this._goPage.cbx_siteVersion.getSelectedString();
                if (string != null && !string.equals(String.valueOf(RepServerProp.this.getRepServer().getSiteVersion()))) {
                    try {
                        RepServerProp.this.getRepServer().updateSiteVersion(string);
                    }
                    catch (SQLException sQLException) {
                        bl = false;
                        PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    }
                }
                if ((string = this._goPage.cbx_systemVersion.getSelectedString()) != null && !string.equals(String.valueOf(RepServerProp.this.getRepServer().getSystemVersion()))) {
                    try {
                        RepServerProp.this.getRepServer().updateSystemVersion(string);
                    }
                    catch (SQLException sQLException) {
                        bl = false;
                        PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                    }
                }
            }
            return bl;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), RepServerProp.this.getRepServer().getReasons(), RepServerProp.this.getRepServer().getName());
                reasonListDlg.showDialog();
            } else {
                this.setModified(true);
            }
        }

        protected void loadVersionList(ASAComboBox aSAComboBox, int[] nArray, int n) {
            int n2 = RepServerProp.this.getRepServer().getVersionNumber();
            aSAComboBox.clear();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < n || nArray[i] > n2) continue;
                aSAComboBox.addItem((Object)String.valueOf(nArray[i]));
            }
            aSAComboBox.setSelectedItem(String.valueOf(n));
        }
    }
}

