/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rms;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.RMSServerStatusSO;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RMS
extends RMSServerStatusSO {
    public static final int DISCONNECT_STATE = 6;
    String _lastMonitored = null;
    String _versionString = null;
    private static final String GET_STATUS = "GET_STATUS";
    private static final Object[][] contents = new Object[][]{{"GET_STATUS", new Integer(1500), "get servers {0}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMS(RMSDomain rMSDomain) {
        super(rMSDomain.getName(), rMSDomain);
        this.setState(3);
        this.clearReasons();
        this.setReportEvent(false);
    }

    public RMS(String string) {
        super(string);
        this.setReportEvent(false);
    }

    @Override
    public String getServerType() {
        return "Replication Monitoring Services";
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "RMS";
    }

    @Override
    public String getLastMonitoredDate() {
        return "";
    }

    public static List getDomains() {
        List list = RMSDomain.getDomains();
        if (list != null && list.size() > 0) {
            ArrayList<RMS> arrayList = new ArrayList<RMS>();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                String string = listIterator.next().toString();
                Domain domain = PluginSupport.getDomain(string);
                if (domain != null) {
                    if (!domain.isRMS()) continue;
                    RMS rMS = new RMS((RMSDomain)domain);
                    rMS.loadStatus();
                    arrayList.add(rMS);
                    continue;
                }
                arrayList.add(new RMS(string));
            }
            return arrayList;
        }
        return new ArrayList();
    }

    public void alter(String string, String string2, String string3, String string4, String string5, String string6) {
        boolean bl = false;
        ConnAttributes connAttributes = this.getDomain().getRMSServer();
        if (!connAttributes.getUser().equals(string)) {
            bl = true;
        }
        String string7 = string2 = string2 == null ? "" : string2;
        if (!connAttributes.getPassword().equals(string2)) {
            bl = true;
        }
        String string8 = string3 = string3 == null ? "" : string3;
        if (!connAttributes.getCharset().equals(string3)) {
            bl = true;
        }
        String string9 = string4 = string4 == null ? "" : string4;
        if (!connAttributes.getLanguage().equals(string4)) {
            bl = true;
        }
        String string10 = string5 = string5 == null ? "" : string5;
        if (!connAttributes.getHost().equals(string5)) {
            bl = true;
        }
        String string11 = string6 = string6 == null ? "" : string6;
        if (!connAttributes.getPort().equals(string6)) {
            bl = true;
        }
        if (bl) {
            this.getDomain().alter(string, string2, string3, string4, string5, string6);
        }
    }

    public boolean isConnected() {
        return this.getDomain() != null;
    }

    public void connect(RMSDomain rMSDomain) {
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        this.setDomain(rMSDomain);
        this.loadStatus();
    }

    public void disconnect() {
        if (this.getDomain() != null) {
            this.getDomain().disconnect();
            this.setDomain(null);
        }
    }

    public void delete() {
        if (this.getDomain() != null) {
            this.getDomain().delete();
            this.disconnect();
        } else {
            RMSDomain rMSDomain = new RMSDomain(this.getName());
            rMSDomain.delete();
        }
    }

    @Override
    public String getUsername() {
        return this.getDomain().getUsername();
    }

    @Override
    public String getPassword() {
        return this.getDomain().getPassword();
    }

    public String getStateString() {
        String string;
        if (this.isConnected()) {
            switch (this.getRSState()) {
                case 5: {
                    string = BundleManager.getString("DomainRes", "ACTIVE_STATE");
                    break;
                }
                case 0: {
                    string = BundleManager.getString("DomainRes", "DOWN_STATE");
                    break;
                }
                case 4: {
                    string = BundleManager.getString("DomainRes", "SUSPECT_STATE");
                    break;
                }
                case 3: {
                    string = BundleManager.getString("DomainRes", "UNKNOWN_STATE");
                    break;
                }
                default: {
                    Dbg.wassert(false, "Unexpected Domain State");
                    string = "";
                    break;
                }
            }
        } else {
            string = BundleManager.getString("DomainRes", "DISCONNECTED_STATE");
        }
        return string;
    }

    @Override
    public String getCharset() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRMSServer();
        if (connAttributes != null) {
            string = connAttributes.getCharset();
        }
        return string;
    }

    @Override
    public String getLanguage() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRMSServer();
        if (connAttributes != null) {
            string = connAttributes.getLanguage();
        }
        return string;
    }

    @Override
    public String getHost() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRMSServer();
        if (connAttributes != null && connAttributes.isAddressSavedLocally()) {
            string = connAttributes.getHost();
        }
        return string;
    }

    @Override
    public String getPort() {
        String string = "";
        ConnAttributes connAttributes = this.getDomain().getRMSServer();
        if (connAttributes != null && connAttributes.isAddressSavedLocally()) {
            string = connAttributes.getPort();
        }
        return string;
    }

    public String getVersionString() {
        String string = "";
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            if (rMSConnection.isConnectionOpen()) {
                string = rMSConnection.getVersionString();
            }
            rMSConnection.unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateConnection(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        ConnAttributes connAttributes = ConnAttributes.load(this.getName(), this.getName());
        connAttributes.setServer(this.getName());
        connAttributes.setType("RMS");
        connAttributes.setUser(string);
        connAttributes.setPassword(string2);
        connAttributes.setCharset(string3);
        connAttributes.setLanguage(string4);
        if (string5 != null && string5.length() > 0) {
            connAttributes.setHost(string5);
        }
        if (string6 != null && string6.length() > 0) {
            connAttributes.setHost(string6);
        }
        RMSConnection rMSConnection = new RMSConnection(connAttributes);
        try {
            rMSConnection.open();
        }
        finally {
            if (rMSConnection != null) {
                rMSConnection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadStatus() {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getDomain().getRMSVersionNumber();
            String string = _cmdBundle.getCommand(GET_STATUS, n, this.getName());
            Dbg.wassert(string != null, "Unable to get server command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    String string3 = rSMResultSet.getColumnString(2);
                    if (string3.equalsIgnoreCase(this.getRMSType())) {
                        this._lastMonitored = rSMResultSet.getColumnString(3);
                        this._versionString = rSMResultSet.getColumnString(4);
                        this.setState(rSMResultSet.getColumnInt(5));
                        String string4 = rSMResultSet.getColumnString(7);
                        if (string4 != null && string4.length() > 0) {
                            this.addReason(string4);
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
    }

    @Override
    public void loadProperties() throws SQLException {
    }
}

