/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rms;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDetailsContainer;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.central.SCViewerDetailsPanel2;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseAddItem;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.ase.ASE;
import com.sybase.rsmplugin.components.ase.ASEContainer;
import com.sybase.rsmplugin.components.directconnect.DirectConnect;
import com.sybase.rsmplugin.components.directconnect.DirectConnectContainer;
import com.sybase.rsmplugin.components.domain.AddServerWizard;
import com.sybase.rsmplugin.components.domain.ReconnectDlg;
import com.sybase.rsmplugin.components.events.EventDetailContainer;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgent;
import com.sybase.rsmplugin.components.lanrepagent.LANRepAgentContainer;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgent;
import com.sybase.rsmplugin.components.mirrorrepagent.MirrorRepAgentContainer;
import com.sybase.rsmplugin.components.remoterms.RemoteRMS;
import com.sybase.rsmplugin.components.remoterms.RemoteRMSContainer;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.repserver.RepServerContainer;
import com.sybase.rsmplugin.components.rms.RMS;
import com.sybase.rsmplugin.components.rms.RMSProp;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class RMSContainer
extends BaseContainer
implements RMContainer,
StatusItem {
    private static final String CLASS_ID = "domain.RMSContainer";
    public static final int CMD_ADD_SERVER = 3009;
    private RMS _so;
    private static ImageIcon _iconUp = null;
    private static ImageIcon _iconDown = null;
    private static ImageIcon _iconSuspect = null;
    private static ImageIcon _iconDisconnected = null;

    public RMSContainer(RMS rMS, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(rMS != null, "Null Environment Semantic object parameter.");
        this._so = rMS;
        StatusManager.addStatusItem(this);
    }

    public RMS getRMS() {
        return this._so;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getRMS().getStateString();
            }
            case 2: {
                return this.getRMS().getReason();
            }
        }
        return "";
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getRSMSUp());
        }
        return _iconUp;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this._so.isConnected()) {
            if (this.getRMS().isError()) {
                if (_iconDown == null) {
                    _iconDown = new ImageIcon(RSMImages.getRSMSDown());
                }
                return _iconDown;
            }
            if (this.getRMS().isWarning()) {
                if (_iconSuspect == null) {
                    _iconSuspect = new ImageIcon(RSMImages.getRSMSSuspect());
                }
                return _iconSuspect;
            }
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getRSMSUp());
            }
            return _iconUp;
        }
        if (_iconDisconnected == null) {
            _iconDisconnected = new ImageIcon(RSMImages.getRSMSDisconnected());
        }
        return _iconDisconnected;
    }

    @Override
    public int getAttributes() {
        return 1;
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu;
        if (this._so.isConnected()) {
            defaultSCMenu = new DefaultSCMenu();
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDisconnectMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        } else {
            defaultSCMenu = new DefaultSCMenu();
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        }
        return defaultSCMenu;
    }

    @Override
    public SCMenu getCreationMenu() {
        DefaultSCMenu defaultSCMenu = null;
        if (this._so.isConnected()) {
            defaultSCMenu = new DefaultSCMenu();
            String string = BundleManager.getString("DomainRes", "MENU_ADD_SERVER");
            String string2 = BundleManager.getString("DomainRes", "MENU_HINT_ADD_SERVER");
            char c = BundleManager.getMnemonic("DomainRes", "MENU_MNEM_ADD_SERVER");
            ImageIcon imageIcon = new ImageIcon(RSMImages.getRepServerUp());
            MenuItem menuItem = new MenuItem(3009, string, string2, c, imageIcon);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
        }
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    @Override
    public boolean onNotify(JFrame jFrame, int n, int n2) {
        boolean bl = true;
        if (!(n != 203 && n != 100 || this._so.isConnected())) {
            ReconnectDlg reconnectDlg = new ReconnectDlg(PluginSupport.getDialogSupport(PluginSupport.getViewerFrame()), this.getName(), true);
            if (reconnectDlg.showDialog()) {
                this._so.connect((RMSDomain)reconnectDlg.getDomain());
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 107: {
                BaseController baseController = PluginSupport.getDialog(RMSProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                RMSProp rMSProp = new RMSProp(this.getRMS(), this, sCDialogSupport2);
                rMSProp.showDialog();
                break;
            }
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof RMSContainer)) continue;
                    ((RMSContainer)baseItem).getRMS().delete();
                    listIterator.remove();
                }
                this.getParent().refresh();
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 3003: {
                PluginSupport.getViewerSupport().startWait();
                this._so.disconnect();
                this.collapse();
                this.getParent().select();
                this.getParent().refresh();
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 3009: {
                AddServerWizard addServerWizard;
                RMSDomain rMSDomain = this.getRMS().getDomain();
                if (rMSDomain == null || !(addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(jFrame), rMSDomain)).showModalDialog()) break;
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    rMSDomain.addServer(connAttributes);
                }
                if (list.isEmpty()) break;
                PluginSupport.refreshDomain(this);
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            super.open(n);
            if (this._so.isConnected()) {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getName());
                this.addItem((SCItem)new AddServerItem(this));
                if (semanticFactory != null) {
                    BaseContainer baseContainer;
                    ListIterator listIterator = semanticFactory.getASEs().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new ASEContainer((ASE)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getRepServers().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new RepServerContainer((RepServer)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getLANRepAgents().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new LANRepAgentContainer((LANRepAgent)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getMirrorRepAgents().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new MirrorRepAgentContainer((MirrorRepAgent)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getDirectConnects().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new DirectConnectContainer((DirectConnect)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                    listIterator = semanticFactory.getRemoteRMSs().listIterator();
                    while (listIterator.hasNext()) {
                        baseContainer = new RemoteRMSContainer((RemoteRMS)listIterator.next(), this);
                        this.addItem((SCItem)baseContainer);
                    }
                }
            }
            super.open(n);
        }
    }

    @Override
    public void setState(int n) {
        this.getRMS().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getRMS().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getRMS().getDomainName();
    }

    @Override
    public String getType() {
        return this.getRMS().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getDisplayName(1);
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }

    @Override
    public Object[] getDetailsPanels(JFrame jFrame) {
        String string = this.getParent().getName();
        SCViewerDetailsPanel2 sCViewerDetailsPanel2 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", null);
        SCViewerDetailsPanel2 sCViewerDetailsPanel22 = SCViewerDetailsPanel2.getViewerDetailsPanel((String)"DETAILS_LIST", (SCDetailsContainer)new EventDetailContainer(BundleManager.getString("EventsRes", "EVENT_TAB"), this.getName(), this.getName(), this));
        sCViewerDetailsPanel22.setPanelName(sCViewerDetailsPanel22.getSCDetailsContainer().getDisplayName());
        Object[] objectArray = new Object[]{sCViewerDetailsPanel2, sCViewerDetailsPanel22};
        return objectArray;
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("DomainRes", "HDR_SERVER"), BundleManager.getString("DomainRes", "COL_HEADER_STATE"), BundleManager.getString("DomainRes", "COL_HEADER_REASON")};
    }

    class AddServerItem
    extends BaseAddItem {
        public AddServerItem(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("DomainRes", "ADD_SERVER_TITLE"), RSMImages.getAddEnvironment());
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            AddServerWizard addServerWizard;
            RMSDomain rMSDomain = RMSContainer.this.getRMS().getDomain();
            if (rMSDomain != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(jFrame), rMSDomain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    rMSDomain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(this.getParent());
                }
            }
        }
    }
}

