/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rms;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.ConfigParameter;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RSMObjectRow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RMSParameter
implements RSMObjectRow,
ConfigParameter {
    private static final int COLUMN_COUNT = 3;
    private String _name;
    private String _currentValue;
    private String _pendingValue;
    private String _originalPendingValue;
    private String _defaultValue;
    private boolean _restartRequired;
    private String _legalValue;
    private String _explanation;
    private String _datatype;
    private RMSDomain _domain = null;
    private static final String GET_PARAMS = "GET_PARAMS";
    private static final String SET_PARAM = "SET_PARAM";
    private static final Object[][] contents = new Object[][]{{"GET_PARAMS", new Integer(1200), "configure"}, {"SET_PARAM", new Integer(1200), "configure {0}={1}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSParameter(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, String string7, RMSDomain rMSDomain) {
        this._name = string;
        this._currentValue = string2;
        this._pendingValue = string3;
        this._defaultValue = string4;
        this._restartRequired = bl;
        this._legalValue = string5;
        this._explanation = string6;
        this._datatype = string7;
        this.resetOriginalPendingValue();
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        this._domain = rMSDomain;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public RMSDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null RMS domain attribute.");
        return this._domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRMSParameters(RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        int n = rMSDomain.getRMSVersionNumber();
        String string = _cmdBundle.getCommand(GET_PARAMS, n);
        Dbg.wassert(string != null, "Unable to get parameter query command, RMS version: " + n);
        ArrayList<RMSParameter> arrayList = new ArrayList<RMSParameter>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                while (rSMResultSet.getNextRow()) {
                    String string2 = rSMResultSet.getColumnString(1);
                    String string3 = rSMResultSet.getColumnString(2);
                    String string4 = rSMResultSet.getColumnString(3);
                    String string5 = rSMResultSet.getColumnString(4);
                    if (rSMResultSet.wasNull()) {
                        string5 = string4;
                    }
                    String string6 = rSMResultSet.getColumnString(5);
                    String string7 = rSMResultSet.getColumnString(6);
                    String string8 = rSMResultSet.getColumnString(7);
                    boolean bl = rSMResultSet.getColumnBool(8);
                    String string9 = rSMResultSet.getColumnString(9);
                    RMSParameter rMSParameter = new RMSParameter(string2, string4, string5, string6, bl, string7, string9, string3, rMSDomain);
                    arrayList.add(rMSParameter);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alter() throws SQLException {
        if (this.isModified()) {
            int n = this.getDomain().getRMSVersionNumber();
            Object[] objectArray = new String[]{this.getName(), this.getPendingValue()};
            String string = _cmdBundle.getCommand(SET_PARAM, n, objectArray);
            Dbg.wassert(string != null, "Unable to get set parameter command, RMS version: " + n);
            RMSConnection rMSConnection = this.getDomain().getRMSConnection();
            if (rMSConnection != null) {
                try {
                    rMSConnection.execute(string);
                    this.resetOriginalPendingValue();
                }
                finally {
                    rMSConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getName()), "_RSM_", 3);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getCurrentValue();
            }
            case 2: {
                if (!this.isModified() && this.getOriginalPendingValue().equals(this.getCurrentValue())) {
                    return "";
                }
                if (this.getDatatype() == 4) {
                    return "********";
                }
                return this.getPendingValue();
            }
        }
        return " ";
    }

    @Override
    public void setValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                this._name = (String)object;
                break;
            }
            case 1: {
                this._currentValue = (String)object;
                break;
            }
            case 2: {
                this._pendingValue = (String)object;
                break;
            }
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public String getPendingValue() {
        return this._pendingValue;
    }

    @Override
    public void setPendingValue(String string) {
        if (string != null && !this._pendingValue.equals(string)) {
            this._pendingValue = string;
        }
    }

    protected String getOriginalPendingValue() {
        return this._originalPendingValue;
    }

    public void resetOriginalPendingValue() {
        this._originalPendingValue = this._pendingValue;
    }

    @Override
    public boolean isModified() {
        return !this.getPendingValue().equals(this.getOriginalPendingValue());
    }

    @Override
    public String getDefaultValue() {
        return this._defaultValue;
    }

    @Override
    public String getStatus() {
        if (this.isRestartRequired()) {
            return BundleManager.getString("ComponentRes", "DISP_NO_TEXT");
        }
        return BundleManager.getString("ComponentRes", "DISP_YES_TEXT");
    }

    @Override
    public boolean isRestartRequired() {
        return this._restartRequired;
    }

    @Override
    public String getLegalValues() {
        return this._legalValue;
    }

    @Override
    public String getExplanation() {
        return this._explanation;
    }

    @Override
    public int getDatatype() {
        if (this._datatype.equalsIgnoreCase("int")) {
            return 0;
        }
        if (this._datatype.equalsIgnoreCase("real")) {
            return 1;
        }
        if (this._datatype.equalsIgnoreCase("string")) {
            return 2;
        }
        if (this._datatype.equalsIgnoreCase("boolean")) {
            return 3;
        }
        if (this._datatype.equalsIgnoreCase("password")) {
            return 4;
        }
        return 2;
    }
}

