/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rms;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.ConfigPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.rms.RMS;
import com.sybase.rsmplugin.components.rms.RMSParameter;
import com.sybase.rsmplugin.components.rms.RMSPropCommPanel;
import com.sybase.rsmplugin.components.rms.RMSPropGeneralPanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RMSProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected RMS _rms;
    protected BaseItem _item;
    protected List _paramList;
    protected String _user = null;
    protected String _pwd;
    protected String _charset;
    protected String _lang;
    protected String _host;
    protected String _port;

    RMSProp(RMS rMS, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(rMS != null, "Null RMS parameter.");
        this._rms = rMS;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        try {
            this._paramList = RMSParameter.getRMSParameters(rMS.getDomain());
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            this._paramList = new ArrayList();
        }
        try {
            this._rms.loadProperties();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    RMS getRMS() {
        return this._rms;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("RMSRes", "PROPERTIES_TITLE", this.getRMS().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new CommPage(this), new ConfigPage((BaseProperties)this, this._paramList)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            RMSParameter rMSParameter = (RMSParameter)listIterator.next();
            if (rMSParameter == null) continue;
            try {
                rMSParameter.alter();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (this._user != null) {
            this.getRMS().alter(this._user, this._pwd, this._charset, this._lang, this._host, this._port);
        }
        if (!bl) {
            return super.onOk();
        }
        return false;
    }

    @Override
    public void onApply() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            RMSParameter rMSParameter = (RMSParameter)listIterator.next();
            if (rMSParameter == null) continue;
            try {
                rMSParameter.alter();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (this._user != null) {
            this.getRMS().alter(this._user, this._pwd, this._charset, this._lang, this._host, this._port);
        }
        if (!bl) {
            super.onApply();
        }
    }

    class CommPage
    extends BasePropertyPage
    implements ActionListener,
    DocumentListener {
        private RMSPropCommPanel _goPage;

        public CommPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("ConnectionRes", "COMM_PAGE_TAG"));
            this._goPage = new RMSPropCommPanel();
        }

        @Override
        public void onInitDialog() {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(RMSProp.this.getRMS().getDomainName());
            this._goPage.fld_username.setText(RMSProp.this.getRMS().getUsername());
            this._goPage.fld_password.setText("        ");
            this._goPage.cbx_charset.setSelection(RMSProp.this.getRMS().getCharset());
            this._goPage.cbx_language.setSelection(RMSProp.this.getRMS().getLanguage());
            this._goPage.fld_host.setText(RMSProp.this.getRMS().getHost());
            this._goPage.fld_port.setText(RMSProp.this.getRMS().getPort());
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.cbx_charset.addActionListener(this);
            this._goPage.cbx_language.addActionListener(this);
            this._goPage.fld_host.getDocument().addDocumentListener(this);
            this._goPage.fld_port.getDocument().addDocumentListener(this);
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                RMSProp.this._user = this._goPage.fld_username.getText();
                RMSProp.this._user = RMSProp.this._user.trim();
                RMSProp.this._pwd = this._goPage.fld_password.getPasswordString();
                if (RMSProp.this._pwd.equals("        ")) {
                    RMSProp.this._pwd = RMSProp.this.getRMS().getPassword();
                }
                RMSProp.this._charset = this._goPage.cbx_charset.getSelection();
                RMSProp.this._charset = RMSProp.this._charset.trim();
                if (RMSProp.this._charset.equals("default")) {
                    RMSProp.this._charset = "";
                }
                RMSProp.this._lang = this._goPage.cbx_language.getSelection();
                RMSProp.this._lang = RMSProp.this._lang.trim();
                if (RMSProp.this._lang.equals("default")) {
                    RMSProp.this._lang = "";
                }
                RMSProp.this._host = this._goPage.fld_host.getText();
                RMSProp.this._host = RMSProp.this._host.trim();
                if (RMSProp.this._host.length() == 0) {
                    RMSProp.this._host = "";
                }
                RMSProp.this._port = this._goPage.fld_port.getText();
                RMSProp.this._port = RMSProp.this._port.trim();
                if (RMSProp.this._port.length() == 0) {
                    RMSProp.this._port = "";
                }
                try {
                    RMSProp.this.getRMS().validateConnection(RMSProp.this._user, RMSProp.this._pwd, RMSProp.this._charset, RMSProp.this._lang, RMSProp.this._host, RMSProp.this._port);
                }
                catch (SQLException sQLException) {
                    PluginSupport.showValidationError(sQLException.getMessage());
                    return false;
                }
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private RMSPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("RepServerRes", "GENERAL_PAGE_TAG"));
            this._goPage = new RMSPropGeneralPanel();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_rsName.setText(RMSProp.this.getRMS().getName());
            this._goPage.fld_version.setText(RMSProp.this.getRMS().getVersionString());
            this._goPage.fld_version.setCaretPosition(0);
            this._goPage.fld_state.setText(RMSProp.this.getRMS().getStateString());
            this._goPage.fld_reason.setText(RMSProp.this.getRMS().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(RMSProp.this.getRMS().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onOk() {
            boolean bl = true;
            return bl;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), RMSProp.this.getRMS().getReasons(), RMSProp.this.getRMS().getName());
                reasonListDlg.showDialog();
            } else {
                this.setModified(true);
            }
        }
    }
}

