/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.route;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseWizard;
import com.sybase.rsmplugin.components.BaseWizardPage;
import com.sybase.rsmplugin.components.CmdSummaryDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.SummaryWizPage;
import com.sybase.rsmplugin.components.domain.AddServerWizard;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.components.route.RouteWizDirectPanel;
import com.sybase.rsmplugin.components.route.RouteWizIndirectPanel;
import com.sybase.rsmplugin.components.route.RouteWizTypePanel;
import com.sybase.rsmplugin.components.route.RouteWizUserPanel;
import com.sybase.rsmplugin.sql.ConnAttributes;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddRouteWizard
extends BaseWizard {
    protected SCPageController[] _pages = null;
    protected BaseContainer _container;
    protected String _domainName = null;
    protected String _originRS = null;
    protected String _interRS = null;
    protected String _destRS = null;
    protected String _maintUser = null;
    protected String _maintPwd = null;
    protected boolean _isDirect = false;

    public AddRouteWizard(BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2, String string, String string2) {
        super(sCDialogSupport2);
        Dbg.wassert(baseContainer != null, "Null BaseContainer parameter.");
        this._container = baseContainer;
        Dbg.wassert(string != null && string.length() > 0, "Null or empty origin rep server name parameter.");
        this._originRS = string;
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty domain name parameter.");
        this._domainName = string2;
    }

    public String getDomainName() {
        Dbg.wassert(this._domainName != null, "Null domain connection attribute.");
        return this._domainName;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("RouteRes", "ADD_ROUTE_WIZARD_TITLE");
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new TypePage(this), new DirectPage(this), new MaintPage(this), new IndirectPage(this), new SummaryWizPage(this, RSMImages.getAddServerWizard()){

                @Override
                protected String getSummary() {
                    return AddRouteWizard.this.toFormattedString();
                }
            }};
        }
        return this._pages;
    }

    public String toFormattedString() {
        String string = "";
        String string2 = this._originRS + "." + this._destRS;
        if (this._isDirect) {
            string = string + BundleManager.getString("RouteRes", "ROUTE_WIZ_SUM_DIRECT", string2) + "\n";
            string = string + BundleManager.getString("RouteRes", "ROUTE_WIZ_SUM_MAINT", this._maintUser) + "\n";
        } else {
            string = string + BundleManager.getString("RouteRes", "ROUTE_WIZ_SUM_INDIRECT", string2) + "\n";
            string = string + BundleManager.getString("RouteRes", "ROUTE_WIZ_SUM_INTER", this._interRS) + "\n";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onWizardFinish() {
        boolean bl = true;
        this.getDialogSupport().startWait();
        try {
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
            Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
            Route route = semanticFactory.getRoute(this._originRS, this._originRS, this._destRS);
            if (this._isDirect) {
                ArrayList<String> arrayList = new ArrayList<String>();
                route.setUsername(this._maintUser);
                bl = route.createDirect(this._maintPwd, arrayList);
                if (arrayList.size() > 0) {
                    arrayList.add(BundleManager.getString("ConnectionRes", "END_OF_PROCESS_SUMMARY"));
                    CmdSummaryDlg cmdSummaryDlg = new CmdSummaryDlg(PluginSupport.getDialogSupport(this.getJDialog()), arrayList);
                    cmdSummaryDlg.setDescription(this.getTitle());
                    cmdSummaryDlg.showDialog();
                }
            } else {
                route.setIntermediateRS(this._interRS);
                route.createIndirect();
            }
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        finally {
            this.getDialogSupport().endWait();
        }
        if (bl) {
            super.onWizardFinish();
            PluginSupport.refreshDomain(this._container);
        }
        return bl;
    }

    class IndirectPage
    extends BaseWizardPage
    implements ActionListener {
        private RouteWizIndirectPanel _goPage;

        public IndirectPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("RouteRes", "WIZ_INDIRECT_TITLE"));
            this._goPage = new RouteWizIndirectPanel();
            this.enableNextButton(true);
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_originRS.setText(AddRouteWizard.this._originRS);
            this._goPage.cbx_intermediateRS.addActionListener((ActionListener)this);
            this._goPage.cbx_destRS.addActionListener((ActionListener)this);
            this._goPage.btn_addServer.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onSetActive() {
            this.loadInterSite(AddRouteWizard.this._originRS, AddRouteWizard.this._interRS);
            String string = this._goPage.cbx_intermediateRS.getSelectedString();
            if (string != null && string.length() > 0) {
                this.loadDestSite(AddRouteWizard.this._originRS, string, AddRouteWizard.this._destRS);
            }
            this.setButtons();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public int onWizardNext() {
            AddRouteWizard.this._interRS = this._goPage.cbx_intermediateRS.getSelectedString();
            AddRouteWizard.this._destRS = this._goPage.cbx_destRS.getSelectedString();
            return 0;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.cbx_intermediateRS) {
                String string = this._goPage.cbx_intermediateRS.getSelectedString();
                String string2 = this._goPage.cbx_destRS.getSelectedString();
                if (string != null && string.length() > 0) {
                    this.loadDestSite(AddRouteWizard.this._originRS, string, string2);
                }
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.cbx_destRS) {
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(AddRouteWizard.this.getDomainName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(AddRouteWizard.this.getJDialog()), domain)).showModalDialog()) {
                Object object;
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    object = (ConnAttributes)listIterator.next();
                    domain.addServer((ConnAttributes)object);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(AddRouteWizard.this._container);
                    object = this._goPage.cbx_intermediateRS.getSelectedString();
                    this.loadInterSite(AddRouteWizard.this._originRS, (String)object);
                    object = this._goPage.cbx_intermediateRS.getSelectedString();
                    String string = this._goPage.cbx_destRS.getSelectedString();
                    if (object != null && ((String)object).length() > 0) {
                        this.loadDestSite(AddRouteWizard.this._originRS, (String)object, string);
                    }
                }
            }
        }

        protected void loadInterSite(String string, String string2) {
            Dbg.wassert(string != null && string.length() > 0, "Null or empty origin rep server parameter.");
            this._goPage.cbx_intermediateRS.removeAllItems();
            try {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddRouteWizard.this.getDomainName());
                if (semanticFactory != null) {
                    List list = semanticFactory.getOriginRoutes(string);
                    ListIterator listIterator = list.listIterator();
                    while (listIterator.hasNext()) {
                        Route route = (Route)listIterator.next();
                        this._goPage.cbx_intermediateRS.addItem((Object)route.getDestinationRS());
                    }
                }
                if (string2 != null && string2.length() > 0) {
                    this._goPage.cbx_intermediateRS.setSelectedItem(string2);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }

        protected void loadDestSite(String string, String string2, String string3) {
            Dbg.wassert(string != null && string.length() > 0, "Null or empty origin rep server parameter.");
            Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty intermediate rep server parameter.");
            this._goPage.cbx_destRS.removeAllItems();
            try {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddRouteWizard.this.getDomainName());
                if (semanticFactory != null) {
                    List list = semanticFactory.getOriginRoutes(string);
                    List list2 = semanticFactory.getOriginRoutes(string2);
                    ListIterator listIterator = list2.listIterator();
                    while (listIterator.hasNext()) {
                        Route route = (Route)listIterator.next();
                        String string4 = route.getDestinationRS();
                        if (string4 == null || string4.length() <= 0 || string4.equals(AddRouteWizard.this._originRS)) continue;
                        boolean bl = false;
                        ListIterator listIterator2 = list.listIterator();
                        while (!bl && listIterator2.hasNext()) {
                            route = (Route)listIterator2.next();
                            if (!string4.equals(route.getDestinationRS())) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        this._goPage.cbx_destRS.addItem((Object)string4);
                    }
                }
                if (string3 != null && string3.length() > 0) {
                    this._goPage.cbx_destRS.setSelectedItem(string3);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.cbx_intermediateRS.getSelectedItem() != null && this._goPage.cbx_destRS.getSelectedString() != null);
        }
    }

    class MaintPage
    extends BaseWizardPage
    implements DocumentListener {
        private RouteWizUserPanel _goPage;

        public MaintPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("RouteRes", "WIZ_MAINT_TITLE"));
            this._goPage = new RouteWizUserPanel();
            this._goPage.fld_username.getDocument().addDocumentListener(this);
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_password.setText("        ");
            this._goPage.fld_confirmPwd.setText("        ");
        }

        @Override
        public boolean onSetActive() {
            String string = this._goPage.fld_username.getText();
            if (string == null || string.length() == 0) {
                String string2 = AddRouteWizard.this._originRS + "_maint";
                this._goPage.fld_username.setText(string2);
            }
            this._goPage.fld_password.requestFocus();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddRouteWizard.this._maintUser = this._goPage.fld_username.getText();
            AddRouteWizard.this._maintPwd = this._goPage.fld_password.getPasswordString();
            if (AddRouteWizard.this._maintPwd.equals("        ")) {
                AddRouteWizard.this._maintPwd = "maint_ps";
            }
            return 5;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setButtons();
        }

        protected void setButtons() {
            String string = this._goPage.fld_username.getText();
            String string2 = this._goPage.fld_password.getPasswordString();
            String string3 = this._goPage.fld_confirmPwd.getPasswordString();
            if (string.length() > 0 && string2.equals(string3)) {
                this.enableNextButton(true);
            } else {
                this.enableNextButton(false);
            }
        }
    }

    class DirectPage
    extends BaseWizardPage
    implements ActionListener {
        private RouteWizDirectPanel _goPage;

        public DirectPage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("RouteRes", "WIZ_DIRECT_TITLE"));
            this._goPage = new RouteWizDirectPanel();
            this.enableBackButton(true);
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_originRS.setText(AddRouteWizard.this._originRS);
            this._goPage.cbx_destRS.addActionListener((ActionListener)this);
            this._goPage.btn_addServer.addActionListener((ActionListener)this);
        }

        @Override
        public boolean onSetActive() {
            this.loadDestRS();
            if (AddRouteWizard.this._destRS != null && AddRouteWizard.this._destRS.length() > 0) {
                this._goPage.cbx_destRS.setSelectedItem(AddRouteWizard.this._destRS);
            }
            this.setButtons();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddRouteWizard.this._destRS = this._goPage.cbx_destRS.getSelectedString();
            return 0;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AddServerWizard addServerWizard;
            Domain domain;
            if (actionEvent.getSource() == this._goPage.cbx_destRS) {
                this.setButtons();
            } else if (actionEvent.getSource() == this._goPage.btn_addServer && (domain = PluginSupport.getDomain(AddRouteWizard.this.getDomainName())) != null && (addServerWizard = new AddServerWizard(PluginSupport.getDialogSupport(AddRouteWizard.this.getJDialog()), domain)).showModalDialog()) {
                List list = addServerWizard.getAttributes();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    ConnAttributes connAttributes = (ConnAttributes)listIterator.next();
                    domain.addServer(connAttributes);
                }
                if (!list.isEmpty()) {
                    PluginSupport.refreshDomain(AddRouteWizard.this._container);
                    this.loadDestRS();
                }
            }
        }

        protected void loadDestRS() {
            this._goPage.cbx_destRS.removeAllItems();
            try {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(AddRouteWizard.this.getDomainName());
                if (semanticFactory != null) {
                    List list = semanticFactory.getOriginRoutes(AddRouteWizard.this._originRS);
                    ListIterator listIterator = semanticFactory.getRepServers().listIterator();
                    while (listIterator.hasNext()) {
                        RepServer repServer = (RepServer)listIterator.next();
                        String string = repServer.getName();
                        if (string == null || string.length() <= 0 || string.equals(AddRouteWizard.this._originRS)) continue;
                        boolean bl = false;
                        ListIterator listIterator2 = list.listIterator();
                        while (!bl && listIterator2.hasNext()) {
                            Route route = (Route)listIterator2.next();
                            if (!string.equals(route.getDestinationRS())) continue;
                            bl = true;
                        }
                        if (bl) continue;
                        this._goPage.cbx_destRS.addItem((Object)string);
                    }
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }

        protected void setButtons() {
            this.enableNextButton(this._goPage.cbx_destRS.getSelectedItem() != null);
        }
    }

    class TypePage
    extends BaseWizardPage {
        private RouteWizTypePanel _goPage;

        public TypePage(BaseWizard baseWizard) {
            super(baseWizard, BundleManager.getString("RouteRes", "WIZ_TYPE_TITLE"));
            this._goPage = new RouteWizTypePanel();
        }

        @Override
        public void onInitDialog() {
            this.enableNextButton(true);
        }

        @Override
        public boolean onSetActive() {
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public int onWizardNext() {
            AddRouteWizard.this._isDirect = this._goPage.rbn_direct.isSelected();
            if (AddRouteWizard.this._isDirect) {
                return 0;
            }
            return 4;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }
    }
}

