/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.route;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.EnvStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.components.route.RouteParameter;
import com.sybase.rsmplugin.components.rsthread.RSThread;
import com.sybase.rsmplugin.components.rsuser.RSUser;
import com.sybase.rsmplugin.routeupgrade.RouteUpgrade;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.status.StatusSO;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class DomainRoute
extends EnvStatusSO
implements Route {
    private static final int UPGRADE_NOT_REQUIRED = 0;
    private static final int RECOVERY_REQUIRED = -1;
    public static final int STATUS_UPGRADE_IN_PROGRESS = 1;
    public static final int STATUS_UPGRADE_COMPLETE = 2;
    private String _origin = null;
    private String _destination = null;
    private String _thru = null;
    private int _version = 1103;
    private String _username = null;
    private int _upgradeVersion;
    private int _originID;
    private int _originVersion = 0;
    private int _destID;
    private int _destVersion = 0;
    private static final String GET_ROUTES = "GET_ROUTES";
    private static final String GET_ORIGIN_ROUTES = "GET_ORIGIN_ROUTES";
    private static final String LOAD_ROUTE = "LOAD_ROUTE";
    private static final String LOAD_STATUS = "LOAD_STATUS";
    private static final String CHECK_RECOVERY = "CHECK_RECOVERY";
    private static final String CHECK_SUBS = "CHECK_SUBS";
    private static final String CREATE_DIRECT_ROUTE = "CREATE_DIRECT_ROUTE";
    private static final String CREATE_INDIRECT_ROUTE = "CREATE_INDIRECT_ROUTE";
    private static final String DROP_ROUTE = "DROP_ROUTE";
    private static final String DROP_ROUTE_NOWAIT = "DROP_ROUTE_NOWAIT";
    private static final String ALTER_PWD = "ALTER_PWD";
    private static final String SET_INTERMEDIATE = "SET_INTERMEDIATE";
    private static final String MAKE_DIRECT = "MAKE_DIRECT";
    private static final String SUSPEND_ROUTE = "SUSPEND_ROUTE";
    private static final String RESUME_ROUTE = "RESUME_ROUTE";
    private static final Object[][] contents = new Object[][]{{"GET_ROUTES", new Integer(1200), "rmp_routes ''{0}''"}, {"GET_ORIGIN_ROUTES", new Integer(1200), "rmp_routes_at_origin ''{0}''"}, {"LOAD_ROUTE", new Integer(1200), "rmp_load_route ''{0}'', ''{1}''"}, {"LOAD_STATUS", new Integer(1200), "rmp_load_route_status ''{0}'', ''{1}''"}, {"CHECK_RECOVERY", new Integer(1200), "rmp_check_route_recovery ''{0}''"}, {"CHECK_SUBS", new Integer(1200), "rmp_check_route_subs ''{0}''"}, {"CREATE_DIRECT_ROUTE", new Integer(1200), "create route to \"{0}\"\n\tset username to \"{1}\"\n\tset password to \"{2}\""}, {"CREATE_INDIRECT_ROUTE", new Integer(1200), "create route to \"{0}\"\n\tset next site to \"{1}\"\n"}, {"DROP_ROUTE", new Integer(1200), "drop route to \"{0}\""}, {"DROP_ROUTE_NOWAIT", new Integer(1200), "drop route to \"{0}\" with nowait"}, {"ALTER_PWD", new Integer(1200), "alter route to \"{0}\" set password \"{1}\""}, {"SET_INTERMEDIATE", new Integer(1200), "alter route to \"{0}\" set next site to \"{1}\""}, {"MAKE_DIRECT", new Integer(1200), "alter route to \"{0}\" set username \"{1}\" set password \"{2}\""}, {"SUSPEND_ROUTE", new Integer(1200), "suspend route to \"{0}\""}, {"RESUME_ROUTE", new Integer(1200), "resume route to \"{0}\" {1}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainRoute(String string, String string2, EnvDomain envDomain) {
        super(string + "." + string2, envDomain);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty origin rep server parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty destination rep server parameter.");
        this._origin = string;
        this._destination = string2;
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
        }
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getOriginRS() {
        Dbg.wassert(this._origin != null && this._origin.length() > 0, "Null or empty origin rep server name attribute.");
        return this._origin;
    }

    public int getOriginID() {
        return this._originID;
    }

    public int getOriginVersion() {
        return this._originVersion;
    }

    @Override
    public String getDestinationRS() {
        Dbg.wassert(this._destination != null && this._destination.length() > 0, "Null or empty distination rep name attribute.");
        return this._destination;
    }

    public int getDestinationID() {
        return this._destID;
    }

    public int getDestinationVersion() {
        return this._destVersion;
    }

    @Override
    public String getIntermediateRS() {
        return this._thru == null ? "" : this._thru;
    }

    @Override
    public void setIntermediateRS(String string) {
        this._thru = string != null ? (string.trim().length() > 0 ? string : null) : null;
    }

    @Override
    public boolean isError() {
        return this.getRSState() == 2;
    }

    @Override
    public boolean isDirect() {
        return this.getIntermediateRS().length() == 0;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    public void setVersion(int n) {
        this._version = n < 1103 ? 1103 : n;
    }

    @Override
    public String getUsername() {
        return this._username == null ? "" : this._username;
    }

    @Override
    public void setUsername(String string) {
        this._username = string != null ? (string.trim().length() > 0 ? string : null) : null;
    }

    @Override
    public String getStateString() {
        if (this.isUp()) {
            return BundleManager.getString("RouteRes", "ACTIVE_STATE");
        }
        if (this.isWarning()) {
            return BundleManager.getString("RouteRes", "UNKNOWN_STATE");
        }
        return BundleManager.getString("RouteRes", "SUSPENDED_STATE");
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = this.getDestinationRS();
                break;
            }
            case 1: {
                string = String.valueOf(this.getVersion());
                break;
            }
            case 2: {
                string = this.getUpgradeStatus();
                break;
            }
        }
        return string;
    }

    @Override
    public void setValueAt(Object object, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRoutes(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        ArrayList<DomainRoute> arrayList = new ArrayList<DomainRoute>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            int n = envDomain.getVersionNumber(string);
            String string2 = _cmdBundle.getCommand(GET_ROUTES, n, string);
            Dbg.wassert(string2 != null, "Unable to get route query, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    String string5 = rSMResultSet.getColumnString(3);
                    if (string3 == null || string3.length() <= 0 || string5 == null || string5.length() <= 0) continue;
                    DomainRoute domainRoute = new DomainRoute(string3, string5, envDomain);
                    if (!string4.equals(string5)) {
                        domainRoute.setIntermediateRS(string4);
                    }
                    arrayList.add(domainRoute);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getOriginRoutes(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        ArrayList<DomainRoute> arrayList = new ArrayList<DomainRoute>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            int n = envDomain.getVersionNumber(string);
            String string2 = _cmdBundle.getCommand(GET_ORIGIN_ROUTES, n, string);
            Dbg.wassert(string2 != null, "Unable to get route query, repserver version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    String string5 = rSMResultSet.getColumnString(3);
                    if (string3 == null || string3.length() <= 0 || string5 == null || string5.length() <= 0) continue;
                    DomainRoute domainRoute = new DomainRoute(string3, string5, envDomain);
                    if (!string4.equals(string5)) {
                        domainRoute.setIntermediateRS(string4);
                    }
                    arrayList.add(domainRoute);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    @Override
    public boolean createDirect(String string, List list) {
        Object object;
        Dbg.wassert(list != null, "Null summary list parameter.");
        boolean bl = true;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        Dbg.wassert(semanticFactory != null, "Cannot retrieve semantic factory - domain name: " + this.getDomainName());
        boolean bl2 = false;
        try {
            ListIterator listIterator = semanticFactory.getRSUsers(this.getDestinationRS()).listIterator();
            while (!bl2 && listIterator.hasNext()) {
                object = (RSUser)listIterator.next();
                if (!object.getName().equals(this.getUsername())) continue;
                bl2 = true;
            }
            if (!bl2) {
                list.add("I. " + BundleManager.getString("RouteRes", "CMD_SUM_CREATE_USER", this.getUsername()));
                object = semanticFactory.getRSUser(this.getUsername(), this.getDestinationRS());
                object.setPassword(string);
                object.setSourcePermission(true);
                object.create();
            } else {
                list.add("W. " + BundleManager.getString("RouteRes", "CMD_SUM_USER_EXISTS", this.getUsername()));
            }
        }
        catch (SQLException sQLException) {
            object = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage((String)object, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + (String)object);
        }
        try {
            list.add("I. " + BundleManager.getString("RouteRes", "CMD_SUM_CREATE_DIRECT", this.getName()));
            this.createDirect(string);
        }
        catch (SQLException sQLException) {
            object = MessageText.formatExceptionMessage(sQLException);
            PluginSupport.LogErrorMessage((String)object, MessageText.formatSQLExceptionDetails(sQLException));
            list.add("E. " + (String)object);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDirect(String string) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getOriginRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getDestinationRS(), this.getUsername(), string};
            String string2 = _cmdBundle.getCommand(CREATE_DIRECT_ROUTE, n, objectArray);
            Dbg.wassert(string2 != null, "Unable to get create command, repserver version: " + n);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIndirect() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getOriginRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getDestinationRS(), this.getIntermediateRS()};
            String string = _cmdBundle.getCommand(CREATE_INDIRECT_ROUTE, n, objectArray);
            Dbg.wassert(string != null, "Unable to get create command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        }
    }

    @Override
    public void delete(final List list, final boolean bl) {
        if (list != null && list.size() > 0) {
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("RouteRes", "DELETE_BKGND_TITLE"), this.getDomainName()){

                @Override
                public void run() {
                    ArrayList<String> arrayList = new ArrayList<String>(list.size());
                    DomainRoute domainRoute = (DomainRoute)list.get(0);
                    String string = domainRoute.getName();
                    if (list.size() > 1) {
                        string = string + ", ...";
                    }
                    try {
                        this.setStatus(BundleManager.getString("RouteRes", "DELETE_ROUTE", string));
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            domainRoute = (DomainRoute)listIterator.next();
                            domainRoute.drop(bl);
                        }
                        this.setStatus(BundleManager.getString("RouteRes", "DELETE_MONITORING", string));
                        while (!1.interrupted() && list.size() > 0) {
                            Thread.sleep(5000L);
                            listIterator = list.listIterator();
                            while (!1.interrupted() && listIterator.hasNext()) {
                                domainRoute = (DomainRoute)listIterator.next();
                                int[] nArray = new int[2];
                                DomainRoute.this.checkStatus(domainRoute.getOriginRS(), nArray);
                                if (nArray[0] != -1) continue;
                                DomainRoute.this.checkStatus(domainRoute.getDestinationRS(), nArray);
                                if (nArray[0] != -1) continue;
                                StatusManager.delete(domainRoute.getDomainName(), domainRoute.getType(), domainRoute.getName());
                                arrayList.add(domainRoute.getName());
                                listIterator.remove();
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!this.errorOccurred()) {
                        this.setStatus(BundleManager.getString("RouteRes", "DELETE_LOG_MSG", CollectionUtility.toString(arrayList, ", ")));
                    }
                    DomainRoute.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drop(boolean bl) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getOriginRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string = null;
            string = bl ? _cmdBundle.getCommand(DROP_ROUTE_NOWAIT, n, this.getDestinationRS()) : _cmdBundle.getCommand(DROP_ROUTE, n, this.getDestinationRS());
            Dbg.wassert(string != null, "Unable to get drop command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        }
    }

    @Override
    public void loadStatus() throws SQLException {
        StatusSO statusSO = this.getDomain().getStatus(this.getType(), this.getName());
        if (statusSO != null) {
            this.setState(statusSO.getRSState());
            this.setReasons(statusSO.getReasons());
        } else {
            this.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadProperties() throws SQLException {
        Object object;
        Object object2;
        Object[] objectArray;
        int n;
        RSMConnection rSMConnection = this.getDomain().getRSSD(this.getOriginRS());
        if (rSMConnection != null) {
            n = this.getDomain().getVersionNumber(this.getOriginRS());
            Object[] objectArray2 = new String[]{this.getOriginRS(), this.getDestinationRS()};
            objectArray = _cmdBundle.getCommand(LOAD_ROUTE, n, objectArray2);
            Dbg.wassert(objectArray != null, "Unable to load route details, repserver version: " + n);
            object2 = new RSMResultSet(rSMConnection);
            try {
                ((RSMResultSet)object2).open((String)objectArray);
                if (((RSMResultSet)object2).getNextRow()) {
                    object = ((RSMResultSet)object2).getColumnString(1);
                    this.setUsername((String)object);
                    int n2 = ((RSMResultSet)object2).getColumnInt(2);
                    this.setVersion(n2);
                }
            }
            finally {
                ((RSMResultSet)object2).close();
                rSMConnection.unlock();
            }
        }
        n = 0;
        rSMConnection = this.getDomain().getRSSD(this.getDestinationRS());
        if (rSMConnection != null) {
            int n3 = this.getDomain().getVersionNumber(this.getDestinationRS());
            objectArray = new String[]{this.getOriginRS(), this.getDestinationRS()};
            object2 = _cmdBundle.getCommand(LOAD_ROUTE, n3, objectArray);
            Dbg.wassert(object2 != null, "Unable to load route details, repserver version: " + n3);
            object = new RSMResultSet(rSMConnection);
            try {
                ((RSMResultSet)object).open((String)object2);
                if (((RSMResultSet)object).getNextRow()) {
                    n = ((RSMResultSet)object).getColumnInt(3);
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                ((RSMResultSet)object).close();
                rSMConnection.unlock();
            }
        }
        this._upgradeVersion = 0;
        this._originVersion = 0;
        this._originID = 0;
        this._destVersion = 0;
        this._destID = 0;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomainName());
        objectArray = semanticFactory.getRepServers();
        object2 = objectArray.listIterator();
        while (object2.hasNext()) {
            object = (RepServer)object2.next();
            try {
                if (object.getName().equals(this.getOriginRS())) {
                    object.loadProperties();
                    this._originID = object.getSiteID();
                    this._originVersion = object.getSiteVersion();
                    continue;
                }
                if (!object.getName().equals(this.getDestinationRS())) continue;
                object.loadProperties();
                this._destID = object.getSiteID();
                this._destVersion = object.getSiteVersion();
            }
            catch (SQLException sQLException) {}
        }
        if (this._originVersion == 0 || this._destVersion == 0) {
            this._upgradeVersion = 0;
        } else if ((n & 1) == 1) {
            this._upgradeVersion = -1;
        } else if ((n & 2) != 2) {
            int n4 = this._originVersion < this._destVersion ? this._originVersion : this._destVersion;
            this._upgradeVersion = this.getVersion() < n4 ? n4 : 0;
        }
        super.loadProperties();
    }

    @Override
    public int getUpgradeVersion() {
        return this._upgradeVersion;
    }

    @Override
    public boolean isUpgradeCandidate() {
        return this.getUpgradeVersion() > 0;
    }

    @Override
    public boolean isRecoveryRequired() {
        return this.getUpgradeVersion() == -1;
    }

    public String getUpgradeStatus() {
        String string = "";
        if (this.isUpgradeCandidate()) {
            string = BundleManager.getString("RouteUpgradeRes", "ROUTE_UPGRADE_STATUS", String.valueOf(this.getUpgradeVersion()));
        } else if (this.isRecoveryRequired()) {
            string = BundleManager.getString("RouteUpgradeRes", "ROUTE_RECOVERY_STATUS");
        }
        return string;
    }

    public void monitor(List list) {
        Dbg.wassert(list != null, "Null thread SO list parameter.");
        this.setState(5);
        this.clearReasons();
        boolean bl = false;
        boolean bl2 = false;
        ListIterator listIterator = list.listIterator();
        while (!bl2 && listIterator.hasNext()) {
            RSThread rSThread = (RSThread)listIterator.next();
            if (!rSThread.getComponentName().equals(this.getDestinationRS()) || !rSThread.isRoute()) continue;
            if (rSThread.isDown() || rSThread.isSuspended()) {
                bl = true;
            }
            bl2 = true;
        }
        this.retrieveStatus(bl);
        if (bl) {
            this.setState(2);
            this.addReason(BundleManager.getString("RouteRes", "ROUTE_DOWN", this.getDestinationRS()));
        }
    }

    protected void retrieveStatus(boolean bl) {
        try {
            int[] nArray = new int[2];
            this.checkStatus(this.getOriginRS(), nArray);
            Dbg.trace(256, "Route " + this.getName() + " origin status from rs_routes:" + " state = " + String.valueOf(nArray[0]) + " suspended = " + String.valueOf(nArray[1]));
            switch (nArray[0]) {
                case -1: {
                    this.setState(3);
                    this.addReason(BundleManager.getString("RouteRes", "ROUTE_UNKNOWN", this.getOriginRS()));
                    break;
                }
                case 0: {
                    this.setState(2);
                    this.addReason(BundleManager.getString("RouteRes", "INVALID_ROUTE", this.getName()));
                    break;
                }
                case 1: {
                    this.setState(2);
                    this.addReason(BundleManager.getString("RouteRes", "CREATE_IN_PROGRESS", this.getName()));
                    break;
                }
                case 2: {
                    if (bl || nArray[1] != 1) break;
                    this.setState(2);
                    this.addReason(BundleManager.getString("RouteRes", "SUSPENDED_AT_ORIGIN", this.getName()));
                    break;
                }
                case 3: {
                    this.setState(2);
                    this.addReason(BundleManager.getString("RouteRes", "DROP_IN_PROGRESS", this.getName()));
                    break;
                }
                case 4: {
                    this.setState(2);
                    this.addReason(BundleManager.getString("RouteRes", "DROP_NOWAIT_IN_PROGRESS", this.getName()));
                    break;
                }
                case 5: {
                    this.setState(2);
                    this.addReason(BundleManager.getString("RouteRes", "ALTERING_ROUTE", this.getName()));
                    break;
                }
            }
            if (!bl && this.getRSState() == 5) {
                this.checkStatus(this.getDestinationRS(), nArray);
                Dbg.trace(256, "Route " + this.getName() + " destination status from rs_routes:" + " state = " + String.valueOf(nArray[0]) + " suspended = " + String.valueOf(nArray[1]));
                switch (nArray[0]) {
                    case -1: {
                        this.setState(3);
                        this.addReason(BundleManager.getString("RouteRes", "ROUTE_UNKNOWN", this.getDestinationRS()));
                        break;
                    }
                    case 2: {
                        if (nArray[1] != 1) break;
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "SUSPENDED_AT_DEST", this.getName()));
                        break;
                    }
                    default: {
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "NOT_ACTIVE_AT_DEST", this.getName()));
                    }
                }
            }
            this.checkRecoveryStatus(nArray);
            Dbg.trace(256, "Route " + this.getName() + " origin recovery status from rs_recovery:" + " state = " + String.valueOf(nArray[0]) + " action = " + String.valueOf(nArray[1]));
            if (nArray[1] == 1) {
                switch (nArray[0]) {
                    case -1: {
                        this.setState(3);
                        this.addReason(BundleManager.getString("RouteRes", "ROUTE_UNKNOWN", this.getOriginRS()));
                        break;
                    }
                    case 1: {
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "NOT_SENT_CREATE", this.getName()));
                        break;
                    }
                    case 4: {
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "WAIT_FOR_CREATE", this.getName()));
                        break;
                    }
                    case 5: {
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "DELIVER_CREATE", this.getName()));
                        break;
                    }
                }
            } else if (nArray[1] == 2) {
                switch (nArray[0]) {
                    case -1: {
                        this.setState(3);
                        this.addReason(BundleManager.getString("RouteRes", "ROUTE_UNKNOWN", this.getOriginRS()));
                        break;
                    }
                    case 1: {
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "DROP_SYS_TABLES", this.getName()));
                        break;
                    }
                    case 2: {
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "WAIT_DROP_SYS_TABLES", this.getName()));
                        break;
                    }
                    case 3: {
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "NOT_SENT_DROP", this.getName()));
                        break;
                    }
                    case 4: {
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "DROP_IN_QUEUE", this.getName()));
                        break;
                    }
                    case 5: {
                        this.setState(2);
                        this.addReason(BundleManager.getString("RouteRes", "WAIT_FOR_DROP", this.getName()));
                        break;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            this.setState(2);
            this.addReason(MessageText.formatExceptionMessage(sQLException));
            PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkStatus(String string, int[] nArray) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty replication server parameter.");
        Dbg.wassert(nArray != null, "Null route status parameter.");
        int n = -1;
        int n2 = 0;
        RSMConnection rSMConnection = this.getDomain().getRSSD(string);
        if (rSMConnection != null) {
            int n3 = this.getDomain().getVersionNumber(string);
            Object[] objectArray = new String[]{this.getOriginRS(), this.getDestinationRS()};
            String string2 = _cmdBundle.getCommand(LOAD_STATUS, n3, objectArray);
            Dbg.wassert(string2 != null, "Unable to load the status, repserver version: " + n3);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                if (rSMResultSet.getNextRow()) {
                    n = rSMResultSet.getColumnInt(1);
                    n2 = rSMResultSet.getColumnInt(2);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRecoveryStatus(int[] nArray) throws SQLException {
        int n = -1;
        int n2 = 0;
        RSMConnection rSMConnection = this.getDomain().getRSSD(this.getOriginRS());
        if (rSMConnection != null) {
            int n3 = this.getDomain().getVersionNumber(this.getOriginRS());
            String string = _cmdBundle.getCommand(CHECK_RECOVERY, n3, this.getDestinationRS());
            Dbg.wassert(string != null, "Unable to check the recovery status, repserver version: " + n3);
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    n = rSMResultSet.getColumnInt(1);
                    n2 = rSMResultSet.getColumnInt(2);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPassword(String string) throws SQLException {
        Dbg.wassert(this.isDirect(), "Attempting to alter the password of an indirect route.");
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getOriginRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getDestinationRS(), string == null ? "" : string};
            String string2 = _cmdBundle.getCommand(ALTER_PWD, n, objectArray);
            Dbg.wassert(string2 != null, "Unable to get alter password command, repserver version: " + n);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeIntermediate(String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty intermediate rep server parameter.");
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getOriginRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getDestinationRS(), string};
            String string2 = _cmdBundle.getCommand(SET_INTERMEDIATE, n, objectArray);
            Dbg.wassert(string2 != null, "Unable to get alter next site command, repserver version: " + n);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeDirect(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty username parameter.");
        Dbg.wassert(!this.isDirect(), "Attempting to change an direct route to an direct route.");
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getOriginRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getDestinationRS(), string, string2 == null ? "" : string2};
            String string3 = _cmdBundle.getCommand(MAKE_DIRECT, n, objectArray);
            Dbg.wassert(string3 != null, "Unable to get alter user, password command, repserver version: " + n);
            try {
                rSMConnection.execute(string3);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        }
    }

    @Override
    public void suspend(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("RouteRes", "SUSPEND_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!2.interrupted() && listIterator.hasNext()) {
                            DomainRoute domainRoute = (DomainRoute)listIterator.next();
                            this.setStatus(BundleManager.getString("RouteRes", "SUSPEND_DLG_TITLE", domainRoute.getName()));
                            domainRoute.suspend();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    DomainRoute.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getOriginRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(SUSPEND_ROUTE, n, this.getDestinationRS());
            Dbg.wassert(string != null, "Unable to get suspend route command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        }
    }

    @Override
    public void resume(final List list, final boolean bl) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("RouteRes", "RESUME_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!3.interrupted() && listIterator.hasNext()) {
                            DomainRoute domainRoute = (DomainRoute)listIterator.next();
                            this.setStatus(BundleManager.getString("RouteRes", "RESUME_DLG_TITLE", domainRoute.getName()));
                            domainRoute.resume(bl);
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    DomainRoute.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(boolean bl) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getOriginRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getDestinationRS(), bl ? "skip transaction with large message" : ""};
            String string = _cmdBundle.getCommand(RESUME_ROUTE, n, objectArray);
            Dbg.wassert(string != null, "Unable to get resume route command, repserver version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        }
    }

    @Override
    public String getRCLScript() {
        String string = "";
        try {
            String string2;
            Object object;
            int n;
            if (this.isDirect()) {
                this.loadProperties();
                n = this.getDomain().getVersionNumber(this.getOriginRS());
                object = new String[]{this.getDestinationRS(), this.getUsername(), "********"};
                string2 = _cmdBundle.getCommand(CREATE_DIRECT_ROUTE, n, (Object[])object);
            } else {
                n = this.getDomain().getVersionNumber(this.getOriginRS());
                object = new String[]{this.getDestinationRS(), this.getIntermediateRS()};
                string2 = _cmdBundle.getCommand(CREATE_INDIRECT_ROUTE, n, (Object[])object);
            }
            string = "-- Create route from " + this.getOriginRS() + " to " + this.getDestinationRS() + "\n" + string2;
            String string3 = "";
            object = PluginSupport.getSemanticFactory(this.getDomainName());
            List list = object.getRouteParameters(this.getOriginRS(), this.getDestinationRS());
            if (list != null) {
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    RouteParameter routeParameter = (RouteParameter)listIterator.next();
                    String string4 = routeParameter.getRCLScript(this.getOriginRS(), this.getDestinationRS());
                    if (string4 == null || string4.length() <= 0) continue;
                    string3 = string3 + string4 + "\n";
                }
            }
            if (string3.length() > 0) {
                string = string + "\ngo\n";
                string = string + "-- Set route configuration parameters for " + this.getName() + "\n";
                string = string + string3;
            }
        }
        catch (SQLException sQLException) {
            string = MessageText.formatExceptionMessage(sQLException) + "\n" + MessageText.formatSQLExceptionDetails(sQLException);
            PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return string;
    }

    @Override
    public boolean upgrade() {
        RouteUpgrade routeUpgrade = new RouteUpgrade(this);
        if (!routeUpgrade.isThreadRunning()) {
            routeUpgrade.upgrade();
            return true;
        }
        return false;
    }

    @Override
    public boolean recover() {
        RouteUpgrade routeUpgrade = new RouteUpgrade(this);
        if (!routeUpgrade.isThreadRunning()) {
            routeUpgrade.recover();
            return true;
        }
        return false;
    }
}

