/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.route;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.RMSStatusSO;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RMSRoute
extends RMSStatusSO
implements Route {
    private String _origin = null;
    private String _destination = null;
    private String _thru = null;
    private int _version = 1103;
    private String _username = null;
    private static final String GET_ROUTES = "GET_ROUTES";
    private static final String GET_ROUTE = "GET_ROUTE";
    private static final String SUSPEND_ROUTE = "SUSPEND_ROUTE";
    private static final String RESUME_ROUTE = "RESUME_ROUTE";
    private static final Object[][] contents = new Object[][]{{"GET_ROUTES", new Integer(1500), "get routes for {0}"}, {"GET_ROUTE", new Integer(1500), "get routes for {0}, {1}"}, {"SUSPEND_ROUTE", new Integer(1500), "suspend route {0} for {1}"}, {"RESUME_ROUTE", new Integer(1500), "resume route {0} for {1} {2}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSRoute(String string, String string2, String string3, RMSDomain rMSDomain) {
        super(string, string2 + "." + string3, rMSDomain);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty origin rep server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty distination rep server parameter.");
        Dbg.wassert(rMSDomain != null, "Null domain parameter.");
        this._origin = string2;
        this._destination = string3;
        this.setState(3);
        this.clearReasons();
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getRMSType() {
        return "Route";
    }

    @Override
    public String getOriginRS() {
        Dbg.wassert(this._origin != null && this._origin.length() > 0, "Null or empty origin rep server name attribute.");
        return this._origin;
    }

    @Override
    public String getDestinationRS() {
        Dbg.wassert(this._destination != null && this._destination.length() > 0, "Null or empty distination rep name attribute.");
        return this._destination;
    }

    @Override
    public String getIntermediateRS() {
        return this._thru == null ? "" : this._thru;
    }

    @Override
    public void setIntermediateRS(String string) {
        this._thru = string != null ? (string.trim().length() > 0 ? string : null) : null;
    }

    @Override
    public boolean isError() {
        return this.getRSState() == 2;
    }

    @Override
    public boolean isDirect() {
        return this.getIntermediateRS().length() == 0;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    public void setVersion(int n) {
        this._version = n < 1103 ? 1103 : n;
    }

    @Override
    public String getUsername() {
        return this._username == null ? "" : this._username;
    }

    @Override
    public void setUsername(String string) {
        this._username = string != null ? (string.trim().length() > 0 ? string : null) : null;
    }

    @Override
    public String getStateString() {
        if (this.isUp()) {
            return BundleManager.getString("RouteRes", "ACTIVE_STATE");
        }
        if (this.isWarning()) {
            return BundleManager.getString("RouteRes", "UNKNOWN_STATE");
        }
        return BundleManager.getString("RouteRes", "SUSPENDED_STATE");
    }

    @Override
    public int getColumnCount() {
        return 0;
    }

    @Override
    public Object getValueAt(int n) {
        return "";
    }

    @Override
    public void setValueAt(Object object, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRoutes(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        ArrayList<RMSRoute> arrayList = new ArrayList<RMSRoute>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_ROUTES, n, string);
            Dbg.wassert(string2 != null, "Unable to get route query, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    String string4 = rSMResultSet.getColumnString(2);
                    String[] stringArray = MessageText.parseRSComponent(string4);
                    if (stringArray.length != 2) continue;
                    RMSRoute rMSRoute = new RMSRoute(string3, stringArray[0], stringArray[1], rMSDomain);
                    String string5 = rSMResultSet.getColumnString(3);
                    if (!string5.equalsIgnoreCase(rMSRoute.getRMSType())) continue;
                    String string6 = rSMResultSet.getColumnString(4);
                    if (string6 != null && string6.length() > 0 && !string6.equals(stringArray[1])) {
                        rMSRoute.setIntermediateRS(string6);
                    }
                    rMSRoute.setState(rSMResultSet.getColumnInt(6));
                    String string7 = rSMResultSet.getColumnString(8);
                    if (string7 != null && string7.length() > 0) {
                        rMSRoute.addReason(string7);
                    }
                    arrayList.add(rMSRoute);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        return arrayList;
    }

    public static List getOriginRoutes(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        List list = RMSRoute.getRoutes(string, rMSDomain);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            RMSRoute rMSRoute = (RMSRoute)listIterator.next();
            if (rMSRoute.getOriginRS().equals(string)) continue;
            listIterator.remove();
        }
        return list;
    }

    @Override
    public int getUpgradeVersion() {
        return 0;
    }

    @Override
    public boolean isUpgradeCandidate() {
        return false;
    }

    @Override
    public boolean isRecoveryRequired() {
        return false;
    }

    @Override
    public boolean createDirect(String string, List list) {
        boolean bl = true;
        return bl;
    }

    @Override
    public void createDirect(String string) throws SQLException {
    }

    @Override
    public void createIndirect() throws SQLException {
    }

    @Override
    public void delete(List list, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadStatus() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection != null) {
            int n = this.getDomain().getRMSVersionNumber();
            Object[] objectArray = new String[]{this.getControllingServer(), this.getName()};
            String string = _cmdBundle.getCommand(GET_ROUTE, n, objectArray);
            Dbg.wassert(string != null, "Unable to get route query, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    this.setState(rSMResultSet.getColumnInt(6));
                    String string2 = rSMResultSet.getColumnString(8);
                    if (string2 != null && string2.length() > 0) {
                        this.addReason(string2);
                    }
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
    }

    @Override
    public void alterPassword(String string) throws SQLException {
    }

    @Override
    public void changeIntermediate(String string) throws SQLException {
    }

    @Override
    public void makeDirect(String string, String string2) throws SQLException {
    }

    @Override
    public void resume(final List list, final boolean bl) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("RouteRes", "RESUME_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!1.interrupted() && listIterator.hasNext()) {
                            RMSRoute rMSRoute = (RMSRoute)listIterator.next();
                            this.setStatus(BundleManager.getString("RouteRes", "RESUME_DLG_TITLE", rMSRoute.getName()));
                            rMSRoute.resume(bl);
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    RMSRoute.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void resume(boolean bl) throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        int n = this.getDomain().getRMSVersionNumber();
        Object[] objectArray = new String[]{this.getName(), this.getOriginRS(), bl ? "skip transaction" : ""};
        String string = _cmdBundle.getCommand(RESUME_ROUTE, n, objectArray);
        Dbg.wassert(string != null, "Unable to get resume route command, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    @Override
    public void suspend(final List list) {
        if (list != null && list.size() > 0) {
            String string = this.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            string = BundleManager.getString("RouteRes", "SUSPEND_DLG_TITLE", string);
            BkgndThread bkgndThread = new BkgndThread(string, this.getDomainName(), false){

                @Override
                public void run() {
                    try {
                        ListIterator listIterator = list.listIterator();
                        while (!2.interrupted() && listIterator.hasNext()) {
                            RMSRoute rMSRoute = (RMSRoute)listIterator.next();
                            this.setStatus(BundleManager.getString("RouteRes", "SUSPEND_DLG_TITLE", rMSRoute.getName()));
                            rMSRoute.suspend();
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    RMSRoute.this.getDomain().refreshStatus();
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void suspend() throws SQLException {
        RMSConnection rMSConnection = this.getDomain().getRMSConnection();
        if (rMSConnection == null) throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getOriginRS()), "_RSM_", 3);
        int n = this.getDomain().getRMSVersionNumber();
        Object[] objectArray = new String[]{this.getName(), this.getOriginRS()};
        String string = _cmdBundle.getCommand(SUSPEND_ROUTE, n, objectArray);
        Dbg.wassert(string != null, "Unable to get suspend route command, RMS version: " + n);
        RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
        try {
            rSMResultSet.open(string);
            if (!rSMResultSet.getNextRow() || rSMResultSet.getColumnCount() != 2) return;
            PluginSupport.LogInfoMessage(rSMResultSet.getColumnString(1), rSMResultSet.getColumnString(2));
            return;
        }
        finally {
            rSMResultSet.close();
            rMSConnection.unlock();
        }
    }

    @Override
    public String getRCLScript() {
        return "";
    }

    @Override
    public boolean upgrade() {
        return false;
    }

    @Override
    public boolean recover() {
        return false;
    }
}

