/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.route;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.ExternalSecurity;
import com.sybase.rsmplugin.components.route.RouteParameter;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RMSRouteParameter
extends RouteParameter {
    private RMSDomain _domain = null;
    private static final String GET_PARAMS = "GET_PARAMS";
    private static final String SET_PARAM = "SET_PARAM";
    private static final Object[][] contents = new Object[][]{{"GET_PARAMS", new Integer(1500), "configure routes {0}.{1} for {2}"}, {"SET_PARAM", new Integer(1500), "configure routes {0}.{1} for {2} {3}={4}"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSRouteParameter(String string, String string2, String string3, RMSDomain rMSDomain) {
        super(string, string2, string3);
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        this._domain = rMSDomain;
    }

    public RMSDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRouteParameters(String string, String string2, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty origin rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty destination rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        ArrayList<RMSRouteParameter> arrayList = new ArrayList<RMSRouteParameter>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            Object[] objectArray = new String[]{string, string2, string};
            String string3 = _cmdBundle.getCommand(GET_PARAMS, n, objectArray);
            Dbg.wassert(string3 != null, "Unable to get route parameter query command, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string3);
                while (rSMResultSet.getNextRow()) {
                    String string4 = rSMResultSet.getColumnString(5);
                    String string5 = rSMResultSet.getColumnString(6);
                    String string6 = rSMResultSet.getColumnString(7);
                    if (string4.equalsIgnoreCase("sec_options")) {
                        try {
                            int n2 = Integer.parseInt(string5);
                            String[][] stringArray = ExternalSecurity.getOptions(n2);
                            for (int i = 0; i < stringArray.length; ++i) {
                                RMSRouteParameter rMSRouteParameter = new RMSRouteParameter(stringArray[i][0], stringArray[i][1], stringArray[i][1], rMSDomain);
                                arrayList.add(rMSRouteParameter);
                            }
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    if (string4.equalsIgnoreCase("username")) continue;
                    RMSRouteParameter rMSRouteParameter = new RMSRouteParameter(string4, string5, string6, rMSDomain);
                    arrayList.add(rMSRouteParameter);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", string), "_RSM_", 3);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter(String string, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty origin rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty destination rep server parameter.");
        if (this.isModified()) {
            RMSConnection rMSConnection = this.getDomain().getRMSConnection();
            if (rMSConnection != null) {
                int n = this.getDomain().getRMSVersionNumber();
                Object[] objectArray = new String[]{string, string2, string, this.getName(), this.getPendingValue()};
                String string3 = _cmdBundle.getCommand(SET_PARAM, n, objectArray);
                Dbg.wassert(string3 != null, "Unable to get set parameter command, RMS version: " + n);
                RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
                try {
                    rSMResultSet.open(string3);
                    this.resetOriginalPendingValue();
                }
                finally {
                    rSMResultSet.close();
                    rMSConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", string), "_RSM_", 3);
            }
        }
    }

    @Override
    public String getRCLScript(String string, String string2) {
        String string3 = "";
        return string3;
    }
}

