/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.route;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCItem;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseAddItem;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseFolder;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.route.AddRouteWizard;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.components.route.RouteItem;
import com.sybase.rsmplugin.sql.Domain;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class RouteFolder
extends BaseFolder
implements RMContainer {
    public static final int CMD_ADD_ROUTE = 3008;
    private static final String CLASS_ID = "route.RouteFolder";
    private String _name = BundleManager.getString("RouteRes", "COL_FOLDER_NAME");
    private String _domain;

    public RouteFolder(String string, BaseContainer baseContainer) {
        super(baseContainer);
        this._domain = string;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public SCMenu getCreationMenu() {
        DefaultSCMenu defaultSCMenu = null;
        Domain domain = PluginSupport.getDomain(this._domain);
        if (domain != null && domain.isEnvironment()) {
            defaultSCMenu = new DefaultSCMenu();
            String string = BundleManager.getString("RouteRes", "MENU_ADD_ROUTE");
            String string2 = BundleManager.getString("RouteRes", "MENU_HINT_ADD_ROUTE");
            char c = BundleManager.getMnemonic("RouteRes", "MENU_MNEM_ADD_ROUTE");
            ImageIcon imageIcon = new ImageIcon(RSMImages.getRouteUp());
            MenuItem menuItem = new MenuItem(3008, string, string2, c, imageIcon);
            defaultSCMenu.addItem((SCMenuItem)menuItem);
        }
        return defaultSCMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 3008: {
                BaseController baseController = PluginSupport.getDialog(AddRouteWizard.class);
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                String string = this.getParent().getName();
                AddRouteWizard addRouteWizard = new AddRouteWizard(this.getParent(), PluginSupport.getDialogSupport(jFrame), string, this._domain);
                addRouteWizard.showDialog();
                break;
            }
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            Domain domain = PluginSupport.getDomain(this._domain);
            if (domain != null && domain.isEnvironment()) {
                this.addItem((SCItem)new AddRouteItem(this));
            }
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._domain);
            String string = this.getParent().getName();
            try {
                ListIterator listIterator = semanticFactory.getRoutes(string).listIterator();
                while (listIterator.hasNext()) {
                    RouteItem routeItem = new RouteItem((Route)listIterator.next(), this);
                    this.addItem((SCItem)routeItem);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("RouteRes", "COL_HEADER_ROUTE"), BundleManager.getString("RouteRes", "COL_HEADER_NEXT_SITE"), BundleManager.getString("RouteRes", "COL_HEADER_STATE"), BundleManager.getString("RouteRes", "COL_HEADER_REASON")};
    }

    class AddRouteItem
    extends BaseAddItem {
        String _rs;

        public AddRouteItem(BaseContainer baseContainer) {
            super(baseContainer, BundleManager.getString("RouteRes", "ADD_ROUTE_ITEM"), RSMImages.getAddRoute());
            this._rs = baseContainer.getParent().getName();
        }

        @Override
        public void displayWizard(JFrame jFrame) {
            BaseController baseController = PluginSupport.getDialog(AddRouteWizard.class);
            if (baseController != null) {
                baseController.requestFocus();
            } else {
                AddRouteWizard addRouteWizard = new AddRouteWizard(this.getParent(), PluginSupport.getDialogSupport(jFrame), this._rs, RouteFolder.this._domain);
                addRouteWizard.showDialog();
            }
        }
    }
}

