/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.route;

import com.sybase.asa.ASACheckBox;
import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMItem;
import com.sybase.rsmplugin.components.route.ResumeDlg;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.components.route.RouteProp;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RCLEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class RouteItem
extends BaseItem
implements RMItem,
StatusItem {
    private static final String CLASS_ID = "route.RouteItem";
    public static ImageIcon _iconUp = null;
    public static ImageIcon _iconDown = null;
    public static ImageIcon _iconSuspect = null;
    private Route _so;

    public RouteItem(Route route, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(route != null, "Null route semantic object parameter.");
        this._so = route;
        StatusManager.addStatusItem(this);
    }

    public RouteItem(Route route) {
        Dbg.wassert(route != null, "Null route semantic object parameter.");
        this._so = route;
        StatusManager.addStatusItem(this);
    }

    public Route getRoute() {
        return this._so;
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public Icon getStandardImage() {
        if (_iconUp == null) {
            _iconUp = new ImageIcon(RSMImages.getRouteUp());
        }
        return _iconUp;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getRoute().isUp()) {
            if (_iconUp == null) {
                _iconUp = new ImageIcon(RSMImages.getRouteUp());
            }
            return _iconUp;
        }
        if (this.getRoute().isWarning()) {
            if (_iconSuspect == null) {
                _iconSuspect = new ImageIcon(RSMImages.getRouteSuspect());
            }
            return _iconSuspect;
        }
        if (_iconDown == null) {
            _iconDown = new ImageIcon(RSMImages.getRouteDown());
        }
        return _iconDown;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getRoute().getIntermediateRS();
            }
            case 2: {
                return this.getRoute().getStateString();
            }
            case 3: {
                return this.getRoute().getReason();
            }
        }
        return "";
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106 || n == 3007 || n == 3006;
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu = null;
        defaultSCMenu = new DefaultSCMenu(BundleManager.getString("RouteRes", "MENU_ADD_ROUTE"));
        defaultSCMenu.setMnemonic((int)BundleManager.getMnemonic("RouteRes", "MENU_MNEM_ADD_ROUTE"));
        String string = BundleManager.getString("RouteRes", "MENU_RESUME");
        String string2 = BundleManager.getString("RouteRes", "MENU_HINT_RESUME");
        char c = BundleManager.getMnemonic("RouteRes", "MENU_MNEM_RESUME");
        MenuItem menuItem = new MenuItem(3006, string, string2, c);
        defaultSCMenu.addItem((SCMenuItem)menuItem);
        string = BundleManager.getString("RouteRes", "MENU_SUSPEND");
        string2 = BundleManager.getString("RouteRes", "MENU_HINT_SUSPEND");
        c = BundleManager.getMnemonic("RouteRes", "MENU_MNEM_SUSPEND");
        menuItem = new MenuItem(3007, string, string2, c);
        defaultSCMenu.addItem((SCMenuItem)menuItem);
        if (!this.getRoute().isControlledByRSMS()) {
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getRCLGenMenuItem());
            defaultSCMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        }
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        return defaultSCMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        if (this.getRoute().isControlledByRSMS()) {
            return 64;
        }
        return 96;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                ASACheckBox aSACheckBox = new ASACheckBox(BundleManager.getString("RouteRes", "DELETE_NOWAIT"));
                aSACheckBox.setMnemonic(BundleManager.getMnemonic("RouteRes", "DELETE_NOWAIT_MNEM"));
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list, (Component)aSACheckBox);
                if (!deleteItemsDlg.showDialog()) break;
                ArrayList<Route> arrayList = new ArrayList<Route>();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof RouteItem)) continue;
                    arrayList.add(((RouteItem)baseItem).getRoute());
                }
                if (arrayList.size() <= 0) break;
                this.getRoute().delete(arrayList, aSACheckBox.isSelected());
                break;
            }
            case 3001: {
                RCLEditor.open(this._so.getRCLScript());
                break;
            }
            case 100: 
            case 107: {
                BaseController baseController = PluginSupport.getDialog(RouteProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                RouteProp routeProp = new RouteProp(this.getRoute(), this, sCDialogSupport2);
                routeProp.showDialog();
                break;
            }
            case 3007: {
                if (!PluginSupport.askQuestion(BundleManager.getString("RouteRes", "CONFIRM_SUSPEND"))) break;
                ArrayList<Route> arrayList = new ArrayList<Route>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof RouteItem)) continue;
                    arrayList.add(((RouteItem)baseItem).getRoute());
                }
                if (arrayList.size() <= 0) break;
                this.getRoute().suspend(arrayList);
                break;
            }
            case 3006: {
                ResumeDlg resumeDlg = new ResumeDlg(PluginSupport.getDialogSupport(jFrame));
                if (!resumeDlg.showDialog()) break;
                ArrayList<Route> arrayList = new ArrayList<Route>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof RouteItem)) continue;
                    arrayList.add(((RouteItem)baseItem).getRoute());
                }
                if (arrayList.size() <= 0) break;
                this.getRoute().resume(arrayList, resumeDlg.getSkipFlag());
                break;
            }
        }
    }

    @Override
    public void setState(int n) {
        this.getRoute().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getRoute().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getRoute().getDomainName();
    }

    @Override
    public String getType() {
        return this.getRoute().getType();
    }

    @Override
    public String getStateDescription() {
        return this.getRoute().getStateString();
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }
}

