/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.route;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.ConfigPage;
import com.sybase.rsmplugin.components.ReasonListDlg;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.repserver.RepServer;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.components.route.RouteParameter;
import com.sybase.rsmplugin.components.route.RoutePropGeneralPanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RouteProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected Route _route;
    protected BaseItem _item;
    protected List _paramList;

    public RouteProp(Route route, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(route != null, "Null route SO parameter.");
        this._route = route;
        Dbg.wassert(baseItem != null, "Null parent BaseItem parameter.");
        this._item = baseItem;
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(route.getDomainName());
        try {
            route.loadStatus();
            route.loadProperties();
            this._paramList = semanticFactory.getRouteParameters(route.getOriginRS(), route.getDestinationRS());
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            this._paramList = new ArrayList();
        }
    }

    public Route getRoute() {
        return this._route;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("RouteRes", "PROPERTIES_TITLE", this.getRoute().getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new ConfigPage((BaseProperties)this, this._paramList)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            RouteParameter routeParameter = (RouteParameter)listIterator.next();
            if (routeParameter == null) continue;
            try {
                routeParameter.alter(this.getRoute().getOriginRS(), this.getRoute().getDestinationRS());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            return super.onOk();
        }
        return false;
    }

    @Override
    public void onApply() {
        boolean bl = false;
        ListIterator listIterator = this._paramList.listIterator();
        while (listIterator.hasNext()) {
            RouteParameter routeParameter = (RouteParameter)listIterator.next();
            if (routeParameter == null) continue;
            try {
                routeParameter.alter(this.getRoute().getOriginRS(), this.getRoute().getDestinationRS());
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                bl = true;
            }
        }
        if (!bl) {
            super.onApply();
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener,
    DocumentListener {
        private RoutePropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("LogicalConnectionRes", "GENERAL_PAGE_TAG"));
            this._goPage = new RoutePropGeneralPanel();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_name.setText(RouteProp.this.getRoute().getName());
            this._goPage.fld_version.setText(String.valueOf(RouteProp.this.getRoute().getVersion()));
            this._goPage.fld_version.setCaretPosition(0);
            this._goPage.fld_state.setText(RouteProp.this.getRoute().getStateString());
            this._goPage.fld_reason.setText(RouteProp.this.getRoute().getReason());
            this._goPage.fld_reason.setCaretPosition(0);
            this._goPage.btn_more.setEnabled(RouteProp.this.getRoute().getReasons().size() > 1);
            this._goPage.btn_more.addActionListener((ActionListener)this);
            if (RouteProp.this.getRoute().isControlledByRSMS()) {
                this._goPage.lbl_version.setVisible(false);
                this._goPage.fld_version.setVisible(false);
                this._goPage.rbn_direct.setVisible(false);
                this._goPage.rbn_indirect.setVisible(false);
                this._goPage.lbl_username.setVisible(false);
                this._goPage.fld_username.setVisible(false);
                this._goPage.lbl_password.setVisible(false);
                this._goPage.fld_password.setVisible(false);
                this._goPage.lbl_confirmPwd.setVisible(false);
                this._goPage.fld_confirmPwd.setVisible(false);
                this._goPage.lbl_intermediateRS.setVisible(false);
                this._goPage.cbx_intermediateRS.setVisible(false);
            } else {
                this._goPage.rbn_direct.setSelected(RouteProp.this.getRoute().isDirect());
                this._goPage.rbn_indirect.setSelected(!RouteProp.this.getRoute().isDirect());
                this._goPage.fld_username.setText(RouteProp.this.getRoute().getUsername());
                this.loadRepServers();
                this.enableAttrFields();
                this._goPage.rbn_direct.addActionListener((ActionListener)this);
                this._goPage.rbn_indirect.addActionListener((ActionListener)this);
                this._goPage.fld_username.getDocument().addDocumentListener(this);
                this._goPage.fld_password.getDocument().addDocumentListener(this);
                this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            }
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                try {
                    if (RouteProp.this.getRoute().isDirect()) {
                        if (this._goPage.rbn_direct.isSelected()) {
                            RouteProp.this.getRoute().alterPassword(this._goPage.fld_password.getPasswordString());
                        } else {
                            String string = this._goPage.cbx_intermediateRS.getSelectedString();
                            if (string != null && string.length() > 0) {
                                RouteProp.this.getRoute().changeIntermediate(string);
                            }
                        }
                    } else if (this._goPage.rbn_direct.isSelected()) {
                        String string = this._goPage.fld_username.getText();
                        if (string != null && string.length() > 0) {
                            RouteProp.this.getRoute().makeDirect(string, this._goPage.fld_password.getPasswordString());
                        }
                    } else {
                        String string = this._goPage.cbx_intermediateRS.getSelectedString();
                        if (string != null && string.length() > 0) {
                            RouteProp.this.getRoute().changeIntermediate(string);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
            }
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.rbn_direct) {
                this.enableAttrFields();
                this.setModified(this.isDirectModified());
            } else if (actionEvent.getSource() == this._goPage.rbn_indirect) {
                this.enableAttrFields();
                String string = this._goPage.cbx_intermediateRS.getSelectedString();
                boolean bl = string != null && string.length() > 0 && !string.equals(RouteProp.this.getRoute().getIntermediateRS());
                this.setModified(bl);
            } else if (actionEvent.getSource() == this._goPage.btn_more) {
                ReasonListDlg reasonListDlg = new ReasonListDlg(PluginSupport.getDialogSupport(this.getDialogSupport().getJDialog()), RouteProp.this.getRoute().getReasons(), RouteProp.this.getRoute().getName());
                reasonListDlg.showDialog();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(this.isDirectModified());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(this.isDirectModified());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(this.isDirectModified());
        }

        protected boolean isDirectModified() {
            String string;
            boolean bl = true;
            if (this._goPage.fld_username.isEnabled()) {
                string = this._goPage.fld_username.getText();
                bl = string != null && string.length() > 0;
            }
            string = this._goPage.fld_password.getPasswordString();
            String string2 = this._goPage.fld_confirmPwd.getPasswordString();
            bl = bl && string.equals(string2) && !string.equals("        ");
            return bl;
        }

        protected void enableAttrFields() {
            this._goPage.lbl_intermediateRS.setEnabled(this._goPage.rbn_indirect.isSelected());
            this._goPage.cbx_intermediateRS.setEnabled(this._goPage.rbn_indirect.isSelected());
            this._goPage.lbl_password.setEnabled(this._goPage.rbn_direct.isSelected());
            this._goPage.fld_password.setEnabled(this._goPage.rbn_direct.isSelected());
            boolean bl = this._goPage.rbn_direct.isSelected() && !RouteProp.this.getRoute().isDirect();
            this._goPage.lbl_username.setEnabled(bl);
            this._goPage.fld_username.setEnabled(bl);
            if (this._goPage.rbn_direct.isSelected()) {
                this._goPage.fld_password.requestFocusInWindow();
            } else {
                this._goPage.cbx_intermediateRS.requestFocusInWindow();
            }
        }

        protected void loadRepServers() {
            List list;
            SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(RouteProp.this.getRoute().getDomainName());
            if (semanticFactory != null && (list = semanticFactory.getRepServers()) != null) {
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    RepServer repServer = (RepServer)listIterator.next();
                    if (repServer.getName().equals(RouteProp.this.getRoute().getOriginRS()) || repServer.getName().equals(RouteProp.this.getRoute().getDestinationRS())) continue;
                    this._goPage.cbx_intermediateRS.addItem((Object)repServer.getName());
                }
                if (!RouteProp.this.getRoute().isDirect()) {
                    this._goPage.cbx_intermediateRS.setSelectedItem(RouteProp.this.getRoute().getIntermediateRS());
                }
            }
        }
    }
}

