/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rsthread;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.rsthread.RSThread;
import com.sybase.rsmplugin.components.rsthread.SpidComparator;
import com.sybase.rsmplugin.sql.RMSConnection;
import com.sybase.rsmplugin.sql.RMSDomain;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RMSRSThread
implements RSThread,
Comparable {
    private static final String SUSPENDED_SPID = "Null";
    private RMSDomain _domain = null;
    private String _rs = null;
    private String _spid = null;
    private String _type = null;
    private String _state = null;
    private String _info = null;
    private static final String GET_THREADS = "GET_THREADS";
    private static final String GET_DIST_THREADS = "GET_DIST_THREADS";
    private static final String GET_DSI_THREADS = "GET_DSI_THREADS";
    private static final String GET_RSI_THREADS = "GET_RSI_THREADS";
    private static final String GET_SQM_THREADS = "GET_SQM_THREADS";
    private static final String GET_SQT_THREADS = "GET_SQT_THREADS";
    private static final Object[][] contents = new Object[][]{{"GET_THREADS", new Integer(1500), "get threads for {0}"}, {"GET_DIST_THREADS", new Integer(1500), "get threads for {0} dist"}, {"GET_DSI_THREADS", new Integer(1500), "get threads for {0} dsi"}, {"GET_RSI_THREADS", new Integer(1500), "get threads for {0} rsi"}, {"GET_SQM_THREADS", new Integer(1500), "get threads for {0} sqm"}, {"GET_SQT_THREADS", new Integer(1500), "get threads for {0} sqt"}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public RMSRSThread(String string, String string2, RMSDomain rMSDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty spid parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        this._spid = string;
        this._rs = string2;
        this._domain = rMSDomain;
    }

    public int compareTo(Object object) {
        if (object instanceof RMSRSThread) {
            int n = 0;
            try {
                n = Integer.parseInt(this.getSpid());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(((RMSRSThread)object).getSpid());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return n - n2;
        }
        return -1;
    }

    @Override
    public String getName() {
        return this.getSpid();
    }

    public RMSDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return true;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRSThreads(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        ArrayList<RMSRSThread> arrayList = new ArrayList<RMSRSThread>();
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string2 = _cmdBundle.getCommand(GET_THREADS, n, string);
            Dbg.wassert(string2 != null, "Unable to get thread query, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    if ((string3 = string3.trim()) == null || string3.length() == 0) {
                        string3 = SUSPENDED_SPID;
                    }
                    RMSRSThread rMSRSThread = new RMSRSThread(string3, string, rMSDomain);
                    rMSRSThread.setThreadType(rSMResultSet.getColumnString(2));
                    rMSRSThread.setState(rSMResultSet.getColumnString(3));
                    rMSRSThread.setInfo(rSMResultSet.getColumnString(4));
                    arrayList.add(rMSRSThread);
                }
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List getDISTThreads(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        return RMSRSThread.getThreadDetails(string, rMSDomain, GET_DIST_THREADS);
    }

    public static List getDSIThreads(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        return RMSRSThread.getThreadDetails(string, rMSDomain, GET_DSI_THREADS);
    }

    public static List getRSIThreads(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        return RMSRSThread.getThreadDetails(string, rMSDomain, GET_RSI_THREADS);
    }

    public static List getSQMThreads(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        return RMSRSThread.getThreadDetails(string, rMSDomain, GET_SQM_THREADS);
    }

    public static List getSQTThreads(String string, RMSDomain rMSDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        return RMSRSThread.getThreadDetails(string, rMSDomain, GET_SQT_THREADS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List getThreadDetails(String string, RMSDomain rMSDomain, String string2) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty command constant parameter.");
        Dbg.wassert(rMSDomain != null, "Null RMS domain parameter.");
        List list = null;
        RMSConnection rMSConnection = rMSDomain.getRMSConnection();
        if (rMSConnection != null) {
            int n = rMSDomain.getRMSVersionNumber();
            String string3 = _cmdBundle.getCommand(string2, n, string);
            Dbg.wassert(string3 != null, "Unable to get thread query, RMS version: " + n);
            RSMResultSet rSMResultSet = new RSMResultSet(rMSConnection);
            try {
                rSMResultSet.open(string3);
                list = RMSRSThread.loadThreadList(rSMResultSet);
            }
            finally {
                rSMResultSet.close();
                rMSConnection.unlock();
            }
        }
        Collections.sort(list, new SpidComparator());
        return list;
    }

    protected static List loadThreadList(RSMResultSet rSMResultSet) throws SQLException {
        Dbg.wassert(rSMResultSet != null, "Null result set parameter.");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = rSMResultSet.getColumnCount();
        if (n > 0) {
            String string;
            ResultSetMetaData resultSetMetaData = rSMResultSet.getResultSetMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n];
            for (int i = 1; i <= n; ++i) {
                stringArray[i - 1] = i > n2 ? "" : ((string = resultSetMetaData.getColumnLabel(i)) != null ? string.trim() : "");
            }
            arrayList.add(stringArray);
            while (rSMResultSet.getNextRow()) {
                String[] stringArray2 = new String[n];
                for (int i = 1; i <= n; ++i) {
                    string = rSMResultSet.getColumnString(i);
                    stringArray2[i - 1] = string != null ? string.trim() : "";
                }
                arrayList.add(stringArray2);
            }
        }
        return arrayList;
    }

    @Override
    public String getSpid() {
        Dbg.wassert(this._spid != null && this._spid.length() > 0, "Null or empty spid attribute.");
        return this._spid;
    }

    @Override
    public String getThreadType() {
        Dbg.wassert(this._type != null && this._type.length() > 0, "Null or empty thread type attribute.");
        return this._type;
    }

    public void setThreadType(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty type parameter.");
        this._type = string.trim();
    }

    @Override
    public String getState() {
        Dbg.wassert(this._state != null && this._state.length() > 0, "Null or empty thread state attribute.");
        return this._state;
    }

    @Override
    public void setState(String string) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty state parameter.");
        this._state = string.trim();
    }

    @Override
    public String getInfo() {
        return this._info == null ? "" : this._info;
    }

    @Override
    public void setInfo(String string) {
        this._info = string == null ? "" : string.trim();
    }

    @Override
    public String getComponentName() {
        String string = "";
        string = this.isDSI() || this.isDIST() || this.getThreadType().equalsIgnoreCase("DSI EXEC") ? this.trimInfo() : this.getInfo();
        return string;
    }

    @Override
    public boolean isRepAgent() {
        return this.getThreadType().equalsIgnoreCase("REP AGENT");
    }

    @Override
    public boolean isDIST() {
        return this.getThreadType().equalsIgnoreCase("DIST");
    }

    @Override
    public boolean isDSI() {
        return this.getThreadType().equalsIgnoreCase("DSI");
    }

    @Override
    public boolean isRoute() {
        return this.getThreadType().equalsIgnoreCase("RSI");
    }

    @Override
    public boolean isQueue() {
        return this.getThreadType().equalsIgnoreCase("SQM") || this.getThreadType().equalsIgnoreCase("SQT");
    }

    @Override
    public boolean isUser() {
        return this.getThreadType().equalsIgnoreCase("USER");
    }

    @Override
    public boolean isDown() {
        return this.getState().equalsIgnoreCase("Down");
    }

    @Override
    public boolean isSuspended() {
        return this.getState().equalsIgnoreCase("Suspended");
    }

    protected String trimInfo() {
        int n;
        String string = this._info;
        if (string != null && string.length() > 0 && (n = (string = string.trim()).lastIndexOf(32)) >= 0) {
            string = string.substring(n);
            string = string.trim();
        }
        return string;
    }

    @Override
    public String getRepServer() {
        Dbg.wassert(this._rs != null && this._rs.length() > 0, "Null or empty Replication Server name attribute.");
        return this._rs;
    }

    @Override
    public String getReason() {
        String string = "";
        string = this.isDSI() && this.isSuspended() ? BundleManager.getString("RSThreadRes", "DSI_SUSPENDED", this.getComponentName()) : (this.isDSI() && this.isDown() ? BundleManager.getString("RSThreadRes", "DSI_DEAD", this.getComponentName()) : (this.isRepAgent() && this.isSuspended() ? BundleManager.getString("RSThreadRes", "RA_SUSPENDED", this.getComponentName()) : (this.isRepAgent() && this.isDown() ? BundleManager.getString("RSThreadRes", "RA_DEAD", this.getComponentName()) : (this.isRoute() && this.isSuspended() ? BundleManager.getString("RSThreadRes", "ROUTE_SUSPENDED", this.getComponentName()) : (this.isRoute() && this.isDown() ? BundleManager.getString("RSThreadRes", "ROUTE_DEAD", this.getComponentName()) : (this.isQueue() && this.isSuspended() ? BundleManager.getString("RSThreadRes", "QUEUE_SUSPENDED", this.getComponentName()) : (this.isQueue() && this.isDown() ? BundleManager.getString("RSThreadRes", "QUEUE_DEAD", this.getComponentName()) : this.getInfo())))))));
        return string;
    }
}

