/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rsthread;

import com.sybase.central.SCItem;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseDetailContainer;
import com.sybase.rsmplugin.components.rsthread.RSThreadDetailItem;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JFrame;

public abstract class RSThreadDetailContainer
extends BaseDetailContainer {
    private String _domainName;
    private String _rs;
    private BaseContainer _parent;
    private String[] _headers = null;

    public RSThreadDetailContainer(String string, String string2, String string3, BaseContainer baseContainer) {
        super(string);
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(baseContainer != null, "Null parent parameter.");
        this._domainName = string2;
        this._rs = string3;
        this._parent = baseContainer;
    }

    @Override
    public abstract String getPkgAndClass();

    public abstract List getDetailItemList() throws SQLException;

    public String getDomainName() {
        return this._domainName;
    }

    public String getRepServer() {
        return this._rs;
    }

    public BaseContainer getParent() {
        return this._parent;
    }

    @Override
    protected String[] getHeadings() {
        if (this._headers == null) {
            return new String[0];
        }
        return this._headers;
    }

    @Override
    public void open(int n) {
        this.close();
        try {
            ListIterator listIterator = this.getDetailItemList().listIterator();
            if (listIterator.hasNext()) {
                this._headers = (String[])listIterator.next();
            }
            while (listIterator.hasNext()) {
                String[] stringArray = (String[])listIterator.next();
                RSThreadDetailItem rSThreadDetailItem = this.createItem(stringArray, this.getDomainName(), this.getRepServer(), this.getParent());
                this.addItem((SCItem)rSThreadDetailItem);
            }
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }

    @Override
    public boolean onNotify(JFrame jFrame, int n, int n2) {
        return n != 205 || n2 != 1 && n2 != -1;
    }

    protected abstract RSThreadDetailItem createItem(String[] var1, String var2, String var3, BaseContainer var4);
}

