/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rsthread;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCContainerEvent;
import com.sybase.central.SCContainerListener;
import com.sybase.central.SCItem4;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMItem;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.connection.ConnectionItem;
import com.sybase.rsmplugin.components.connection.PhyConnection;
import com.sybase.rsmplugin.components.queue.QueueItem;
import com.sybase.rsmplugin.components.queue.RSQueue;
import com.sybase.rsmplugin.components.route.Route;
import com.sybase.rsmplugin.components.route.RouteItem;
import com.sybase.rsmplugin.components.rsthread.RSThread;
import com.sybase.rsmplugin.components.rsuser.RSUser;
import com.sybase.rsmplugin.components.rsuser.RSUserItem;
import com.sybase.rsmplugin.util.Dbg;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class RSThreadItem
extends BaseItem
implements RMItem,
SCContainerListener {
    private static final String CLASS_ID = "rsthread.RSThreadItem";
    private RSThread _so;
    private RMItem _relatedItem;

    public RSThreadItem(RSThread rSThread, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(rSThread != null, "Null Rep Server Semantic object parameter.");
        this._so = rSThread;
        this._relatedItem = this.createRelatedItem();
        if (this._relatedItem != null) {
            this._relatedItem.getParent().addContainerListener(this);
        }
    }

    public void containerChanged(SCContainerEvent sCContainerEvent) {
        if ((sCContainerEvent.getEventId() == 6 || sCContainerEvent.getEventId() == 3 || sCContainerEvent.getEventId() == 2) && sCContainerEvent.getSCItem() == this._relatedItem) {
            this.refresh();
        }
    }

    public RSThread getRSThread() {
        return this._so;
    }

    public RMItem getRelatedItem() {
        return this._relatedItem;
    }

    @Override
    public String getName() {
        return this._so.getSpid();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getRelatedItem() != null) {
            return this.getRelatedItem().getStandardImage();
        }
        if (this.getRSThread().isUser()) {
            return new ImageIcon(RSMImages.getUser());
        }
        return new ImageIcon(RSMImages.getThread());
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this._so.getThreadType();
            }
            case 2: {
                return this._so.getState();
            }
            case 3: {
                return this._so.getInfo();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        DefaultSCMenu defaultSCMenu = new DefaultSCMenu();
        if (this.getRelatedItem() != null) {
            SCMenu sCMenu = this.getRelatedItem().getContextMenu();
            defaultSCMenu.addItem((SCMenuItem)sCMenu);
        }
        defaultSCMenu.addItem((SCMenuItem)MenuItem.getCopyMenuItem());
        return defaultSCMenu;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        Vector<RMItem> vector = new Vector<RMItem>();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null || !(e instanceof RSThreadItem) || ((RSThreadItem)e).getRelatedItem() == null) continue;
            vector.add(((RSThreadItem)e).getRelatedItem());
        }
        if (vector.size() > 0) {
            this.getRelatedItem().onCommand(jFrame, n, vector.elements(), n2);
        }
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        int n = 8;
        if (this.getRelatedItem() != null) {
            n |= this.getRelatedItem().getEnabledViewerToolBarButtons(enumeration);
        }
        return n;
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        if (this.getRelatedItem() != null) {
            this.getRelatedItem().releaseResources();
        }
    }

    @Override
    public String getItemScript() {
        return this.getRSThread().getSpid() + "\t" + this.getRSThread().getThreadType() + "\t" + this.getRSThread().getState() + "\t" + this.getRSThread().getInfo() + "\n";
    }

    @Override
    public boolean isOkToBatch(int n) {
        boolean bl = false;
        if (n == 102) {
            bl = true;
        } else if (this.getRelatedItem() != null) {
            bl = this.getRelatedItem().isOkToBatch(n);
        }
        return bl;
    }

    @Override
    public SCItem4 getDuplicateItem() {
        return this;
    }

    protected RMItem createRelatedItem() {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getRSThread().getDomainName());
        BaseItem baseItem = null;
        if (this.getRSThread().isDSI() || this.getRSThread().isRepAgent() || this.getRSThread().isDIST()) {
            String string = this.getRSThread().getComponentName();
            int n = string.indexOf(46);
            if (n > 0 && n < string.length()) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                if (string2.length() > 0 && string3.length() > 0) {
                    PhyConnection phyConnection = semanticFactory.getPhyConnection(this.getRSThread().getRepServer(), string2, string3);
                    baseItem = new ConnectionItem(phyConnection, this.getParent());
                }
            }
        } else if (this.getRSThread().isRoute()) {
            String string = this.getRSThread().getComponentName();
            Route route = semanticFactory.getRoute(this.getRSThread().getRepServer(), this.getRSThread().getRepServer(), string);
            baseItem = new RouteItem(route, this.getParent());
        } else if (this.getRSThread().isQueue()) {
            int n;
            String[] stringArray;
            String string = this.getRSThread().getComponentName();
            if (string != null && string.length() > 0 && (stringArray = string.split("\\s+")).length >= 2 && stringArray.length <= 3 && (n = stringArray[0].indexOf(58)) >= 0) {
                String string4 = stringArray[0].trim().substring(0, n);
                int n2 = Integer.parseInt(string4);
                string4 = stringArray[0].trim().substring(n + 1);
                int n3 = Integer.parseInt(string4);
                String string5 = stringArray.length == 2 ? stringArray[1] : stringArray[2];
                RSQueue rSQueue = semanticFactory.getQueue(string5, n2, n3, this.getRSThread().getRepServer());
                baseItem = new QueueItem(rSQueue, this.getParent());
            }
        } else if (this.getRSThread().isUser() && !this.getRSThread().isControlledByRSMS()) {
            String string = this.getRSThread().getComponentName();
            RSUser rSUser = semanticFactory.getRSUser(string, this.getRSThread().getRepServer());
            baseItem = new RSUserItem(rSUser, this.getParent());
        }
        return baseItem;
    }
}

