/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rsuser;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.components.rsuser.RSUser;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DomainRSUser
implements RSUser {
    private EnvDomain _domain = null;
    private String _name = null;
    private String _rs = null;
    private String _password = null;
    public boolean _saPermission = false;
    public boolean _sourcePermission = false;
    public boolean _createPermission = false;
    public boolean _subscribePermission = false;
    private static final String GET_USERS = "GET_USERS";
    private static final String GET_USER = "GET_USER";
    private static final String CREATE_USER = "CREATE_USER";
    private static final String ALTER_USER = "ALTER_USER";
    private static final String DELETE_USER = "DELETE_USER";
    private static final String GRANT_PERMISSION = "GRANT_PERMISSION";
    private static final String REVOKE_PERMISSION = "REVOKE_PERMISSION";
    private static final Object[][] contents = new Object[][]{{"GET_USERS", new Integer(1200), "select username, permissions from rs_users"}, {"GET_USER", new Integer(1200), "select password, permissions, use_enc_password, enc_password from rs_users where username = ''{0}''"}, {"CREATE_USER", new Integer(1200), "create user \"{0}\" set password {1}"}, {"ALTER_USER", new Integer(1200), "alter user \"{0}\" set password {1}"}, {"DELETE_USER", new Integer(1200), "drop user \"{0}\""}, {"GRANT_PERMISSION", new Integer(1200), "grant {0} to \"{1}\""}, {"REVOKE_PERMISSION", new Integer(1200), "revoke {0} from \"{1}\""}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainRSUser(String string, String string2, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._name = string;
        this._rs = string2;
        this._domain = envDomain;
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getRSUsers(String string, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty controlling rep server name parameter.");
        Dbg.wassert(envDomain != null, "Null domain connection parameter.");
        int n = envDomain.getVersionNumber(string);
        String string2 = _cmdBundle.getCommand(GET_USERS, n);
        Dbg.wassert(string2 != null, "Unable to get query, repserver version: " + n);
        ArrayList<DomainRSUser> arrayList = new ArrayList<DomainRSUser>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(1);
                    if (string3 == null || string3.length() <= 0) continue;
                    DomainRSUser domainRSUser = new DomainRSUser(string3, string, envDomain);
                    int n2 = rSMResultSet.getColumnInt(2);
                    domainRSUser.parsePermissions(n2);
                    arrayList.add(domainRSUser);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    @Override
    public String getName() {
        Dbg.wassert(this._name != null && this._name.length() > 0, "Null or empty User name attribute.");
        return this._name;
    }

    @Override
    public String getRepServer() {
        Dbg.wassert(this._rs != null && this._rs.length() > 0, "Null or empty Replication Server name attribute.");
        return this._rs;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String string) {
        this._password = string;
    }

    @Override
    public boolean isSAPermissionSet() {
        return this._saPermission;
    }

    @Override
    public void setSAPermission(boolean bl) {
        this._saPermission = bl;
    }

    @Override
    public boolean isSourcePermissionSet() {
        return this._sourcePermission;
    }

    @Override
    public void setSourcePermission(boolean bl) {
        this._sourcePermission = bl;
    }

    @Override
    public boolean isCreatePermissionSet() {
        return this._createPermission;
    }

    @Override
    public void setCreatePermission(boolean bl) {
        this._createPermission = bl;
    }

    @Override
    public boolean isSubscribePermissionSet() {
        return this._subscribePermission;
    }

    @Override
    public void setSubscribePermission(boolean bl) {
        this._subscribePermission = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getRepServer());
        if (rSMConnection != null) {
            Object[] objectArray;
            String string;
            int n = rSMConnection.getVersionNumber();
            String string2 = this.getPassword();
            if (string2 == null || string2.length() == 0) {
                string2 = "null";
            }
            Dbg.wassert((string = _cmdBundle.getCommand(CREATE_USER, n, objectArray = new String[]{this.getName(), string2})) != null, "Unable to get create command, rep server version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("UserRes", "NULL_SERVER", this.getRepServer()), "_RSM_", 3);
        }
        if (this.isSAPermissionSet()) {
            this.alterPermission(true, "sa");
        }
        if (this.isSourcePermissionSet()) {
            this.alterPermission(true, "connect source");
        }
        if (this.isCreatePermissionSet()) {
            this.alterPermission(true, "create object");
        }
        if (this.isSubscribePermissionSet()) {
            this.alterPermission(true, "primary subscribe");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getRepServer());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            String string = _cmdBundle.getCommand(DELETE_USER, n, this.getName());
            Dbg.wassert(string != null, "Unable to get delete command, rep server version: " + n);
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("UserRes", "NULL_SERVER", this.getRepServer()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alter(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException {
        String string2;
        if (string == null || string.length() == 0) {
            string = "null";
        }
        if ((string2 = this.getPassword()) == null || string2.length() == 0) {
            string2 = "null";
        }
        if (!string2.equals(string)) {
            RSMConnection rSMConnection = this.getDomain().getConnection(this.getRepServer());
            if (rSMConnection != null) {
                int n = rSMConnection.getVersionNumber();
                Object[] objectArray = new String[]{this.getName(), string};
                String string3 = _cmdBundle.getCommand(ALTER_USER, n, objectArray);
                Dbg.wassert(string3 != null, "Unable to get alter command, rep server version: " + n);
                try {
                    rSMConnection.execute(string3);
                }
                finally {
                    rSMConnection.unlock();
                }
            } else {
                throw new SQLException(BundleManager.getString("UserRes", "NULL_SERVER", this.getRepServer()), "_RSM_", 3);
            }
        }
        if (this.isSAPermissionSet() != bl) {
            this.alterPermission(bl, "sa");
        }
        if (this.isSourcePermissionSet() != bl2) {
            this.alterPermission(bl2, "connect source");
        }
        if (this.isCreatePermissionSet() != bl3) {
            this.alterPermission(bl3, "create object");
        }
        if (this.isSubscribePermissionSet() != bl4) {
            this.alterPermission(bl4, "primary subscribe");
        }
    }

    @Override
    public String getPermissionString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isSAPermissionSet()) {
            arrayList.add("sa");
        }
        if (this.isSourcePermissionSet()) {
            arrayList.add("connect source");
        }
        if (this.isCreatePermissionSet()) {
            arrayList.add("create object");
        }
        if (this.isSubscribePermissionSet()) {
            arrayList.add("primary subscribe");
        }
        return CollectionUtility.toString(arrayList, ", ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alterPermission(boolean bl, String string) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty permission parameter.");
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getRepServer());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{string, this.getName()};
            String string2 = bl ? _cmdBundle.getCommand(GRANT_PERMISSION, n, objectArray) : _cmdBundle.getCommand(REVOKE_PERMISSION, n, objectArray);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("UserRes", "NULL_SERVER", this.getRepServer()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws SQLException {
        int n = this.getDomain().getVersionNumber(this.getRepServer());
        String string = _cmdBundle.getCommand(GET_USER, n, this.getName());
        Dbg.wassert(string != null, "Unable to get query, repserver version: " + n);
        ArrayList arrayList = new ArrayList();
        RSMConnection rSMConnection = this.getDomain().getRSSD(this.getRepServer());
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    this.setPassword(rSMResultSet.getColumnString(1));
                    int n2 = rSMResultSet.getColumnInt(2);
                    this.parsePermissions(n2);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
    }

    protected void parsePermissions(int n) {
        this.setSAPermission((n & 1) != 0);
        this.setSourcePermission((n & 2) != 0);
        this.setCreatePermission((n & 4) != 0);
        this.setSubscribePermission((n & 8) != 0);
    }
}

