/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rsuser;

import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMItem;
import com.sybase.rsmplugin.components.rsuser.RSUser;
import com.sybase.rsmplugin.components.rsuser.RSUserProp;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class RSUserItem
extends BaseItem
implements RMItem {
    private static final String CLASS_ID = "rsuser.RSUserItem";
    private RSUser _so;
    private static ImageIcon _icon = null;
    private static DefaultSCMenu _contextMenu = null;

    public RSUserItem(RSUser rSUser, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(rSUser != null, "Null Rep Server Semantic object parameter.");
        this._so = rSUser;
    }

    public RSUser getRSUser() {
        return this._so;
    }

    @Override
    public String getName() {
        return this._so.getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (_icon == null) {
            _icon = new ImageIcon(RSMImages.getUser());
        }
        return _icon;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this._so.getPermissionString();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        if (_contextMenu == null) {
            _contextMenu = new DefaultSCMenu(BundleManager.getString("UserRes", "MENU_ADD_USER"));
            _contextMenu.setMnemonic((int)BundleManager.getMnemonic("UserRes", "MENU_MNEM_ADD_USER"));
            _contextMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
            _contextMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        }
        return _contextMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                List list = CollectionUtility.enumToList(enumeration);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list);
                if (!deleteItemsDlg.showDialog()) break;
                PluginSupport.getViewerSupport().startWait();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof RSUserItem)) continue;
                    ((RSUserItem)baseItem).deleteUser();
                    listIterator.remove();
                }
                PluginSupport.refreshDomain(this);
                PluginSupport.getViewerSupport().endWait();
                break;
            }
            case 100: 
            case 107: {
                BaseController baseController = PluginSupport.getDialog(RSUserProp.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                try {
                    this.getRSUser().load();
                    SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                    RSUserProp rSUserProp = new RSUserProp(this, sCDialogSupport2);
                    rSUserProp.showDialog();
                }
                catch (SQLException sQLException) {
                    PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                }
                break;
            }
        }
    }

    protected void deleteUser() {
        try {
            this.getRSUser().delete();
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
    }
}

