/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.rsuser;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.rsuser.RSUser;
import com.sybase.rsmplugin.components.rsuser.RSUserItem;
import com.sybase.rsmplugin.components.rsuser.RSUserPanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RSUserProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected RSUser _user;
    protected boolean _newUser = false;
    protected String _username;
    protected String _connName;
    protected String _rs;
    protected BaseContainer _container;
    protected RSUserItem _item;
    protected String _password;
    protected boolean _saPermission;
    protected boolean _connectPermission;
    protected boolean _createPermission;
    protected boolean _subscribePermission;

    RSUserProp(String string, String string2, BaseContainer baseContainer, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty connection name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty replication server parameter.");
        Dbg.wassert(baseContainer != null, "Null or empty container parameter.");
        this._connName = string;
        this._rs = string2;
        this._container = baseContainer;
        this._newUser = true;
    }

    RSUserProp(RSUserItem rSUserItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(rSUserItem != null, "Null RSUser item parameter.");
        this._item = rSUserItem;
        this._user = this._item.getRSUser();
        this._password = this._user.getPassword();
        this._newUser = false;
    }

    RSUser getUser() {
        Dbg.wassert(this._user != null, "Null RSUser attribute.");
        return this._user;
    }

    @Override
    public String getTitle() {
        if (this._newUser) {
            return BundleManager.getString("UserRes", "NEW_USER_TITLE");
        }
        return BundleManager.getString("UserRes", "PROPERTIES_TITLE", this._item.getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onOk() {
        this.getDialogSupport().startWait();
        try {
            if (this._newUser) {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._connName);
                RSUser rSUser = semanticFactory.getRSUser(this._username, this._rs);
                rSUser.setPassword(this._password);
                rSUser.setSAPermission(this._saPermission);
                rSUser.setSourcePermission(this._connectPermission);
                rSUser.setCreatePermission(this._createPermission);
                rSUser.setSubscribePermission(this._subscribePermission);
                rSUser.create();
            } else {
                this.getUser().alter(this._password, this._saPermission, this._connectPermission, this._createPermission, this._subscribePermission);
            }
        }
        catch (SQLException sQLException) {
            PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        finally {
            this.getDialogSupport().endWait();
        }
        if (this._newUser) {
            PluginSupport.refreshDomain(this._container);
        } else {
            this._item.refresh();
        }
        return super.onOk();
    }

    class GeneralPage
    extends BasePropertyPage
    implements DocumentListener,
    ActionListener {
        private RSUserPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("UserRes", "GENERAL_PAGE_TAG"));
            this._goPage = new RSUserPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            if (RSUserProp.this._newUser) {
                JButton jButton = this.getDialogSupport().getStandardButtonById(4);
                jButton.setVisible(false);
                jButton.setEnabled(false);
            }
            if (RSUserProp.this._newUser) {
                this._goPage.fld_rsName.setText(RSUserProp.this._rs);
                this._goPage.fld_password.setText("        ");
                this._goPage.fld_username.getDocument().addDocumentListener(this);
                this._goPage.fld_username.requestFocus();
            } else {
                this._goPage.fld_username.setText(RSUserProp.this.getUser().getName());
                this._goPage.fld_username.setEnabled(false);
                this._goPage.fld_username.setEditable(false);
                this._goPage.fld_rsName.setText(RSUserProp.this.getUser().getRepServer());
                this._goPage.fld_password.setText("        ");
                this._goPage.chk_sa.setSelected(RSUserProp.this.getUser().isSAPermissionSet());
                this._goPage.chk_connect.setSelected(RSUserProp.this.getUser().isSourcePermissionSet());
                this._goPage.chk_create.setSelected(RSUserProp.this.getUser().isCreatePermissionSet());
                this._goPage.chk_subscribe.setSelected(RSUserProp.this.getUser().isSubscribePermissionSet());
                this._goPage.fld_password.requestFocus();
            }
            this._goPage.fld_password.getDocument().addDocumentListener(this);
            this._goPage.fld_confirmPwd.getDocument().addDocumentListener(this);
            this._goPage.chk_sa.addActionListener((ActionListener)this);
            this._goPage.chk_connect.addActionListener((ActionListener)this);
            this._goPage.chk_create.addActionListener((ActionListener)this);
            this._goPage.chk_subscribe.addActionListener((ActionListener)this);
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            String string = this._goPage.fld_username.getText();
            if (string == null || string.length() <= 0) {
                PluginSupport.showValidationError(this.getDialogSupport().getJDialog(), BundleManager.getString("UserRes", "BLANK_USERNAME"));
                this._goPage.fld_username.requestFocus();
                return false;
            }
            RSUserProp.this._username = string;
            String string2 = this._goPage.fld_password.getPasswordString();
            if (string2 != null && !string2.equals("        ")) {
                if (string2.equals(this._goPage.fld_confirmPwd.getPasswordString())) {
                    RSUserProp.this._password = string2;
                } else {
                    PluginSupport.showValidationError(this.getDialogSupport().getJDialog(), BundleManager.getString("UserRes", "PWD_MISMATCH"));
                    this._goPage.fld_password.requestFocus();
                    return false;
                }
            }
            RSUserProp.this._saPermission = this._goPage.chk_sa.isSelected();
            RSUserProp.this._connectPermission = this._goPage.chk_connect.isSelected();
            RSUserProp.this._createPermission = this._goPage.chk_create.isSelected();
            RSUserProp.this._subscribePermission = this._goPage.chk_subscribe.isSelected();
            return true;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setModified(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
        }
    }
}

