/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.storedprocedure;

import com.sybase.central.SCItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseFolder;
import com.sybase.rsmplugin.components.RMContainer;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedure;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedureBase;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedureContainer;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedureItem;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.JFrame;

public class StoredProcedureFolder
extends BaseFolder
implements RMContainer {
    public static final int CMD_ADD_TABLE = 3000;
    private static final String CLASS_ID = "table.StoredProcedureFolder";
    private String _name = BundleManager.getString("StoredProcedureRes", "COL_FOLDER_NAME");
    private String _domainName;
    private String _ds;
    private String _db;
    private String _lds = null;
    private String _ldb = null;
    private String _rs = null;

    public StoredProcedureFolder(String string, BaseContainer baseContainer, String string2, String string3) {
        super(baseContainer);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter.");
        this._domainName = string;
        this._ds = string2;
        this._db = string3;
    }

    public StoredProcedureFolder(String string, BaseContainer baseContainer, String string2, String string3, String string4) {
        super(baseContainer);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty Rep Server parameter.");
        this._domainName = string;
        this._ds = string2;
        this._db = string3;
        this._rs = string4;
    }

    public StoredProcedureFolder(String string, BaseContainer baseContainer, String string2, String string3, String string4, String string5, String string6) {
        super(baseContainer);
        Dbg.wassert(string != null && string.length() > 0, "Null or empty domain name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty logical data server parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty logical database parameter.");
        Dbg.wassert(string6 != null && string6.length() > 0, "Null or empty Rep Server parameter.");
        this._domainName = string;
        this._ds = string2;
        this._db = string3;
        this._lds = string4;
        this._ldb = string5;
        this._rs = string6;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    protected boolean isConnection() {
        return this._rs != null;
    }

    protected boolean isLogicalConnection() {
        return this._lds != null;
    }

    @Override
    public int getAttributes() {
        if (this.isConnection()) {
            return 1;
        }
        return super.getAttributes();
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            default: 
        }
    }

    @Override
    public void open(int n) {
        if (!this._isOpened) {
            this._isOpened = true;
            try {
                SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this._domainName);
                ListIterator listIterator = semanticFactory.getStoredProcedures(this._ds, this._db).listIterator();
                while (listIterator.hasNext()) {
                    StoredProcedureBase storedProcedureBase;
                    if (!this.isConnection()) {
                        storedProcedureBase = new StoredProcedureItem((StoredProcedure)listIterator.next(), this);
                        this.addItem((SCItem)storedProcedureBase);
                        continue;
                    }
                    Dbg.wassert(this._rs != null, "Null controlling repserver for TableContainer creation.");
                    if (this.isLogicalConnection()) {
                        storedProcedureBase = new StoredProcedureContainer((StoredProcedure)listIterator.next(), this._lds, this._ldb, this._rs, this);
                        this.addItem((SCItem)storedProcedureBase);
                        continue;
                    }
                    storedProcedureBase = new StoredProcedureContainer((StoredProcedure)listIterator.next(), this._rs, this);
                    this.addItem((SCItem)storedProcedureBase);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
    }

    @Override
    protected String[] getHeadings() {
        return new String[]{BundleManager.getString("StoredProcedureRes", "COL_HEADER_NAME"), BundleManager.getString("StoredProcedureRes", "COL_HEADER_OWNER"), BundleManager.getString("StoredProcedureRes", "COL_HEADER_STATUS")};
    }
}

