/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.storedprocedure;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.storedprocedure.Parameter;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedure;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedurePropColumnPanel;
import com.sybase.rsmplugin.components.storedprocedure.StoredProcedurePropGeneralPanel;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class StoredProcedureProp
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected StoredProcedure _storedprocedure = null;
    protected BaseItem _item = null;
    protected String _name;
    private boolean _enableRep = false;

    StoredProcedureProp(StoredProcedure storedProcedure, BaseItem baseItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(storedProcedure != null, "Null StoredProcedureSO item parameter.");
        Dbg.wassert(baseItem != null, "Null BaseItem parameter.");
        this._item = baseItem;
        this._storedprocedure = storedProcedure;
    }

    BaseItem getStoredProcedure() {
        Dbg.wassert(this._item != null, "Null StoredProcedure attribute.");
        return this._item;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("StoredProcedureRes", "PROPERTIES_TITLE", this._storedprocedure.getName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new ColumnPage(this)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return null;
    }

    @Override
    public void onApply() {
        if (this._pages[0].isModified()) {
            try {
                this._storedprocedure.alter(this._enableRep);
                super.onApply();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this._item.refresh();
        }
    }

    @Override
    public boolean onOk() {
        if (this._pages[0].isModified()) {
            try {
                this._storedprocedure.alter(this._enableRep);
                super.onApply();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            this._item.refresh();
        }
        return super.onOk();
    }

    class ColumnPage
    extends BasePropertyPage {
        private StoredProcedurePropColumnPanel _goPage;

        public ColumnPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("StoredProcedureRes", "COLUMN_PAGE_TAG"));
            this._goPage = new StoredProcedurePropColumnPanel();
        }

        @Override
        public void onInitDialog() {
            Object var1_1 = null;
            this._goPage.tbl_columns.requestFocus();
            ImageIcon imageIcon = null;
            imageIcon = new ImageIcon(RSMImages.getColumn());
            try {
                ListIterator listIterator = StoredProcedureProp.this._storedprocedure.getParameters().listIterator();
                while (listIterator.hasNext()) {
                    Parameter parameter = (Parameter)listIterator.next();
                    Vector<String> vector = new Vector<String>(2);
                    vector.add(parameter.getName());
                    vector.add(parameter.getFormattedDatatype());
                    this._goPage.tbl_columns.addRowWithIcon((Icon)imageIcon, vector);
                }
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            return true;
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private StoredProcedurePropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("StoredProcedureRes", "GENERAL_PAGE_TAG"));
            this._goPage = new StoredProcedurePropGeneralPanel();
        }

        @Override
        public void onInitDialog() {
            this._goPage.fld_storedProcedureName.setText(StoredProcedureProp.this._storedprocedure.getName());
            this._goPage.fld_owner.setText(StoredProcedureProp.this._storedprocedure.getOwner());
            String string = StoredProcedureProp.this._storedprocedure.getDataServer();
            String string2 = StoredProcedureProp.this._storedprocedure.getDatabase();
            this._goPage.fld_dsdb.setText(string + '.' + string2);
            this._goPage.chk_enableReplication.addActionListener((ActionListener)this);
            this._goPage.chk_enableReplication.requestFocus();
            if (StoredProcedureProp.this._storedprocedure.getReplicateStatus()) {
                this._goPage.chk_enableReplication.setSelected(true);
            } else {
                this._goPage.chk_enableReplication.setSelected(false);
            }
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void onHelp() {
        }

        @Override
        public boolean onOk() {
            if (this.isModified()) {
                StoredProcedureProp.this._enableRep = this._goPage.chk_enableReplication.isSelected();
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._goPage.chk_enableReplication) {
                this.setModified(true);
            }
        }
    }
}

