/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.subscription;

import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.bkgnd.BkgndThread;
import com.sybase.rsmplugin.components.BaseStatusSO;
import com.sybase.rsmplugin.components.SemanticFactory;
import com.sybase.rsmplugin.components.functionrepdef.FunctionRepDef;
import com.sybase.rsmplugin.components.subscription.Subscription;
import com.sybase.rsmplugin.components.tablerepdef.TableRepDef;
import com.sybase.rsmplugin.sql.EnvDomain;
import com.sybase.rsmplugin.sql.RSMConnection;
import com.sybase.rsmplugin.sql.RSMResultSet;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.CommandBundle;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;

public class DomainSub
extends BaseStatusSO
implements Subscription,
Cloneable {
    private static final int SUB_STAT_VALID_AT_ACTIVE_M = -1;
    private static final int SUB_STAT_NEW_M = 1;
    private static final int SUB_STAT_NEW_PRIMARY_UNDEFINED_M = 32;
    private static final int SUB_STAT_ACTIVATING_M = 2;
    private static final int SUB_STAT_Q_COMPLETE_M = 2;
    private static final int SUB_STAT_ACTIVE_M = 4;
    private static final int SUB_STAT_VALIDATING_M = 8;
    private static final int SUB_STAT_MATERIALIZED_M = 8;
    private static final int SUB_STAT_VALID_M = 16;
    private static final int SUB_STAT_VALID_AT_STANDBY_M = 64;
    private static final int SUB_STAT_REMOVED_AT_STANDBY_M = 128;
    private static final int SUB_STAT_SWITCH_SUSPECT_M = 0x2000000;
    private static final int SUB_STAT_DROP_SUSPECT_M = 0x4000000;
    private static final int SUB_STAT_PRIMARY_NEW_M = 256;
    private static final int SUB_STAT_PRIMARY_ACTIVATING_M = 512;
    private static final int SUB_STAT_PRIMARY_ACTIVE_M = 1024;
    private static final int SUB_STAT_PRIMARY_VALID_M = 2048;
    private static final int SUB_STAT_DEMATERIALIZING_M = 65536;
    private static final int SUB_STAT_REMOVING_M = 131072;
    private static final int SUB_STAT_PRIMARY_DEMATERIALIZING_M = 0x100000;
    private static final int SUB_STAT_INVALID_M = 0x1000000;
    private static final int SUB_STAT_REMAT_PUB_M = 0x10000000;
    private static final int SUB_STAT_ALLOW_TRUNC_M = 0x40000000;
    private static final int SUB_OK_C = 0;
    private static final int SUB_RECOVERING_C = 1;
    private static final int SUB_PENDING_C = 2;
    private static final int SUB_TYPE_SUB_M = 0;
    private static final int SUB_TYPE_RANGE_M = 1;
    private static final int SUB_TYPE_EQUALITY_M = 2;
    private static final int SUB_TYPE_ALL_M = 4;
    private static final int SUB_TYPE_TRIG_M = 16;
    private static final int SUB_TYPE_FRAG_M = 32;
    private static final int SUB_TYPE_PUBSUB_M = 8;
    private static final int SUB_TYPE_ARTSUB_M = 128;
    private static final int SUB_METH_DEFAULT_M = 0;
    private static final int SUB_METH_ATOMIC_M = 1;
    private static final int SUB_METH_BULK_M = 2;
    private static final int SUB_METH_SUSPEND_M = 4;
    private static final int SUB_METH_INCREMENTAL_M = 8;
    private static final int SUB_METH_NONATOMIC_M = 16;
    private static final int SUB_METH_PRIMARY_M = 32;
    private static final int SUB_METH_NOMETHOD_M = 64;
    private static final int SUB_METH_STANDBY_SUSP_M = 128;
    private static final int SUB_METH_BULKCREATE_M = 256;
    private static final int SUB_INVALID = 0;
    private static final int SUB_UNRECOVERABLE = 1;
    private static final int SUB_UNDEFINED = 2;
    private static final int SUB_DEMATERIALIZING = 3;
    private static final int SUB_MATERIALIZED = 4;
    private static final int SUB_REMOVING = 5;
    private static final int SUB_Q_COMPLETE = 6;
    private static final int SUB_ACTIVATING = 7;
    private static final int SUB_VALID_AT_ACTIVE = 8;
    private static final int SUB_DEFINED = 9;
    private static final int SUB_ACTIVE = 10;
    private static final int SUB_VALID = 11;
    private static final String TABLE_TYPE_PARM = "R";
    private static final int TABLE_SUB = 1;
    private static final int FUNCTION_SUB = 2;
    private EnvDomain _domain = null;
    private String _repServer = null;
    private String _ds = null;
    private String _db = null;
    private String _primaryDS = null;
    private String _primaryDB = null;
    private String _primaryOwner = null;
    private String _primaryObject = null;
    private String _primaryRS = null;
    private String _repdef = null;
    private String _subName = null;
    private String _username = null;
    private boolean _truncateTable = false;
    private boolean _autoCorrection = false;
    private String _repOwner = null;
    private String _repObjName = null;
    private int _type = 0;
    private String _whereClause = null;
    private boolean _subExists = false;
    private static final String GET_REPLICATE_SUBS = "GET_REPLICATE_SUBS";
    private static final String GET_PRIMARY_SUBS = "GET_PRIMARY_SUBS";
    private static final String GET_SUB = "GET_SUB";
    private static final String GET_HELP_SUB = "GET_HELP_SUB";
    private static final String CREATE_SUB = "CREATE_SUB";
    private static final String DEFINE_SUB = "DEFINE_SUB";
    private static final String DROP_SUB = "DROP_SUB";
    private static final String ACTIVATE_SUB = "ACTIVATE_SUB";
    private static final String VALIDATE_SUB = "VALIDATE_SUB";
    private static final String SET_TRUNC_TABLE = "SET_TRUNC_TABLE";
    private static final String SET_AUTO_CORRECT = "SET_AUTO_CORRECT";
    private static final Object[][] contents = new Object[][]{{"GET_REPLICATE_SUBS", new Integer(1200), "rmp_target_subscriptions ''{0}'', ''{1}'', ''{2}'', ''{3}'', ''{4}''"}, {"GET_PRIMARY_SUBS", new Integer(1200), "rmp_source_subscriptions ''{0}'', ''{1}'', ''{2}'', ''{3}'', ''{4}''"}, {"GET_SUB", new Integer(1200), "rmp_subscription ''{0}'', ''{1}'', ''{2}'', ''{3}'', ''{4}''"}, {"GET_HELP_SUB", new Integer(1200), "rs_helpsub ''{0}'', ''{1}'', ''{2}'', ''{3}''"}, {"DROP_SUB", new Integer(1200), "drop subscription \"{0}\" for \"{1}\" with replicate at {2}.{3} {4}"}, {"ACTIVATE_SUB", new Integer(1200), "activate subscription \"{0}\" for \"{1}\" with replicate at \"{2}\".\"{3}\" {4}"}, {"VALIDATE_SUB", new Integer(1200), "validate subscription \"{0}\" for \"{1}\" with replicate at \"{2}\".\"{3}\" "}, {"SET_TRUNC_TABLE", new Integer(1200), "sysadmin apply_truncate_table, \"{0}\", \"{1}\", \"{2}\", \"{3}\", ''{4}''"}, {"SET_AUTO_CORRECT", new Integer(1200), "set autocorrection {0} for \"{1}\" with replicate at \"{2}\".\"{3}\" "}, {"CREATE_SUB", new Integer(1200), "create subscription \"{0}\" for \"{1}\" with replicate at \"{2}\".\"{3}\" {4} {5} {6} "}, {"DEFINE_SUB", new Integer(1200), "define subscription \"{0}\" for \"{1}\" with replicate at \"{2}\".\"{3}\" {4} {5} "}};
    private static CommandBundle _cmdBundle = new CommandBundle(contents);

    public DomainSub(String string, String string2, String string3, String string4, String string5, EnvDomain envDomain) {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty rs parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty rep def parameter.");
        Dbg.wassert(envDomain != null, "Null domain parameter.");
        this._subName = string;
        this._repServer = string2;
        this._ds = string3;
        this._db = string4;
        this._repdef = string5;
        this._domain = envDomain;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public EnvDomain getDomain() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain;
    }

    @Override
    public String getDomainName() {
        Dbg.wassert(this._domain != null, "Null domain attribute.");
        return this._domain.getName();
    }

    @Override
    public boolean isControlledByRSMS() {
        return false;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getSubName() {
        Dbg.wassert(this._subName != null && this._subName.length() > 0, "Null or empty name attribute.");
        return this._subName;
    }

    @Override
    public String getName() {
        return this.getSubName() + " (" + this.getRepDefName() + ")";
    }

    @Override
    public String getControllingRS() {
        Dbg.wassert(this._repServer != null && this._repServer.length() > 0, "Null or empty RS name attribute.");
        return this._repServer;
    }

    @Override
    public String getDS() {
        Dbg.wassert(this._ds != null && this._ds.length() > 0, "Null or empty data server name attribute.");
        return this._ds;
    }

    @Override
    public String getDB() {
        Dbg.wassert(this._db != null && this._db.length() > 0, "Null or empty database name attribute.");
        return this._db;
    }

    @Override
    public String getRepDefName() {
        Dbg.wassert(this._repdef != null && this._repdef.length() > 0, "Null or empty rep def name attribute.");
        return this._repdef;
    }

    @Override
    public String getPrimaryDS() {
        return this._primaryDS;
    }

    @Override
    public String getPrimaryDB() {
        return this._primaryDB;
    }

    @Override
    public String getPrimaryOwner() {
        return this._primaryOwner;
    }

    @Override
    public String getPrimaryObject() {
        return this._primaryObject;
    }

    @Override
    public String getPrimaryRS() {
        return this._primaryRS;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public boolean isTable() {
        return this._type == 1;
    }

    @Override
    public String getRepObjectName() {
        return this._repObjName;
    }

    @Override
    public String getRepOwner() {
        return this._repOwner;
    }

    @Override
    public boolean getTruncateTable() {
        return this._truncateTable;
    }

    @Override
    public boolean getAutoCorrection() {
        return this._autoCorrection;
    }

    @Override
    public String getWhereClause() {
        return this._whereClause == null ? "" : this._whereClause;
    }

    @Override
    public boolean exists() {
        return this._subExists;
    }

    protected int getReplicateState() {
        return this.get1stState();
    }

    protected void setReplicateState(int n) {
        int n2 = this.getPrimaryState();
        this.setDualState(n, n2);
    }

    @Override
    public String getReplicateDesc() {
        String string = "";
        List list = this.getReasons();
        if (list != null && list.size() > 0) {
            string = (String)list.get(0);
        }
        return string;
    }

    protected void setReplicateDesc(String string) {
        String string2 = this.getPrimaryDesc();
        this.clearReasons();
        this.addReason(string != null ? string : "");
        this.addReason(string2 != null ? string2 : "");
    }

    protected int getPrimaryState() {
        return this.get2ndState();
    }

    protected void setPrimaryState(int n) {
        int n2 = this.getReplicateState();
        this.setDualState(n2, n);
    }

    @Override
    public String getPrimaryDesc() {
        String string = "";
        List list = this.getReasons();
        if (list != null && list.size() > 1) {
            string = (String)list.get(1);
        }
        return string;
    }

    protected void setPrimaryDesc(String string) {
        String string2 = this.getReplicateDesc();
        this.clearReasons();
        this.addReason(string2 != null ? string2 : "");
        this.addReason(string != null ? string : "");
    }

    @Override
    public String getStatus() {
        if (this.getPrimaryState() < this.getReplicateState()) {
            return this.getPrimaryDesc();
        }
        return this.getReplicateDesc();
    }

    @Override
    public boolean isActive() {
        return this.getReplicateState() == 10 && this.getPrimaryState() == 10;
    }

    @Override
    public boolean isDefined() {
        return this.getReplicateState() == 9 && this.getPrimaryState() == 9;
    }

    @Override
    public boolean isValid() {
        return this.getReplicateState() == 11 && this.getReplicateState() == 11;
    }

    @Override
    public boolean isUp() {
        return !(this.getReplicateState() != 9 && this.getReplicateState() != 10 && this.getReplicateState() != 11 || this.getPrimaryState() != 9 && this.getPrimaryState() != 10 && this.getPrimaryState() != 11);
    }

    @Override
    public boolean isError() {
        return !(this.getReplicateState() != 0 && this.getReplicateState() != 1 || this.getPrimaryState() != 0 && this.getPrimaryState() != 1);
    }

    @Override
    public boolean isWarning() {
        return !this.isUp() && !this.isError();
    }

    public static List getSubsAtReplicate(String string, String string2, String string3, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(false, "Method Not Implemented");
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public static List getSubsAtReplicate(String string, String string2, String string3, String string4, String string5, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty data server parameter.");
        Dbg.wassert(string3 != null && string3.length() > 0, "Null or empty database parameter.");
        Dbg.wassert(string4 != null && string4.length() > 0, "Null or empty owner parameter.");
        Dbg.wassert(string5 != null && string5.length() > 0, "Null or empty object parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        List list = DomainSub.loadSubsAtReplicate(string, string2, string3, string4, string5, envDomain);
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            DomainSub domainSub = (DomainSub)listIterator.next();
            domainSub.loadRepDef();
            domainSub.findPrimaryStatus();
        }
        return list;
    }

    public static List getSubsAtPrimary(String string, String string2, String string3, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(false, "Method Not Implemented");
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public static List getSubsAtPrimary(String string, String string2, String string3, String string4, String string5, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(false, "Method Not Implemented");
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws SQLException {
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        Object[] objectArray = new String[]{this.getControllingRS(), this.getRepDefName(), this.getDS(), this.getDB(), this.getSubName()};
        String string = _cmdBundle.getCommand(GET_SUB, n, objectArray);
        Dbg.wassert(string != null, "Unable to get the query subscription command, repserver version: " + n);
        RSMConnection rSMConnection = this.getDomain().getRSSD(this.getControllingRS());
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    this.loadDetails(rSMResultSet);
                    this._subExists = true;
                } else {
                    this._subExists = false;
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        this.loadRepDef();
        this.findPrimaryStatus();
    }

    protected static List loadSubsAtReplicate(String string, String string2, String string3, String string4, String string5, EnvDomain envDomain) throws SQLException {
        int n = envDomain.getVersionNumber(string);
        Object[] objectArray = new String[]{string, string2, string3, string4, string5};
        String string6 = _cmdBundle.getCommand(GET_REPLICATE_SUBS, n, objectArray);
        Dbg.wassert(string6 != null, "Unable to get the query subscription command, repserver version: " + n);
        return DomainSub.loadSubs(string, string6, envDomain);
    }

    protected static List loadSubsAtPrimary(String string, String string2, String string3, String string4, String string5, EnvDomain envDomain) throws SQLException {
        int n = envDomain.getVersionNumber(string);
        Object[] objectArray = new String[]{string, string2, string3, string4, string5};
        String string6 = _cmdBundle.getCommand(GET_PRIMARY_SUBS, n, objectArray);
        Dbg.wassert(string6 != null, "Unable to get the query subscription command, repserver version: " + n);
        return DomainSub.loadSubs(string, string6, envDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List loadSubs(String string, String string2, EnvDomain envDomain) throws SQLException {
        Dbg.wassert(string != null && string.length() > 0, "Null or empty rep server name parameter.");
        Dbg.wassert(string2 != null && string2.length() > 0, "Null or empty subscription command parameter.");
        Dbg.wassert(envDomain != null, "Null domain connnection parameter.");
        ArrayList<DomainSub> arrayList = new ArrayList<DomainSub>();
        RSMConnection rSMConnection = envDomain.getRSSD(string);
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string2);
                while (rSMResultSet.getNextRow()) {
                    String string3 = rSMResultSet.getColumnString(2);
                    String string4 = rSMResultSet.getColumnString(3);
                    String string5 = rSMResultSet.getColumnString(4);
                    String string6 = rSMResultSet.getColumnString(5);
                    String string7 = rSMResultSet.getColumnString(14);
                    if (string7 == null || string7.length() <= 0 || string4 == null || string4.length() <= 0 || string3 == null || string3.length() <= 0) continue;
                    DomainSub domainSub = new DomainSub(string4, string7, string5, string6, string3, envDomain);
                    domainSub.loadDetails(rSMResultSet);
                    domainSub._subExists = true;
                    arrayList.add(domainSub);
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return arrayList;
    }

    protected void loadDetails(RSMResultSet rSMResultSet) throws SQLException {
        if (rSMResultSet != null) {
            this._username = rSMResultSet.getColumnString(12);
            String string = rSMResultSet.getColumnString(16);
            this._type = string != null && string.equals(TABLE_TYPE_PARM) ? 1 : 2;
            this._repObjName = rSMResultSet.getColumnString(17);
            this._repOwner = rSMResultSet.getColumnString(18);
            int n = rSMResultSet.getColumnInt(6);
            int n2 = rSMResultSet.getColumnInt(7);
            int n3 = rSMResultSet.getColumnInt(8);
            boolean bl = rSMResultSet.getColumnInt(11) != 0;
            boolean bl2 = rSMResultSet.getColumnInt(13) != 0;
            this.loadPrimaryStatus(bl, n, n2);
            this.loadReplicateStatus(bl, n, n2, n3, bl2);
            this._truncateTable = (n & 0x40000000) == 0x40000000;
        }
    }

    protected void loadRepDef() throws SQLException {
        SemanticFactory semanticFactory = PluginSupport.getSemanticFactory(this.getDomain().getName());
        if (this.isTable()) {
            TableRepDef tableRepDef = semanticFactory.getTableRepDef(this.getControllingRS(), this.getRepDefName());
            if (tableRepDef != null) {
                String string = tableRepDef.getLDS();
                String string2 = tableRepDef.getLDB();
                this._primaryDS = string != null && string.length() > 0 ? string : tableRepDef.getDS();
                this._primaryDB = string2 != null && string2.length() > 0 ? string2 : tableRepDef.getDB();
                this._primaryOwner = tableRepDef.getPrimaryTableOwner();
                this._primaryObject = tableRepDef.getPrimaryTableName();
                this._primaryRS = tableRepDef.getControllingRS();
            }
        } else {
            FunctionRepDef functionRepDef = semanticFactory.getFunctionRepDef(this.getControllingRS(), this.getRepDefName());
            if (functionRepDef != null) {
                String string = functionRepDef.getLDS();
                String string3 = functionRepDef.getLDB();
                this._primaryDS = string != null && string.length() > 0 ? string : functionRepDef.getDS();
                this._primaryDB = string3 != null && string3.length() > 0 ? string3 : functionRepDef.getDB();
                this._primaryOwner = functionRepDef.getPhysProcOwner();
                this._primaryObject = functionRepDef.getPhysProcName();
                this._primaryRS = functionRepDef.getControllingRS();
            }
        }
    }

    protected void findPrimaryStatus() throws SQLException {
        if (this.getPrimaryRS() != null && !this.getPrimaryRS().equals(this.getControllingRS())) {
            List list = DomainSub.loadSubsAtPrimary(this.getPrimaryRS(), this.getPrimaryDS(), this.getPrimaryDB(), this.getPrimaryOwner(), this.getPrimaryObject(), this.getDomain());
            this.setPrimaryState(0);
            this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_INVALID"));
            ListIterator listIterator = list.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                DomainSub domainSub = (DomainSub)listIterator.next();
                if (!this.getName().equals(domainSub.getName())) continue;
                this.setPrimaryState(domainSub.getPrimaryState());
                this.setPrimaryDesc(domainSub.getPrimaryDesc());
                bl = true;
            }
        }
    }

    protected void loadPrimaryStatus(boolean bl, int n, int n2) {
        if (bl) {
            this.setPrimaryState(1);
            this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_ERROR"));
        } else {
            this.setPrimaryState(0);
            this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_INVALID"));
            if ((n & 0x100000) == 0x100000) {
                this.setPrimaryState(3);
                this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_DEMATER"));
            } else if ((n & 0x800) == 2048) {
                this.setPrimaryState(11);
                this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_VALID"));
            } else if ((n & 0x400) == 1024) {
                this.setPrimaryState(10);
                this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_ACTIVE"));
            } else if ((n & 0x200) == 512) {
                this.setPrimaryState(7);
                this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_ACTIVATING"));
            } else if ((n & 0x100) == 256) {
                this.setPrimaryState(9);
                this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_DEFINED"));
            } else if ((n & 0x20) == 32) {
                this.setPrimaryState(2);
                this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_UNDEFINED"));
            }
            if (n2 == 1) {
                this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_RECOVERING", this.getPrimaryDesc()));
            } else if (n2 == 2) {
                this.setPrimaryDesc(BundleManager.getString("SubRes", "STATUS_PENDING", this.getPrimaryDesc()));
            }
        }
    }

    protected void loadReplicateStatus(boolean bl, int n, int n2, int n3, boolean bl2) {
        if (bl) {
            this.setReplicateState(1);
            this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_ERROR"));
        } else {
            this.setReplicateState(0);
            this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_INVALID"));
            if ((n & 0x20000) == 131072) {
                this.setReplicateState(5);
                this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_REMOVING"));
            } else if ((n & 0x10000) == 65536) {
                this.setReplicateState(3);
                this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_DEMATER"));
            } else if ((n & 0x10) == 16) {
                if (bl2) {
                    if ((n & 0x40) == 64) {
                        this.setReplicateState(11);
                        this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_VALID"));
                    } else {
                        this.setReplicateState(8);
                        this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_ACTIVATING_STBY"));
                    }
                } else {
                    this.setReplicateState(11);
                    this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_VALID"));
                }
            } else if ((n & 8) == 8) {
                this.setReplicateState(4);
                if ((n3 & 2) == 2 || (n3 & 0x100) == 256) {
                    this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_VALIDATING"));
                } else {
                    this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_MATER"));
                }
            } else if ((n & 4) == 4 || (n & 2) == 2) {
                if ((n3 & 2) == 2 || (n3 & 0x100) == 256) {
                    if ((n & 4) == 4) {
                        this.setReplicateState(10);
                        this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_ACTIVE"));
                    } else {
                        this.setReplicateState(6);
                        this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_ACTIVATING"));
                    }
                } else if ((n3 & 1) == 1) {
                    if ((n & 4) == 4) {
                        this.setReplicateState(10);
                        this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_ACTIVE_COMPLETE"));
                    } else {
                        this.setReplicateState(6);
                        this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_COMPLETE"));
                    }
                } else if ((n & 4) == 4 && (n & 2) == 2) {
                    this.setReplicateState(10);
                    this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_ACTIVE_COMPLETE"));
                } else if ((n & 4) == 4) {
                    this.setReplicateState(10);
                    this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_ACTIVE_NOT_COMPLETE"));
                } else if ((n & 2) == 2) {
                    this.setReplicateState(6);
                    this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_COMPLETE"));
                }
            } else if ((n & 1) == 1) {
                this.setReplicateState(9);
                this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_DEFINED"));
            }
            if (n2 == 1) {
                this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_RECOVERING", this.getReplicateDesc()));
            } else if (n2 == 2) {
                this.setReplicateDesc(BundleManager.getString("SubRes", "STATUS_PENDING", this.getReplicateDesc()));
            }
        }
    }

    @Override
    public void loadProperties() throws SQLException {
        String string = this.getHelpDetails();
        this._whereClause = this.parseWhereClause(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHelpDetails() throws SQLException {
        int n = this.getDomain().getVersionNumber(this.getControllingRS());
        Object[] objectArray = new String[]{this.getSubName(), this.getRepDefName(), this.getDS(), this.getDB()};
        String string = _cmdBundle.getCommand(GET_HELP_SUB, n, objectArray);
        Dbg.wassert(string != null, "Unable to get the rs_helpsub command, repserver version: " + n);
        String string2 = "";
        RSMConnection rSMConnection = this.getDomain().getRSSD(this.getControllingRS());
        if (rSMConnection != null) {
            RSMResultSet rSMResultSet = new RSMResultSet(rSMConnection);
            try {
                rSMResultSet.open(string);
                if (rSMResultSet.getNextRow()) {
                    boolean bl = this._autoCorrection = rSMResultSet.getColumnInt(4) == 1;
                }
                if (!rSMResultSet.getNextResultSet()) {
                    String string3 = string2;
                    return string3;
                }
                if (rSMResultSet.getNextResultSet()) {
                    while (rSMResultSet.getNextRow()) {
                        string2 = string2 + rSMResultSet.getColumnString(1) + "\n";
                    }
                }
            }
            finally {
                rSMResultSet.close();
                rSMConnection.unlock();
            }
        }
        return string2;
    }

    protected String parseWhereClause(String string) {
        String string2 = null;
        String string3 = "\\bwhere\\b";
        Pattern pattern = Pattern.compile(string3, 2);
        String[] stringArray = pattern.split(string);
        if (stringArray.length > 1) {
            string2 = stringArray[1].trim();
            string3 = "\\bwithout holdlock\\b|\\bincrementally\\b|\\bwithout materialization\\b|\\bsubscribe to truncate table\\b|\\b\\for new articles\\b";
            pattern = Pattern.compile(string3, 2);
            String[] stringArray2 = pattern.split(string2);
            if (stringArray2.length > 0) {
                string2 = stringArray2[0].trim();
            }
        }
        return string2;
    }

    @Override
    public void create(String string, boolean bl, boolean bl2, String string2) throws SQLException {
        if (string != null && string.length() > 0) {
            if (bl2) {
                this.alterAutoCorrection(true);
            }
            int n = 0;
            if (string.equals(BundleManager.getString("SubRes", "MATERIAL_NONE"))) {
                this.doCreate("without materialization", bl, string2);
                n = 11;
            } else if (string.equals(BundleManager.getString("SubRes", "MATERIAL_ATOMIC"))) {
                this.doCreate("", bl, string2);
                n = 11;
            } else if (string.equals(BundleManager.getString("SubRes", "MATERIAL_NON_ATOMIC"))) {
                this.doCreate("without holdlock", bl, string2);
                n = 11;
            } else if (string.equals(BundleManager.getString("SubRes", "MATERIAL_INCREMENT"))) {
                this.doCreate("incrementally", bl, string2);
                n = 11;
            } else if (string.equals(BundleManager.getString("SubRes", "MATERIAL_BULK"))) {
                this.doDefine(bl, string2);
                n = 9;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            final int n2 = n;
            final String string3 = this.getName();
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("SubRes", "CREATE_BKGND_TITLE", this.getSubName()), this.getDomainName(), true){

                @Override
                public void run() {
                    try {
                        boolean bl = false;
                        while (!1.interrupted() && !bl) {
                            DomainSub.this.load();
                            Object[] objectArray = new String[]{DomainSub.this.getPrimaryDesc(), DomainSub.this.getReplicateDesc()};
                            this.setStatus(BundleManager.getString("SubRes", "CREATE_MONITORING", objectArray));
                            StatusManager.redisplay(this.getDomainName(), DomainSub.this.getType(), string3, DomainSub.this.getRSState(), DomainSub.this.getReasons());
                            if (DomainSub.this.getPrimaryState() >= n2 && DomainSub.this.getReplicateState() >= n2) {
                                bl = true;
                                continue;
                            }
                            Thread.sleep(2000L);
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!this.errorOccurred()) {
                        this.setStatus(BundleManager.getString("SubRes", "CREATE_LOG_MSG", DomainSub.this.getSubName()));
                    }
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreate(String string, boolean bl, String string2) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getSubName(), this.getRepDefName(), this.getDS(), this.getDB(), string2 != null && string2.length() > 0 ? "where " + string2 : string2, string, bl ? "subscribe to truncate table" : ""};
            String string3 = _cmdBundle.getCommand(CREATE_SUB, n, objectArray);
            try {
                rSMConnection.execute(string3);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDefine(boolean bl, String string) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getSubName(), this.getRepDefName(), this.getDS(), this.getDB(), string != null && string.length() > 0 ? "where " + string : string, bl ? "subscribe to truncate table" : ""};
            String string2 = _cmdBundle.getCommand(DEFINE_SUB, n, objectArray);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    @Override
    public void alter(boolean bl, boolean bl2) throws SQLException {
        if (bl != this.getTruncateTable()) {
            this.alterTruncateTable(bl);
        }
        if (bl2 != this.getAutoCorrection()) {
            this.alterAutoCorrection(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alterTruncateTable(boolean bl) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getDS(), this.getDB(), this.getRepOwner() == null ? "" : this.getRepOwner(), this.getRepObjectName(), bl ? "on" : "off"};
            String string = _cmdBundle.getCommand(SET_TRUNC_TABLE, n, objectArray);
            try {
                rSMConnection.execute(string);
                this._truncateTable = bl;
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alterAutoCorrection(boolean bl) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{bl ? "on" : "off", this.getRepDefName(), this.getDS(), this.getDB()};
            String string = _cmdBundle.getCommand(SET_AUTO_CORRECT, n, objectArray);
            try {
                rSMConnection.execute(string);
                this._autoCorrection = bl;
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    @Override
    public void delete(final List list, final String string) {
        if (list != null && list.size() > 0 && string != null && string.length() > 0) {
            DomainSub domainSub = (DomainSub)list.get(0);
            String string2 = domainSub.getSubName();
            if (list.size() > 1) {
                string2 = string2 + ", ...";
            }
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("SubRes", "DELETE_BKGND_TITLE", string2), this.getDomainName(), false){

                @Override
                public void run() {
                    ArrayList<String> arrayList = new ArrayList<String>(list.size());
                    try {
                        DomainSub domainSub;
                        ArrayList<DomainSub> arrayList2 = new ArrayList<DomainSub>(list.size());
                        ListIterator listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            domainSub = (DomainSub)listIterator.next();
                            this.setStatus(BundleManager.getString("SubRes", "DELETE_BKGND_TITLE", domainSub.getSubName()));
                            DomainSub domainSub2 = (DomainSub)domainSub.clone();
                            arrayList.add(domainSub2.getSubName());
                            arrayList2.add(domainSub2);
                            domainSub2.drop(string);
                        }
                        this.setStatus(BundleManager.getString("SubRes", "DELETE_MONITORING"));
                        while (!2.interrupted() && arrayList2.size() > 0) {
                            Thread.sleep(2000L);
                            listIterator = arrayList2.listIterator();
                            while (!2.interrupted() && listIterator.hasNext()) {
                                domainSub = (DomainSub)listIterator.next();
                                domainSub.load();
                                if (!domainSub.exists()) {
                                    StatusManager.delete(domainSub.getDomainName(), domainSub.getType(), domainSub.getName());
                                    listIterator.remove();
                                    continue;
                                }
                                StatusManager.redisplay(domainSub.getDomainName(), domainSub.getType(), domainSub.getName(), domainSub.getRSState(), domainSub.getReasons());
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!this.errorOccurred()) {
                        this.setStatus(BundleManager.getString("SubRes", "DELETE_LOG_MSG", CollectionUtility.toString(arrayList, ", ")));
                    }
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drop(String string) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            int n = rSMConnection.getVersionNumber();
            Object[] objectArray = new String[]{this.getSubName(), this.getRepDefName(), this.getDS(), this.getDB(), string};
            String string2 = _cmdBundle.getCommand(DROP_SUB, n, objectArray);
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("ConnectionRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    @Override
    public void activate(final List list, final String string) {
        if (list != null && list.size() > 0) {
            DomainSub domainSub = (DomainSub)list.get(0);
            String string2 = domainSub.getName();
            if (list.size() > 1) {
                string2 = string2 + ", ...";
            }
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("SubRes", "ACTIVATE_BKGND_TITLE", string2), this.getDomainName(), false){

                @Override
                public void run() {
                    ArrayList<String> arrayList = new ArrayList<String>(list.size());
                    try {
                        DomainSub domainSub;
                        ArrayList<DomainSub> arrayList2 = new ArrayList<DomainSub>(list.size());
                        ListIterator listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            domainSub = (DomainSub)listIterator.next();
                            this.setStatus(BundleManager.getString("SubRes", "ACTIVATE_BKGND_TITLE", domainSub.getSubName()));
                            DomainSub domainSub2 = (DomainSub)domainSub.clone();
                            arrayList.add(domainSub2.getSubName());
                            arrayList2.add(domainSub2);
                            domainSub2.activate(string);
                        }
                        this.setStatus(BundleManager.getString("DBSubRes", "ACTIVATE_MONITORING"));
                        while (!3.interrupted() && arrayList2.size() > 0) {
                            Thread.sleep(2000L);
                            listIterator = arrayList2.listIterator();
                            while (!3.interrupted() && listIterator.hasNext()) {
                                domainSub = (DomainSub)listIterator.next();
                                domainSub.load();
                                if (!domainSub.exists() || domainSub.isActive() || domainSub.isValid()) {
                                    listIterator.remove();
                                }
                                StatusManager.redisplay(domainSub.getDomainName(), domainSub.getType(), domainSub.getName(), domainSub.getRSState(), domainSub.getReasons());
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!this.errorOccurred()) {
                        this.setStatus(BundleManager.getString("SubRes", "ACTIVATE_LOG_MSG", CollectionUtility.toString(arrayList, ", ")));
                    }
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(String string) throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            String string2 = null;
            int n = this.getDomain().getVersionNumber(this.getControllingRS());
            Object[] objectArray = new String[]{this.getSubName(), this.getRepDefName(), this.getDS(), this.getDB(), string};
            string2 = _cmdBundle.getCommand(ACTIVATE_SUB, n, objectArray);
            Dbg.wassert(string2 != null, "Unable to get ACTIVATE Sub command.");
            try {
                rSMConnection.execute(string2);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("DBSubRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    @Override
    public void validate(final List list) {
        if (list != null && list.size() > 0) {
            DomainSub domainSub = (DomainSub)list.get(0);
            String string = domainSub.getName();
            if (list.size() > 1) {
                string = string + ", ...";
            }
            BkgndThread bkgndThread = new BkgndThread(BundleManager.getString("SubRes", "VALIDATE_BKGND_TITLE", string), this.getDomainName(), false){

                @Override
                public void run() {
                    ArrayList<String> arrayList = new ArrayList<String>(list.size());
                    try {
                        DomainSub domainSub;
                        ArrayList<DomainSub> arrayList2 = new ArrayList<DomainSub>(list.size());
                        ListIterator listIterator = list.listIterator();
                        while (listIterator.hasNext()) {
                            domainSub = (DomainSub)listIterator.next();
                            this.setStatus(BundleManager.getString("SubRes", "VALIDATE_BKGND_TITLE", domainSub.getSubName()));
                            DomainSub domainSub2 = (DomainSub)domainSub.clone();
                            arrayList.add(domainSub2.getSubName());
                            arrayList2.add(domainSub2);
                            domainSub2.validate();
                        }
                        this.setStatus(BundleManager.getString("DBSubRes", "VALIDATE_MONITORING"));
                        while (!4.interrupted() && arrayList2.size() > 0) {
                            Thread.sleep(2000L);
                            listIterator = arrayList2.listIterator();
                            while (!4.interrupted() && listIterator.hasNext()) {
                                domainSub = (DomainSub)listIterator.next();
                                domainSub.load();
                                if (!domainSub.exists() || domainSub.isValid()) {
                                    listIterator.remove();
                                }
                                StatusManager.redisplay(domainSub.getDomainName(), domainSub.getType(), domainSub.getName(), domainSub.getRSState(), domainSub.getReasons());
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                        this.setError(true);
                        this.setStatus(MessageText.formatExceptionMessage(sQLException));
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!this.errorOccurred()) {
                        this.setStatus(BundleManager.getString("SubRes", "VALIDATE_LOG_MSG", CollectionUtility.toString(arrayList, ", ")));
                    }
                    this.close();
                }
            };
            bkgndThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate() throws SQLException {
        RSMConnection rSMConnection = this.getDomain().getConnection(this.getControllingRS());
        if (rSMConnection != null) {
            String string = null;
            int n = this.getDomain().getVersionNumber(this.getControllingRS());
            Object[] objectArray = new String[]{this.getSubName(), this.getRepDefName(), this.getDS(), this.getDB()};
            string = _cmdBundle.getCommand(VALIDATE_SUB, n, objectArray);
            Dbg.wassert(string != null, "Unable to get VALIDATE Sub command.");
            try {
                rSMConnection.execute(string);
            }
            finally {
                rSMConnection.unlock();
            }
        } else {
            throw new SQLException(BundleManager.getString("DBSubRes", "NULL_SERVER", this.getControllingRS()), "_RSM_", 3);
        }
    }

    @Override
    public String getRCLScript() {
        String string = "-- Create subscription " + this.getSubName() + "\n";
        try {
            String string2 = this.getHelpDetails();
            string = string + string2;
        }
        catch (SQLException sQLException) {
            string = string + MessageText.formatExceptionMessage(sQLException) + "\n" + MessageText.formatSQLExceptionDetails(sQLException);
            PluginSupport.LogErrorMessage(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
        }
        return string;
    }
}

