/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.subscription;

import com.sybase.asa.ASABaseGridBagPanel;
import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASAGOConstants;
import com.sybase.asa.ASALabel;
import com.sybase.central.DefaultSCMenu;
import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCHeader;
import com.sybase.central.SCMenu;
import com.sybase.central.SCMenuItem;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseContainer;
import com.sybase.rsmplugin.components.BaseController;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.DeleteItemsDlg;
import com.sybase.rsmplugin.components.MenuItem;
import com.sybase.rsmplugin.components.RMItem;
import com.sybase.rsmplugin.components.subscription.ActivateDlg;
import com.sybase.rsmplugin.components.subscription.SubProperties;
import com.sybase.rsmplugin.components.subscription.Subscription;
import com.sybase.rsmplugin.status.StatusItem;
import com.sybase.rsmplugin.status.StatusManager;
import com.sybase.rsmplugin.util.CollectionUtility;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.RCLEditor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class SubItem
extends BaseItem
implements RMItem,
StatusItem {
    private static final String CLASS_ID = "subscription.SubItem";
    private static final int CMD_VALIDATE = 3008;
    private static final int CMD_ACTIVATE = 3009;
    private static final int CMD_DIAGNOSE = 3010;
    private Subscription _so;
    private static ImageIcon _tableIcon = null;
    private static ImageIcon _functionIcon = null;
    private static DefaultSCMenu _contextMenu = null;
    private SCHeader[] _headers = null;

    public SubItem(Subscription subscription, BaseContainer baseContainer) {
        super(baseContainer);
        Dbg.wassert(subscription != null, "Null physical connection semantic object parameter.");
        this._so = subscription;
        StatusManager.addStatusItem(this);
    }

    public Subscription getSubscription() {
        return this._so;
    }

    @Override
    public String getName() {
        return this.getSubscription().getName();
    }

    @Override
    public String getPkgAndClass() {
        return CLASS_ID;
    }

    @Override
    public Icon getImage(boolean bl) {
        if (this.getSubscription().isTable()) {
            if (_tableIcon == null) {
                _tableIcon = new ImageIcon(RSMImages.getTableSub());
            }
            return _tableIcon;
        }
        if (_functionIcon == null) {
            _functionIcon = new ImageIcon(RSMImages.getFunctionSub());
        }
        return _functionIcon;
    }

    @Override
    public String getDisplayName(int n) {
        switch (n) {
            case 0: {
                return this.getSubscription().getSubName();
            }
            case 1: {
                return this.getSubscription().getStatus();
            }
            case 2: {
                return this.getSubscription().getControllingRS();
            }
            case 3: {
                return this.getSubscription().getRepDefName();
            }
        }
        return "";
    }

    @Override
    public SCMenu getContextMenu() {
        _contextMenu = new DefaultSCMenu();
        String string = BundleManager.getString("SubRes", "MENU_ACTIVATE_DBSUB");
        String string2 = BundleManager.getString("SubRes", "MENU_HINT_ACTIVATE_DBSUB");
        char c = BundleManager.getMnemonic("SubRes", "MENU_MNEM_ACTIVATE_DBSUB");
        MenuItem menuItem = new MenuItem(3009, string, string2, c);
        _contextMenu.addItem((SCMenuItem)menuItem);
        if (this.getSubscription().isDefined()) {
            menuItem.setEnabled(true);
        } else {
            menuItem.setEnabled(false);
        }
        string = BundleManager.getString("SubRes", "MENU_VALIDATE_DBSUB");
        string2 = BundleManager.getString("SubRes", "MENU_HINT_VALIDATE_DBSUB");
        c = BundleManager.getMnemonic("SubRes", "MENU_MNEM_VALIDATE_DBSUB");
        menuItem = new MenuItem(3008, string, string2, c);
        _contextMenu.addItem((SCMenuItem)menuItem);
        if (this.getSubscription().isActive()) {
            menuItem.setEnabled(true);
        } else {
            menuItem.setEnabled(false);
        }
        _contextMenu.addItem((SCMenuItem)MenuItem.getRCLGenMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getDeleteMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getSeparatorMenuItem());
        _contextMenu.addItem((SCMenuItem)MenuItem.getPropertiesMenuItem());
        return _contextMenu;
    }

    @Override
    public int getEnabledViewerToolBarButtons(Enumeration enumeration) {
        return 96;
    }

    @Override
    public boolean isOkToBatch(int n) {
        return n == 106 || n == 3009 || n == 3008;
    }

    @Override
    public void onCommand(JFrame jFrame, int n, Enumeration enumeration, int n2) {
        switch (n) {
            case 106: {
                String string;
                String[] stringArray;
                List list = CollectionUtility.enumToList(enumeration);
                ASALabel aSALabel = new ASALabel(BundleManager.getString("SubRes", "DEL_METHOD"));
                aSALabel.setDisplayedMnemonic(BundleManager.getMnemonic("SubRes", "DEL_METHOD_MNEM"));
                ASAComboBox aSAComboBox = null;
                if (this.getSubscription().isTable()) {
                    stringArray = new String[]{BundleManager.getString("SubRes", "DEL_SUSPEND"), BundleManager.getString("SubRes", "DEL_NO_PURGE"), BundleManager.getString("SubRes", "DEL_PURGE"), BundleManager.getString("SubRes", "DEL_PURGE_INC")};
                    aSAComboBox = new ASAComboBox((Object[])stringArray);
                } else {
                    stringArray = new String[]{BundleManager.getString("SubRes", "DEL_SUSPEND"), BundleManager.getString("SubRes", "DEL_NO_PURGE")};
                    aSAComboBox = new ASAComboBox((Object[])stringArray);
                }
                aSALabel.setLabelFor((Component)aSAComboBox);
                stringArray = new ASABaseGridBagPanel();
                stringArray.add((Component)aSALabel, 0, 0, 1, 1, 0.0, 0.0, 17, 0, ASAGOConstants.INSETS, 0, 0);
                stringArray.add((Component)aSAComboBox, 1, 0, 0, 1, 1.0, 0.0, 17, 2, ASAGOConstants.INSETS, 0, 0);
                DeleteItemsDlg deleteItemsDlg = new DeleteItemsDlg(PluginSupport.getDialogSupport(jFrame), list, (Component)stringArray);
                if (!deleteItemsDlg.showDialog()) break;
                switch (aSAComboBox.getSelectedIndex()) {
                    case 0: {
                        string = "without purge with suspension";
                        break;
                    }
                    case 1: {
                        string = "without purge";
                        break;
                    }
                    case 2: {
                        string = "with purge";
                        break;
                    }
                    case 3: {
                        string = "incrementally with purge";
                        break;
                    }
                    default: {
                        String string2 = "";
                        return;
                    }
                }
                ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    BaseItem baseItem = (BaseItem)listIterator.next();
                    if (!(baseItem instanceof SubItem)) continue;
                    arrayList.add(((SubItem)baseItem).getSubscription());
                }
                if (arrayList.size() > 0) {
                    this.getSubscription().delete(arrayList, string);
                }
                PluginSupport.refreshDomain(this);
                break;
            }
            case 3009: {
                ActivateDlg activateDlg = new ActivateDlg(PluginSupport.getDialogSupport(jFrame));
                if (!activateDlg.showDialog()) break;
                ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof SubItem)) continue;
                    arrayList.add(((SubItem)baseItem).getSubscription());
                }
                if (arrayList.size() > 0) {
                    this.getSubscription().activate(arrayList, activateDlg.getSuspensionOption());
                }
                PluginSupport.refreshDomain(this);
                break;
            }
            case 3008: {
                if (!PluginSupport.askQuestion(BundleManager.getString("SubRes", "CONFIRM_VALIDATE"))) break;
                ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
                while (enumeration.hasMoreElements()) {
                    BaseItem baseItem = (BaseItem)enumeration.nextElement();
                    if (!(baseItem instanceof SubItem)) continue;
                    arrayList.add(((SubItem)baseItem).getSubscription());
                }
                if (arrayList.size() > 0) {
                    this.getSubscription().validate(arrayList);
                }
                PluginSupport.refreshDomain(this);
                break;
            }
            case 3010: {
                break;
            }
            case 3001: {
                RCLEditor.open(this._so.getRCLScript());
                break;
            }
            case 100: 
            case 107: {
                BaseController baseController = PluginSupport.getDialog(SubProperties.class, this.getName());
                if (baseController != null) {
                    baseController.requestFocus();
                    break;
                }
                SCDialogSupport2 sCDialogSupport2 = PluginSupport.getDialogSupport(jFrame);
                SubProperties subProperties = new SubProperties(this, sCDialogSupport2);
                subProperties.showDialog();
                break;
            }
        }
    }

    @Override
    public void setState(int n) {
        this.getSubscription().setState(n);
    }

    @Override
    public void setReasons(List list) {
        this.getSubscription().setReasons(list);
    }

    @Override
    public String getDomainName() {
        return this.getSubscription().getDomainName();
    }

    @Override
    public String getType() {
        return this.getSubscription().getType();
    }

    @Override
    public String getStateDescription() {
        return null;
    }

    @Override
    public Icon getImage() {
        return this.getImage(false);
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        StatusManager.removeStatusItem(this);
    }
}

