/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.rsmplugin.components.subscription;

import com.sybase.central.SCDialogSupport2;
import com.sybase.central.SCPageController;
import com.sybase.rsmplugin.BundleManager;
import com.sybase.rsmplugin.PluginSupport;
import com.sybase.rsmplugin.RSMImages;
import com.sybase.rsmplugin.components.BaseItem;
import com.sybase.rsmplugin.components.BaseProperties;
import com.sybase.rsmplugin.components.BasePropertyPage;
import com.sybase.rsmplugin.components.subscription.SubItem;
import com.sybase.rsmplugin.components.subscription.SubPropGeneralPanel;
import com.sybase.rsmplugin.components.subscription.SubPropWherePanel;
import com.sybase.rsmplugin.components.subscription.Subscription;
import com.sybase.rsmplugin.util.Dbg;
import com.sybase.rsmplugin.util.MessageText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class SubProperties
extends BaseProperties {
    protected SCPageController[] _pages = null;
    protected Subscription _so;
    protected SubItem _item;
    boolean _truncateTable;
    boolean _autoCorrection;

    public SubProperties(SubItem subItem, SCDialogSupport2 sCDialogSupport2) {
        super(sCDialogSupport2);
        Dbg.wassert(subItem != null, "Null parent BaseItem parameter.");
        this._item = subItem;
        Dbg.wassert(subItem.getSubscription() != null, "Null semantic Queue parameter.");
        this._so = subItem.getSubscription();
    }

    public Subscription getSubscription() {
        return this._so;
    }

    @Override
    public String getTitle() {
        return BundleManager.getString("SubRes", "PROPERTIES_TITLE", this.getSubscription().getSubName());
    }

    @Override
    public SCPageController[] getPageControllers() {
        if (this._pages == null) {
            this._pages = new SCPageController[]{new GeneralPage(this), new WherePage(this)};
        }
        return this._pages;
    }

    @Override
    public BaseItem getItem() {
        return this._item;
    }

    @Override
    public boolean onOk() {
        if (this.getSubscription().isTable()) {
            try {
                this.getSubscription().alter(this._truncateTable, this._autoCorrection);
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
                return false;
            }
        }
        return super.onOk();
    }

    @Override
    public void onApply() {
        if (this.getSubscription().isTable()) {
            try {
                this.getSubscription().alter(this._truncateTable, this._autoCorrection);
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
        }
        super.onApply();
    }

    class WherePage
    extends BasePropertyPage {
        private SubPropWherePanel _goPage;

        public WherePage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("SubRes", "WHERE_PAGE_TAG"));
            this._goPage = new SubPropWherePanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            this._goPage.txt_editor.setEditable(false);
            this._goPage.txt_editor.setText(SubProperties.this.getSubscription().getWhereClause());
        }

        @Override
        public boolean onOk() {
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }
    }

    class GeneralPage
    extends BasePropertyPage
    implements ActionListener {
        private SubPropGeneralPanel _goPage;

        public GeneralPage(BaseProperties baseProperties) {
            super(baseProperties, BundleManager.getString("SubRes", "GENERAL_PAGE_TAG"));
            this._goPage = new SubPropGeneralPanel();
            this.setPreferredWidth();
        }

        @Override
        public void onInitDialog() {
            try {
                SubProperties.this.getSubscription().loadProperties();
            }
            catch (SQLException sQLException) {
                PluginSupport.showError(MessageText.formatExceptionMessage(sQLException), MessageText.formatSQLExceptionDetails(sQLException));
            }
            if (!SubProperties.this.getSubscription().isTable()) {
                this._goPage.lbl_image.setIcon((Icon)new ImageIcon(RSMImages.getFunctionSubLarge()));
                this._goPage.lbl_priObj.setText(BundleManager.getString("SubRes", "STORED_PROCEDURE"));
                this._goPage.lbl_repObj.setText(BundleManager.getString("SubRes", "STORED_PROCEDURE"));
            }
            this._goPage.fld_name.setText(SubProperties.this.getSubscription().getSubName());
            this._goPage.fld_primaryStatus.setText(SubProperties.this.getSubscription().getPrimaryDesc());
            this._goPage.fld_replicateStatus.setText(SubProperties.this.getSubscription().getReplicateDesc());
            this._goPage.fld_priConn.setText(SubProperties.this.getSubscription().getPrimaryDS() + "." + SubProperties.this.getSubscription().getPrimaryDB());
            String string = SubProperties.this.getSubscription().getPrimaryOwner();
            if (string != null && string.length() > 0) {
                this._goPage.fld_priObj.setText(SubProperties.this.getSubscription().getPrimaryOwner() + "." + SubProperties.this.getSubscription().getPrimaryObject());
            } else {
                this._goPage.fld_priObj.setText(SubProperties.this.getSubscription().getPrimaryObject());
            }
            this._goPage.fld_priRepDef.setText(SubProperties.this.getSubscription().getRepDefName());
            this._goPage.fld_repConn.setText(SubProperties.this.getSubscription().getDS() + "." + SubProperties.this.getSubscription().getDB());
            String string2 = SubProperties.this.getSubscription().getRepOwner();
            string2 = string2 != null && string2.trim().length() > 0 ? string2.trim() + "." + SubProperties.this.getSubscription().getRepObjectName() : SubProperties.this.getSubscription().getRepObjectName();
            this._goPage.fld_repObj.setText(string2);
            if (SubProperties.this.getSubscription().isTable()) {
                this._goPage.chk_truncTable.setSelected(SubProperties.this.getSubscription().getTruncateTable());
                this._goPage.chk_autoCorrect.setSelected(SubProperties.this.getSubscription().getAutoCorrection());
                this._goPage.chk_autoCorrect.addActionListener((ActionListener)this);
                this._goPage.chk_truncTable.addActionListener((ActionListener)this);
            } else {
                this._goPage.chk_autoCorrect.setVisible(false);
                this._goPage.chk_truncTable.setVisible(false);
            }
        }

        @Override
        public boolean onOk() {
            SubProperties.this._truncateTable = this._goPage.chk_truncTable.isSelected();
            SubProperties.this._autoCorrection = this._goPage.chk_autoCorrect.isSelected();
            return true;
        }

        @Override
        public JPanel getJPanel() {
            return this._goPage;
        }

        @Override
        public void releaseResources() {
            this._goPage.releaseResources();
            this._goPage = null;
            super.releaseResources();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setModified(true);
        }
    }
}

